/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.CodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.InvokeTagParser;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class RenderBodyParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.RENDER_BODY;
    }

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Regex r = RenderBodyParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("bad @renderBody statement. Correct usage: @renderBody(params...)", new Object[0]);
                }
                this.step(r.stringMatched().length());
                String paramS = r.stringMatched(3);
                InvokeTagParser.ParameterDeclarationList params = new InvokeTagParser.ParameterDeclarationList();
                InvokeTagParser.InvokeTagToken.parseParams(paramS, params);
                return new RenderBodyToken(params, this.ctx());
            }
        };
    }

    @Override
    protected String patternStr() {
        return "^(%s%s\\s*((?@()))\\s*)";
    }

    public static void main(String[] args) {
        Regex r = new RenderBodyParser().reg(new Rythm());
        if (r.search("@renderBody(ab: 1, foo.bar())")) {
            // empty if block
        }
        RenderBodyParser.p(r, 6);
    }

    private static class RenderBodyToken
    extends CodeToken {
        protected InvokeTagParser.ParameterDeclarationList params;

        RenderBodyToken(InvokeTagParser.ParameterDeclarationList params, IContext ctx) {
            super("", ctx);
            this.params = params;
        }

        @Override
        public void output() {
            this.pline("{", new Object[0]);
            this.ptline("com.greenlaw110.rythm.runtime.ITag.ParameterList _pl = null; ", new Object[0]);
            if (this.params.pl.size() > 0) {
                this.ptline("_pl = new com.greenlaw110.rythm.runtime.ITag.ParameterList();", new Object[0]);
                for (int i = 0; i < this.params.pl.size(); ++i) {
                    InvokeTagParser.ParameterDeclaration pd = this.params.pl.get(i);
                    this.pt("_pl.add(\"").p(pd.nameDef == null ? "" : pd.nameDef).p("\",").p(pd.valDef).p(");");
                    this.pline();
                }
            }
            this.ptline("_pTagBody(_pl);", new Object[0]);
            this.pline("}", new Object[0]);
        }
    }
}

