/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.play;

import com.greenlaw110.rythm.IByteCodeHelper;
import com.greenlaw110.rythm.IHotswapAgent;
import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.cache.ICacheService;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.ILoggerFactory;
import com.greenlaw110.rythm.play.ActionTagBridge;
import com.greenlaw110.rythm.play.Cache4;
import com.greenlaw110.rythm.play.FastRythmTag;
import com.greenlaw110.rythm.play.FastRythmTags;
import com.greenlaw110.rythm.play.FastTagBridge;
import com.greenlaw110.rythm.play.ImplicitVariables;
import com.greenlaw110.rythm.play.JavaExtensionBridge;
import com.greenlaw110.rythm.play.PlayRythmLogger;
import com.greenlaw110.rythm.play.RythmTemplateLoader;
import com.greenlaw110.rythm.play.VirtualFileTemplateResourceLoader;
import com.greenlaw110.rythm.play.parsers.AbsoluteUrlReverseLookupParser;
import com.greenlaw110.rythm.play.parsers.GroovyVerbatimTagParser;
import com.greenlaw110.rythm.play.parsers.MessageLookupParser;
import com.greenlaw110.rythm.play.parsers.UrlReverseLookupParser;
import com.greenlaw110.rythm.play.utils.ActionInvokeProcessor;
import com.greenlaw110.rythm.runtime.ITag;
import com.greenlaw110.rythm.spi.IExpressionProcessor;
import com.greenlaw110.rythm.spi.IParserFactory;
import com.greenlaw110.rythm.spi.ITemplateExecutionExceptionHandler;
import com.greenlaw110.rythm.template.ITemplate;
import com.greenlaw110.rythm.template.TemplateBase;
import com.greenlaw110.rythm.utils.IDurationParser;
import com.greenlaw110.rythm.utils.IImplicitRenderArgProvider;
import com.greenlaw110.rythm.utils.IRythmListener;
import com.greenlaw110.rythm.utils.S;
import com.stevesoft.pat.Regex;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.cache.Cache;
import play.classloading.ApplicationClasses;
import play.classloading.HotswapAgent;
import play.classloading.enhancers.ControllersEnhancer;
import play.exceptions.UnexpectedException;
import play.mvc.Http;
import play.mvc.Scope;
import play.mvc.results.Error;
import play.mvc.results.NotFound;
import play.mvc.results.Redirect;
import play.mvc.results.RenderTemplate;
import play.mvc.results.Result;
import play.templates.Template;
import play.vfs.VirtualFile;

public class RythmPlugin
extends PlayPlugin {
    public static final String VERSION = "1.0.0-RC2";
    public static final String R_VIEW_ROOT = "app/rythm";
    public static RythmEngine engine;
    public static boolean underscoreImplicitVariableName;
    public static boolean refreshOnRender;
    public static String templateRoot;
    public static List<ImplicitVariables.Var> implicitRenderArgs;
    public static final String ACTION_CALL_FLAG_KEY = "__RYTHM_PLUGIN_ACTION_CALL_";
    public static final Template VOID_TEMPLATE;

    public static void info(String msg, Object ... args) {
        Logger.info((String)RythmPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    public static void info(Throwable t, String msg, Object ... args) {
        Logger.info((Throwable)t, (String)RythmPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    public static void debug(String msg, Object ... args) {
        Logger.debug((String)RythmPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    public static void debug(Throwable t, String msg, Object ... args) {
        Logger.debug((Throwable)t, (String)RythmPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    public static void trace(String msg, Object ... args) {
        Logger.trace((String)RythmPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    public static void trace(Throwable t, String msg, Object ... args) {
        Logger.warn((Throwable)t, (String)RythmPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    public static void warn(String msg, Object ... args) {
        Logger.warn((String)RythmPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    public static void warn(Throwable t, String msg, Object ... args) {
        Logger.warn((Throwable)t, (String)RythmPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    public static void error(String msg, Object ... args) {
        Logger.error((String)RythmPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    public static void error(Throwable t, String msg, Object ... args) {
        Logger.error((Throwable)t, (String)RythmPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    public static void fatal(String msg, Object ... args) {
        Logger.fatal((String)RythmPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    public static void fatal(Throwable t, String msg, Object ... args) {
        Logger.fatal((Throwable)t, (String)RythmPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    private static String msg_(String msg, Object ... args) {
        return String.format("RythmPlugin-1.0.0-RC2> %1$s", String.format(msg, args));
    }

    public static void registerImplicitRenderArg(String name, String type) {
        implicitRenderArgs.add(new ImplicitVariables.Var(name, type){

            @Override
            protected Object evaluate() {
                return Scope.RenderArgs.current().get(this.name());
            }
        });
    }

    public static void loadTemplatePaths() {
        for (VirtualFile mroot : Play.modules.values()) {
            VirtualFile mviews = mroot.child(R_VIEW_ROOT);
            if (!mviews.exists()) continue;
            Play.templatesPath.add(0, mviews);
        }
        VirtualFile rythm = VirtualFile.open((File)Play.applicationPath).child(R_VIEW_ROOT);
        if (rythm.exists()) {
            Play.templatesPath.add(0, rythm);
        }
    }

    public void onLoad() {
        RythmPlugin.loadTemplatePaths();
    }

    public void onConfigurationRead() {
        boolean gae;
        Properties playConf = Play.configuration;
        underscoreImplicitVariableName = Boolean.parseBoolean(playConf.getProperty("rythm.implicitVariable.underscore", "false"));
        refreshOnRender = Boolean.parseBoolean(playConf.getProperty("rythm.resource.refreshOnRender", "true"));
        Properties p = new Properties();
        p.put("rythm.pluginVersion", VERSION);
        p.put("rythm.tag.autoscan", (Object)false);
        p.put("rythm.classLoader.parent", Play.classloader);
        p.put("rythm.resource.refreshOnRender", "true");
        p.put("rythm.resource.loader", new VirtualFileTemplateResourceLoader());
        p.put("rythm.classLoader.byteCodeHelper", new IByteCodeHelper(){

            public byte[] findByteCode(String typeName) {
                ApplicationClasses classBag = Play.classes;
                if (classBag.hasClass(typeName)) {
                    ApplicationClasses.ApplicationClass applicationClass = classBag.getApplicationClass(typeName);
                    return applicationClass.enhancedByteCode;
                }
                return null;
            }
        });
        p.put("rythm.logger.factory", new ILoggerFactory(){

            public ILogger getLogger(Class<?> clazz) {
                return PlayRythmLogger.instance;
            }
        });
        p.put("rythm.enableJavaExtensions", (Object)true);
        p.put("rythm.implicitRenderArgProvider", new IImplicitRenderArgProvider(){

            public Map<String, ?> getRenderArgDescriptions() {
                HashMap<String, String> m = new HashMap<String, String>();
                for (ImplicitVariables.Var var : implicitRenderArgs) {
                    m.put(var.name(), var.type);
                }
                for (ImplicitVariables.Var var : ImplicitVariables.vars) {
                    m.put(var.name(), var.type);
                }
                return m;
            }

            public void setRenderArgs(ITemplate template) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                for (ImplicitVariables.Var var : ImplicitVariables.vars) {
                    m.put(var.name(), var.evaluate());
                }
                template.setRenderArgs(m);
            }

            public List<String> getImplicitImportStatements() {
                return Arrays.asList("controllers.*", "models.*");
            }
        });
        RythmPlugin.debug("Implicit render variables set up", new Object[0]);
        p.put("rythm.cache.prodOnly", "true");
        p.put("rythm.cache.defaultTTL", (Object)3600);
        p.put("rythm.cache.service", new ICacheService(){
            private int defaultTTL = 3600;

            public void put(String key, Serializable value, int ttl) {
                Cache.cacheImpl.set(key, (Object)value, ttl);
            }

            public void put(String key, Serializable value) {
                Cache.cacheImpl.set(key, (Object)value, this.defaultTTL);
            }

            public Serializable remove(String key) {
                Object o = Cache.get((String)key);
                Cache.delete((String)key);
                return null == o ? null : (o instanceof Serializable ? (Serializable)o : o.toString());
            }

            public Serializable get(String key) {
                Object o = Cache.get((String)key);
                return null == o ? null : (o instanceof Serializable ? (Serializable)o : o.toString());
            }

            public boolean contains(String key) {
                Object o = Cache.get((String)key);
                return null != o;
            }

            public void clean() {
                Cache.clear();
            }

            public void setDefaultTTL(int ttl) {
                this.defaultTTL = ttl;
            }

            public void shutdown() {
            }
        });
        p.put("rythm.cache.durationParser", new IDurationParser(){

            public int parseDuration(String s) {
                if (null == s) {
                    return RythmPlugin.engine.defaultTTL;
                }
                String confDuration = Play.configuration.getProperty(s);
                if (null != confDuration) {
                    s = confDuration;
                }
                if ("forever".equals(confDuration)) {
                    return -1;
                }
                return IDurationParser.DEFAULT_PARSER.parseDuration(s);
            }
        });
        for (String key : playConf.stringPropertyNames()) {
            if (!key.startsWith("rythm.")) continue;
            p.setProperty(key, playConf.getProperty(key));
        }
        RythmPlugin.debug("User defined rythm properties configured", new Object[0]);
        templateRoot = p.getProperty("rythm.root", templateRoot);
        p.put("rythm.root", new File(Play.applicationPath, templateRoot));
        if (Logger.isDebugEnabled()) {
            RythmPlugin.debug("rythm template root set to: %s", p.get("rythm.root"));
        }
        if (!(gae = Boolean.valueOf(Play.configuration.getProperty("rythm.gae", "false")).booleanValue())) {
            File tmpDir = new File(Play.tmpDir, "rythm");
            tmpDir.mkdirs();
            p.put("rythm.tmpDir", tmpDir);
            if (Logger.isDebugEnabled()) {
                RythmPlugin.debug("rythm tmp dir set to %s", p.get("rythm.tmpDir"));
            }
        } else {
            RythmPlugin.warn("GAE enabled", new Object[0]);
            p.put("rythm.noFileWrite", (Object)true);
        }
        boolean useHotswapAgent = Boolean.valueOf(playConf.getProperty("rythm.useHotswapAgent", "false"));
        if (useHotswapAgent) {
            p.put("rythm.classLoader.hotswapAgent", new IHotswapAgent(){

                public void reload(ClassDefinition ... definitions) throws UnmodifiableClassException, ClassNotFoundException {
                    HotswapAgent.reload((ClassDefinition[])definitions);
                }
            });
        }
        p.put("rythm.mode", Play.mode.isDev() ? Rythm.Mode.dev : Rythm.Mode.prod);
        if (null == engine) {
            engine = new RythmEngine(p);
            engine.registerListener(new IRythmListener(){

                public void onRender(ITemplate template) {
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    for (ImplicitVariables.Var var : ImplicitVariables.vars) {
                        m.put(var.name(), var.evaluate());
                    }
                    template.setRenderArgs(m);
                }
            });
            Rythm.engine = engine;
            IParserFactory[] factories = new IParserFactory[]{new AbsoluteUrlReverseLookupParser(), new UrlReverseLookupParser(), new MessageLookupParser(), new GroovyVerbatimTagParser()};
            engine.getExtensionManager().registerUserDefinedParsers(factories).registerTemplateExecutionExceptionHandler(new ITemplateExecutionExceptionHandler(){

                public boolean handleTemplateExecutionException(Exception e, TemplateBase template) {
                    if (e instanceof Result) {
                        if (e instanceof RenderTemplate) {
                            template.p((Object)((RenderTemplate)e).getContent());
                        } else {
                            Http.Response resp = new Http.Response();
                            resp.out = new ByteArrayOutputStream();
                            ((Result)e).apply(null, resp);
                            try {
                                template.p((Object)resp.out.toString("utf-8"));
                            }
                            catch (UnsupportedEncodingException e0) {
                                throw new UnexpectedException("utf-8 not supported?");
                            }
                        }
                        ControllersEnhancer.ControllerInstrumentation.initActionCall();
                        RythmPlugin.resetActionCallFlag();
                        return true;
                    }
                    return false;
                }
            }).registerExpressionProcessor((IExpressionProcessor)new ActionInvokeProcessor());
            RythmPlugin.debug("Play specific parser registered", new Object[0]);
        } else {
            engine.init(p);
        }
        long l = System.currentTimeMillis();
        if (engine.enableJavaExtensions()) {
            l = System.currentTimeMillis();
            JavaExtensionBridge.registerPlayBuiltInJavaExtensions(engine);
            RythmPlugin.debug("%sms to register java extension", System.currentTimeMillis() - l);
        }
        l = System.currentTimeMillis();
        FastTagBridge.registerFastTags(engine);
        RythmPlugin.debug("%sms to register play fast tags", System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        this.registerJavaTags(engine);
        RythmPlugin.debug("%sms to register rythm java tags", System.currentTimeMillis() - l);
        ActionTagBridge.registerActionTags(engine);
        RythmTemplateLoader.clear();
    }

    public static void resetActionCallFlag() {
        Stack actionCalls = (Stack)Scope.RenderArgs.current().get(ACTION_CALL_FLAG_KEY, Stack.class);
        if (null != actionCalls) {
            actionCalls.pop();
        }
    }

    public static void setActionCallFlag() {
        Stack<Boolean> actionCalls = (Stack<Boolean>)Scope.RenderArgs.current().get(ACTION_CALL_FLAG_KEY, Stack.class);
        if (null == actionCalls) {
            actionCalls = new Stack<Boolean>();
        }
        actionCalls.push(true);
    }

    public static boolean isActionCall() {
        Stack actionCalls = (Stack)Scope.RenderArgs.current().get(ACTION_CALL_FLAG_KEY, Stack.class);
        return null != actionCalls && !actionCalls.empty();
    }

    public void onApplicationStart() {
        long l = System.currentTimeMillis();
        RythmTemplateLoader.scanTagFolder();
        RythmPlugin.debug("%sms to load Rythm tags", System.currentTimeMillis() - l);
    }

    private void registerJavaTags(RythmEngine engine) {
        Class<?>[] ca;
        List classes = Play.classes.getAssignableClasses(FastRythmTag.class);
        for (ApplicationClasses.ApplicationClass ac : classes) {
            this.registerJavaTag(ac.javaClass, engine);
        }
        for (Class<?> c : ca = FastRythmTags.class.getDeclaredClasses()) {
            this.registerJavaTag(c, engine);
        }
    }

    private void registerJavaTag(Class<?> jc, RythmEngine engine) {
        int flag = jc.getModifiers();
        if (Modifier.isAbstract(flag)) {
            return;
        }
        try {
            Constructor<?> c = jc.getConstructor(new Class[0]);
            c.setAccessible(true);
            FastRythmTag tag = (FastRythmTag)((Object)c.newInstance(new Object[0]));
            engine.registerTag((ITag)tag);
        }
        catch (Exception e) {
            throw new UnexpectedException("Error initialize JavaTag: " + jc.getName(), (Throwable)e);
        }
    }

    public Template loadTemplate(VirtualFile file) {
        if (null == engine) {
            this.onConfigurationRead();
        }
        return RythmTemplateLoader.loadTemplate(file);
    }

    public void detectChange() {
        if (!refreshOnRender) {
            RythmPlugin.engine.classLoader.detectChanges();
        }
    }

    public void beforeActionInvocation(Method actionMethod) {
        if (Play.mode.isDev() && Boolean.valueOf(Play.configuration.getProperty("rythm.cache.prodOnly", "true")).booleanValue()) {
            return;
        }
        Http.Request request = Http.Request.current();
        if ((request.method.equals("GET") || request.method.equals("HEAD")) && actionMethod.isAnnotationPresent(Cache4.class)) {
            Cache4 cache4 = actionMethod.getAnnotation(Cache4.class);
            String cacheKey = cache4.id();
            if (S.isEmpty((String)cacheKey)) {
                cacheKey = "rythm-urlcache:" + request.url + request.querystring;
                if (cache4.useSessionData()) {
                    cacheKey = cacheKey + Scope.Session.current().toString();
                }
            }
            request.args.put("rythm-urlcache-key", cacheKey);
            request.args.put("rythm-urlcache-actionMethod", actionMethod);
            Result result = (Result)Cache.get((String)cacheKey);
            if (null == result) {
                return;
            }
            if (!(result instanceof Cache4.CacheResult)) {
                result = new Cache4.CacheResult(result);
            }
            throw result;
        }
    }

    public void onActionInvocationResult(Result result) {
        if (result instanceof Cache4.CacheResult) {
            return;
        }
        if (result instanceof Redirect) {
            Redirect r = (Redirect)result;
            if (r.code != 301) {
                return;
            }
        }
        if (result instanceof NotFound || result instanceof Error) {
            return;
        }
        Object o = Http.Request.current().args.get("rythm-urlcache-key");
        if (null == o) {
            return;
        }
        String cacheKey = o.toString();
        Method actionMethod = (Method)Http.Request.current().args.get("rythm-urlcache-actionMethod");
        String duration = actionMethod.getAnnotation(Cache4.class).value();
        if (S.isEmpty((String)duration)) {
            duration = "1h";
        }
        if (duration.startsWith("cron.")) {
            duration = Play.configuration.getProperty(duration, "1h");
        }
        if ("forever".equals(duration)) {
            duration = "99999d";
        }
        Cache.set((String)cacheKey, (Object)((Object)new Cache4.CacheResult(result)), (String)duration);
    }

    public static void main(String[] args) {
        Regex r = new Regex("cache(?@())$");
        String s = "controllers.Tester.action1().cacheFor(\"1mn\").ad";
        if (r.search(s)) {
            System.out.println(r.stringMatched());
        }
    }

    static {
        underscoreImplicitVariableName = false;
        refreshOnRender = true;
        templateRoot = R_VIEW_ROOT;
        implicitRenderArgs = new ArrayList<ImplicitVariables.Var>();
        VOID_TEMPLATE = new Template(){

            public void compile() {
            }

            protected String internalRender(Map<String, Object> args) {
                throw new UnexpectedException("It's not supposed to be called");
            }
        };
    }
}

