/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.play;

import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.play.RythmPlugin;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.resource.ITemplateResourceLoader;
import com.greenlaw110.rythm.resource.TemplateResourceBase;
import com.greenlaw110.rythm.runtime.ITag;
import com.greenlaw110.rythm.utils.S;
import java.io.InputStream;
import java.util.ArrayList;
import play.Play;
import play.libs.IO;
import play.mvc.Http;
import play.vfs.VirtualFile;

public class VirtualFileTemplateResourceLoader
implements ITemplateResourceLoader {
    public static VirtualFileTemplateResourceLoader instance = new VirtualFileTemplateResourceLoader();

    public static boolean isValid(VirtualFile file) {
        return null != file && file.exists() && file.getRealFile().canRead();
    }

    private VirtualFile loadFromPath_(String path) {
        VirtualFile vf = null;
        if (path.indexOf("module:") != -1) {
            vf = VirtualFile.fromRelativePath((String)path);
        } else {
            vf = Play.getVirtualFile((String)path);
            if (!VirtualFileTemplateResourceLoader.isValid(vf)) {
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                if (!VirtualFileTemplateResourceLoader.isValid(vf) && !path.startsWith(RythmPlugin.templateRoot)) {
                    String path0 = RythmPlugin.templateRoot + path;
                    vf = Play.getVirtualFile((String)path0);
                }
            }
        }
        return vf;
    }

    public ITemplateResource load(String path) {
        VirtualFile vf = this.loadFromPath_(path);
        if (!VirtualFileTemplateResourceLoader.isValid(vf) && path.indexOf("module:") == -1) {
            path = path.replace(".", "/");
            int pos = path.lastIndexOf("/");
            String path0 = path;
            path = path0.substring(0, pos) + "." + path0.substring(pos + 1);
            vf = this.loadFromPath_(path);
        }
        if (!VirtualFileTemplateResourceLoader.isValid(vf)) {
            return null;
        }
        return this.load(vf, false);
    }

    private ITemplateResource load(VirtualFile file, boolean checkBWList) {
        String path = file.relativePath();
        if (path.contains(".svn")) {
            return null;
        }
        return new VirtualFileTemplateResource(file);
    }

    public ITemplateResource load(VirtualFile file) {
        return this.load(file, true);
    }

    public String getFullTagName(TemplateClass tc) {
        int pos;
        String key = tc.getKey();
        if (key.startsWith("/")) {
            key = key.substring(1);
        }
        if (key.startsWith(RythmPlugin.templateRoot)) {
            key = key.replace(RythmPlugin.templateRoot, "");
        }
        if (key.startsWith("/")) {
            key = key.substring(1);
        }
        if (-1 != (pos = key.lastIndexOf("."))) {
            key = key.substring(0, pos);
        }
        return key.replace('/', '.');
    }

    public TemplateClass tryLoadTag(String tagName, TemplateClass templateClass) {
        RythmEngine engine = RythmPlugin.engine;
        if (engine.tags.containsKey(tagName)) {
            return null;
        }
        String origName = tagName;
        tagName = tagName.replace('.', '/');
        String[] suffixes = new String[]{".html", ".json", ".xml", ".csv", ".tag"};
        String defSuffix = null;
        Http.Request request = Http.Request.current();
        if (null != request) {
            defSuffix = "." + request.format;
        }
        ArrayList<String> sl = new ArrayList<String>();
        sl.add(defSuffix);
        for (String s : suffixes) {
            if (S.isEqual((String)s, (String)defSuffix)) continue;
            sl.add(s);
        }
        ArrayList<String> roots = new ArrayList<String>();
        roots.add(RythmPlugin.templateRoot);
        if (null != templateClass.importPaths) {
            for (String s : templateClass.importPaths) {
                roots.add(RythmPlugin.templateRoot + "/" + s.replace('.', '/'));
            }
        }
        String tagName0 = tagName;
        String currentPath = templateClass.getKey();
        int pos = currentPath.lastIndexOf("/");
        if ((currentPath = currentPath.substring(0, pos)).startsWith("/")) {
            currentPath = currentPath.substring(1);
        }
        if (!currentPath.startsWith(RythmPlugin.templateRoot)) {
            currentPath = RythmPlugin.templateRoot + "/" + currentPath;
        }
        roots.add(currentPath);
        for (String root : roots) {
            tagName = root + "/" + tagName0;
            VirtualFile tagFile = null;
            for (String suffix : sl) {
                ITag tag;
                String name = tagName + suffix;
                tagFile = Play.getVirtualFile((String)name);
                if (null == tagFile || !tagFile.getRealFile().canRead()) continue;
                VirtualFileTemplateResource tr = new VirtualFileTemplateResource(tagFile);
                TemplateClass tc = engine.classes.getByTemplate(tr.getKey());
                if (null == tc) {
                    tc = new TemplateClass((ITemplateResource)tr, engine);
                } else if (tc.equals((Object)templateClass)) {
                    return templateClass;
                }
                if (null == (tag = (ITag)tc.asTemplate())) continue;
                engine.registerTag(origName, tag);
                return tc;
            }
        }
        return null;
    }

    public static class VirtualFileTemplateResource
    extends TemplateResourceBase {
        private static final long serialVersionUID = -4307922939957393745L;
        private String tagName;
        private VirtualFile file;

        VirtualFileTemplateResource(VirtualFile file) {
            this.file = file;
        }

        protected long defCheckInterval() {
            return 100L;
        }

        protected long lastModified() {
            return this.file.lastModified();
        }

        protected String reload() {
            return IO.readContentAsString((InputStream)this.file.inputstream());
        }

        public String getKey() {
            String path = this.file.relativePath();
            return path.replaceFirst("\\{.*?\\}", "");
        }

        public boolean isValid() {
            return VirtualFileTemplateResourceLoader.isValid(this.file);
        }

        public String getSuggestedClassName() {
            return VirtualFileTemplateResource.path2CN((String)this.file.relativePath().replaceFirst("\\{.*\\}", ""));
        }

        public String tagName() {
            return this.tagName;
        }
    }
}

