/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.BlockCodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class AssignParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.ASSIGN;
    }

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Regex r = AssignParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("bad @assign statement. Correct usage: @assign(\"myVariable\"){...}", new Object[0]);
                }
                int curLine = this.ctx().currentLine();
                this.step(r.stringMatched().length());
                String s = r.stringMatched(1);
                s = S.stripBraceAndQuotation(s);
                return new AssignToken(s, this.ctx());
            }
        };
    }

    @Override
    protected String patternStr() {
        return "%s%s\\s*((?@()))[\\s]*\\{?\\s*";
    }

    public static void main(String[] args) {
        Regex r = new AssignParser().reg(new Rythm());
        if (r.search("@assign(\"JS\"){..}")) {
            System.out.println(r.stringMatched());
            System.out.println(r.stringMatched(1));
        }
    }

    public class AssignToken
    extends BlockCodeToken {
        private String assignTo;

        public AssignToken(String assignTo, IContext context) {
            super(null, context);
            this.assignTo = assignTo;
        }

        @Override
        public void output() {
            this.p2tline("Object ", new Object[0]).p(this.assignTo).p(" = null;");
            this.p2tline("{", new Object[0]);
            this.p3tline("StringBuilder sbOld = getOut();", new Object[0]);
            this.p3tline("StringBuilder sbNew = new StringBuilder();", new Object[0]);
            this.p3tline("setOut(sbNew);", new Object[0]);
        }

        @Override
        public String closeBlock() {
            StringBuilder sbNew = new StringBuilder();
            StringBuilder sbOld = this.getOut();
            this.setOut(sbNew);
            this.p3tline("String s = sbNew.toString();", new Object[0]);
            this.p3tline("setOut(sbOld);", new Object[0]);
            this.p3t(this.assignTo).p(" = s;");
            this.pline();
            this.p2tline("}", new Object[0]);
            String s = sbNew.toString();
            this.setOut(sbOld);
            return s;
        }
    }
}

