/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.Directive;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.InvokeTagParser;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class ExtendsParser
extends KeywordParserFactory {
    protected static Regex innerPattern = new Regex("\\((.*?)\\s*(,\\s*(.*))?\\)");
    protected static Regex argsPattern = new Regex("\\G(,\\s*)?((([a-zA-Z_][\\w$_]*)\\s*[=:]\\s*)?('.'|(?@\"\")|[0-9\\.]+[l]?|[a-zA-Z_][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*(\\.[a-zA-Z][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*)*))");

    @Override
    public Keyword keyword() {
        return Keyword.EXTENDS;
    }

    private static void error(IContext ctx) {
        ExtendsParser.raiseParseException(ctx, "Error parsing extends statement. The correct format is @extends(\"my.parent.template\"[, arg1=val1, val2, ...])", new Object[0]);
    }

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Regex r = ExtendsParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    ExtendsParser.error(this.ctx());
                }
                final int lineNo = this.currentLine();
                this.step(r.stringMatched().length());
                String s = r.stringMatched(2);
                if (null == s) {
                    ExtendsParser.error(this.ctx());
                }
                if (!(r = innerPattern).search(s)) {
                    ExtendsParser.error(this.ctx());
                }
                s = r.stringMatched(1);
                final String sExtend = s = S.stripQuotation(s);
                final InvokeTagParser.ParameterDeclarationList params = new InvokeTagParser.ParameterDeclarationList();
                s = r.stringMatched(2);
                if (!S.isEmpty(s)) {
                    r = argsPattern;
                    while (r.search(s)) {
                        params.addParameterDeclaration(r.stringMatched(4), r.stringMatched(5));
                    }
                }
                return new Directive(s, this.ctx()){

                    @Override
                    public void call() {
                        this.builder().setExtended(sExtend, params, lineNo);
                    }
                };
            }
        };
    }

    @Override
    protected String patternStr() {
        return "(^%s%s)\\s*((?@())[\\s\\r\\n;]*)";
    }

    protected String patternStr0() {
        return "(%s%s(\\s*\\((.*)\\)|\\s+([_a-zA-Z\\\\\\\\/][a-zA-Z0-9_\\.\\\\\\\\/]+))[;]?)";
    }

    private static void test1() {
        String line;
        Regex r = new ExtendsParser().reg(new Rythm());
        if (!r.search(line = "@extends(\"_panel.html\", a:5, b=foo.bar(4)[1]);")) {
            throw new RuntimeException("1");
        }
        System.out.println(r.stringMatched());
        String s = r.stringMatched(2);
        if (null == s) {
            throw new RuntimeException("2");
        }
        r = innerPattern;
        System.out.println(s);
        if (!r.search(s)) {
            throw new RuntimeException("3");
        }
        s = r.stringMatched(1);
        if (s.startsWith("\"") || s.startsWith("'")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"") || s.endsWith("'")) {
            s = s.substring(0, s.length() - 1);
        }
        String sExtend = s;
        System.out.println(sExtend);
        InvokeTagParser.ParameterDeclarationList params = new InvokeTagParser.ParameterDeclarationList();
        s = r.stringMatched(2);
        if (!S.isEmpty(s)) {
            s = s.replaceFirst(",\\s*", "");
            r = argsPattern;
            while (r.search(s)) {
                params.addParameterDeclaration(r.stringMatched(4), r.stringMatched(5));
            }
        }
        System.out.println(s);
        System.out.println(params);
    }

    public static void main(String[] args) {
        ExtendsParser.test1();
    }

    public static void test0() {
        String s;
        Regex r = new ExtendsParser().reg(new Rythm());
        if (r.search(s = "@extends('ab/cd.foo', 'a': 6, \"b\"=null); acd")) {
            System.out.println(r.stringMatched());
            System.out.println(r.stringMatched(1));
            System.out.println(r.stringMatched(2));
            System.out.println(r.stringMatched(3));
        }
        System.out.println("--------------------");
        s = r.stringMatched(2);
        r = innerPattern;
        if (r.search(s)) {
            System.out.println(r.stringMatched());
            System.out.println(r.stringMatched(1));
            System.out.println(r.stringMatched(2));
            System.out.println(r.stringMatched(3));
        }
        System.out.println("-----------------");
        s = r.stringMatched(1);
        if (s.startsWith("\"") || s.startsWith("'")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"") || s.endsWith("'")) {
            s = s.substring(0, s.length() - 1);
        }
        System.out.println(s);
    }
}

