/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.BlockCodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.UUID;
import java.util.regex.Pattern;

public class CacheParser
extends KeywordParserFactory {
    private static final Pattern P_INT = Pattern.compile("\\-?[0-9\\*\\/\\+\\-]+");

    public static void validateDurationStr(String d, IContext ctx) {
        if ("null".equals(d)) {
            return;
        }
        if (d.startsWith("\"") && d.endsWith("\"")) {
            String s = S.stripQuotation(d);
            try {
                ctx.getEngine().durationParser.parseDuration(s);
            }
            catch (Exception e) {
                CacheParser.raiseParseException(ctx, "Invalid time duration: %s", d);
            }
        } else if (!P_INT.matcher(d).matches()) {
            CacheParser.raiseParseException(ctx, "Invalid time duration: %s. int(second) or string expected. String must be double quoted", d);
        }
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Regex r = CacheParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    throw new ParseException(this.ctx().getTemplateClass(), this.ctx().currentLine(), "Error parsing @cacheFor statement. Correct usage: @cacheFor (\"duration_string\") {cache block}", new Object[0]);
                }
                String key = UUID.nameUUIDFromBytes(this.remain().getBytes()).toString();
                ctx.step(r.stringMatched().length());
                String s = r.stringMatched(2);
                s = S.stripBrace(s);
                String[] sa = s.split(",");
                String duration = null;
                if (sa.length > 0) {
                    duration = sa[0];
                }
                String args = "";
                if (sa.length > 1) {
                    StringBuilder sb = new StringBuilder("");
                    for (int i = 1; i < sa.length; ++i) {
                        sb.append(",").append(sa[i]);
                    }
                    args = sb.toString();
                }
                return new CacheToken(duration, args, this.ctx());
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.CACHE;
    }

    @Override
    protected String patternStr() {
        return "^(^%s%s\\s*((?@()))(\\s*\\{)?)";
    }

    public static void main(String[] args) {
        String s;
        Regex r = new CacheParser().reg(new Rythm());
        if (r.search(s = "@cacheFor(\"1m\", 1, bar.foo())ab")) {
            System.out.println(r.stringMatched());
            System.out.println(r.stringMatched(1));
            System.out.println(r.stringMatched(2));
            System.out.println(r.stringMatched(3));
        }
    }

    private static class CacheToken
    extends BlockCodeToken {
        private String args;
        private String duration;
        private int startIndex;
        private int endIndex;
        private String key;

        CacheToken(String duration, String args, IContext ctx) {
            super("", ctx);
            this.duration = S.isEmpty(duration) ? "null" : duration;
            CacheParser.validateDurationStr(this.duration, ctx);
            this.args = args;
            this.startIndex = ctx.cursor();
        }

        @Override
        public void output() {
            this.p("{");
            this.pline();
            this.pt("java.io.Serializable s = _engine().cached(\"").p(this.key).p("\"").p(this.args).p(");");
            this.pline();
            this.pt("if (null != s) {");
            this.pline();
            this.p2t("p(s);");
            this.pline();
            this.pt("} else {");
            this.pline();
            this.p2t("StringBuilder sbOld = getOut();");
            this.pline();
            this.p2t("StringBuilder sbNew = new StringBuilder();");
            this.pline();
            this.p2t("setOut(sbNew);");
            this.pline();
        }

        @Override
        public String closeBlock() {
            this.endIndex = this.ctx.cursor();
            String body = this.ctx.getTemplateSource(this.startIndex, this.endIndex);
            String tmplName = this.ctx.getTemplateClass().name();
            String keySeed = body + tmplName;
            this.key = UUID.nameUUIDFromBytes(keySeed.getBytes()).toString();
            StringBuilder sbOld = this.getOut();
            StringBuilder sbNew = new StringBuilder();
            this.setOut(sbNew);
            this.p2t("s = sbNew.toString();");
            this.pline();
            this.p2t("setOut(sbOld);");
            this.pline();
            this.p2t("_engine().cache(\"").p(this.key).p("\",s,").p(this.duration).p(this.args).p(");");
            this.pline();
            this.p2t("p(s);");
            this.pline();
            this.pt("}");
            this.pline();
            this.p("}");
            this.pline();
            String s = sbNew.toString();
            this.setOut(sbOld);
            return s;
        }
    }
}

