/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.parser.BlockCodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.Patterns;
import com.greenlaw110.rythm.internal.parser.build_in.ForEachCodeToken;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class ForEachParser
extends KeywordParserFactory {
    private static final ILogger logger = Logger.get(ForEachParser.class);

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                String remain;
                Regex r = ForEachParser.this.reg(this.dialect());
                if (!r.search(remain = this.remain())) {
                    r = new Regex(String.format(ForEachParser.this.patternStr2(), this.dialect().a(), ForEachParser.this.keyword()));
                    if (!r.search(remain)) {
                        throw new ParseException(this.ctx().getTemplateClass(), this.ctx().currentLine(), "Error parsing @for statement, correct usage: @for(Type var: iterable){...}", new Object[0]);
                    }
                    String s = r.stringMatched(2);
                    this.step(r.stringMatched().length());
                    return new BlockCodeToken("for " + s + "{\n\t", this.ctx()){

                        @Override
                        public void openBlock() {
                            this.ctx().pushBreak(IContext.Break.BREAK);
                            this.ctx().pushContinue(IContext.Continue.CONTINUE);
                        }

                        @Override
                        public void output() {
                            super.output();
                        }

                        @Override
                        public String closeBlock() {
                            this.ctx().popBreak();
                            return super.closeBlock();
                        }
                    };
                }
                String s = r.stringMatched(1);
                this.step(s.length());
                String type = r.stringMatched(5);
                String varname = r.stringMatched(6);
                String iterable = r.stringMatched(8);
                if (S.isEmpty(iterable)) {
                    throw new ParseException(this.ctx().getTemplateClass(), this.ctx().currentLine(), "Error parsing @for statement, correct usage: @for(Type var: iterable){...}", new Object[0]);
                }
                return new ForEachCodeToken(type, varname, iterable, this.ctx());
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.EACH;
    }

    protected String patternStr2() {
        return "^%s%s\\s*((?@()))\\s*\\{?\\s*";
    }

    @Override
    protected String patternStr() {
        return "^(%s%s(\\s+|\\s*\\(\\s*)((" + (Object)((Object)Patterns.Type) + ")(\\s+(" + (Object)((Object)Patterns.VarName) + "))?)\\s*\\:\\s*(" + (Object)((Object)Patterns.Expression2) + ")(\\s*\\)?[\\s\\r\\n]*|[\\s\\r\\n]+)\\{?[\\s\\r\\n]*).*";
    }

    public static void main(String[] args) {
        String s;
        Regex r = new Regex(String.format(new ForEachParser().patternStr2(), "@", "for"));
        if (r.search(s = "@for(int i = 0; i < 100; ++i){\nHello world}")) {
            System.out.println(r.stringMatched());
            System.out.println(1 + r.stringMatched(1));
            System.out.println(2 + r.stringMatched(2));
            System.out.println(3 + r.stringMatched(3));
            System.out.println(4 + r.stringMatched(4));
            System.out.println(5 + r.stringMatched(5));
            System.out.println(6 + r.stringMatched(6));
            System.out.println(7 + r.stringMatched(7));
            System.out.println(8 + r.stringMatched(8));
        }
    }
}

