/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.CodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class IncludeParser
extends KeywordParserFactory {
    private static final String R = "(^%s(%s\\s*((?@()))\\s*))";

    @Override
    protected String patternStr() {
        return R;
    }

    @Override
    public IParser create(IContext c) {
        return new ParserBase(c){

            @Override
            public TextBuilder go() {
                Regex r = IncludeParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("Error parsing @include statement. Correct usage: @include(\"foo.bar, a.b.c, ...\")", new Object[0]);
                }
                this.step(r.stringMatched().length());
                String s = r.stringMatched(3);
                if (S.isEmpty(s)) {
                    this.raiseParseException("Error parsing @include statement. Correct usage: @include(\"foo.bar, a.b.c, ...\")", new Object[0]);
                }
                s = S.stripBraceAndQuotation(s);
                String code = this.ctx().getCodeBuilder().addIncludes(s, this.ctx().currentLine());
                return new CodeToken(code, this.ctx());
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.INCLUDE;
    }

    public static void main(String[] args) {
        String s;
        IncludeParser p = new IncludeParser();
        Regex r = p.reg(new Rythm());
        if (r.search(s = "@include(\"x.y.z,foo.bar\") \n@sayHi(\"green\")")) {
            System.out.println(r.stringMatched());
            System.out.println(r.stringMatched(1));
            System.out.println(r.stringMatched(2));
            System.out.println(r.stringMatched(3));
        }
    }
}

