/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.template;

import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.template.TemplateBase;
import com.greenlaw110.rythm.utils.S;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Stack;

public interface ITemplate
extends Cloneable {
    public void setRenderArgs(Map<String, Object> var1);

    public void setRenderArgs(Object ... var1);

    public void setRenderArg(String var1, Object var2);

    public Map<String, Object> getRenderArgs();

    public Object getRenderArg(String var1);

    public void setRenderArg(int var1, Object var2);

    public String render();

    public void init();

    public StringBuilder getOut();

    public void setOut(StringBuilder var1);

    public ITemplate cloneMe(RythmEngine var1, ITemplate var2);

    public static class RawData
    implements Serializable {
        public String data;
        public static final RawData NULL = new RawData(null);

        public RawData(Object val) {
            this.data = val == null ? "" : val.toString();
        }

        public String toString() {
            return this.data;
        }
    }

    public static enum Escape {
        RAW,
        CSV{

            @Override
            protected RawData apply_(String s) {
                return S.escapeCsv(s);
            }
        }
        ,
        HTML{

            @Override
            protected RawData apply_(String s) {
                return S.escapeHtml(s);
            }
        }
        ,
        JS{

            @Override
            protected RawData apply_(String s) {
                return S.escapeJavaScript(s);
            }
        }
        ,
        JSON{

            @Override
            protected RawData apply_(String s) {
                return S.escapeJson(s);
            }
        }
        ,
        JAVA{

            @Override
            protected RawData apply_(String s) {
                return S.escapeJava(s);
            }
        }
        ,
        XML{

            @Override
            protected RawData apply_(String s) {
                return S.escapeXml(s);
            }
        };

        private static String[] sa_;

        public RawData apply(Object o) {
            if (null == o) {
                return RawData.NULL;
            }
            String s = o.toString();
            return this.apply_(s);
        }

        protected RawData apply_(String s) {
            return new RawData(s);
        }

        public static String[] stringValues() {
            if (null == sa_) {
                Escape[] ea = Escape.values();
                Object[] sa = new String[ea.length];
                for (int i = 0; i < ea.length; ++i) {
                    sa[i] = ea[i].toString();
                }
                Arrays.sort(sa);
                sa_ = sa;
            }
            return (String[])sa_.clone();
        }

        static {
            sa_ = null;
        }
    }

    public static class Context {
        public Stack<Escape> escapeStack = new Stack();

        public void init(TemplateBase templateBase) {
            TemplateClass tc = templateBase.getTemplateClass(true);
            if (tc.name().contains("html__R_T_C__")) {
                this.escapeStack.push(Escape.HTML);
            } else {
                this.escapeStack.push(Escape.RAW);
            }
        }

        public Escape currentEscape() {
            return this.escapeStack.peek();
        }

        public void pushEscape(Escape escape) {
            this.escapeStack.push(escape);
        }

        public Escape popEscape() {
            return this.escapeStack.pop();
        }
    }
}

