/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.spi;

import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IExpressionProcessor;
import com.greenlaw110.rythm.utils.IJavaExtension;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Token
extends TextBuilder {
    protected static final ILogger logger;
    protected String s;
    protected IContext ctx;
    protected int line;
    protected boolean disableCompactMode = false;
    private boolean ok = true;
    static final List<IJavaExtension> extensions;
    private static final Regex R_;
    private static final Pattern P_ELVIS;

    protected boolean compactMode() {
        if (this.disableCompactMode) {
            return false;
        }
        return null == this.ctx ? true : this.ctx.compactMode();
    }

    protected final void fail() {
        this.ok = false;
    }

    public Token(String s, IContext context) {
        this(s, context, false);
    }

    public Token(String s, IContext context, boolean disableCompactMode) {
        super(null == context ? null : context.getCodeBuilder());
        this.s = s;
        this.ctx = context;
        this.line = null == context ? -1 : context.currentLine();
        this.disableCompactMode = disableCompactMode;
    }

    public boolean test(String line) {
        return true;
    }

    public boolean isOk() {
        return this.ok;
    }

    @Override
    public final TextBuilder build() {
        if (this.ok) {
            this.output();
        } else {
            this.pp(this.s);
        }
        return this;
    }

    protected void output() {
        if (null == this.s || "".equals(this.s)) {
            return;
        }
        this.pp(this.s);
    }

    public static final void addExtension(IJavaExtension extension) {
        extensions.add(extension);
    }

    public static boolean isJavaExtension(String methodName) {
        for (IJavaExtension ext : extensions) {
            if (!S.isEqual(methodName, ext.methodName())) continue;
            return true;
        }
        return false;
    }

    private static String stripOuterBrackets(String s) {
        if (S.isEmpty(s)) {
            return s;
        }
        if (R_.search(s)) {
            s = R_.stringMatched();
            s = s.substring(1);
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static String[] stripElvis(String s) {
        if (S.isEmpty(s)) {
            return new String[]{"", ""};
        }
        Matcher m = P_ELVIS.matcher(s = Token.stripOuterBrackets(s));
        if (m.matches()) {
            String s0 = m.group(1);
            String s1 = m.group(2);
            return new String[]{s0, s1};
        }
        return new String[]{s, ""};
    }

    private static String processElvis(String s) {
        if (S.isEmpty(s)) {
            return s;
        }
        String[] sa = Token.stripElvis(s);
        s = sa[0];
        String elvis = sa[1];
        if (S.isEmpty(elvis)) {
            return s;
        }
        elvis = elvis.replaceFirst("^\\s*\\?\\s*:\\s*", "");
        return String.format("((null == %1$s) ? %2$s : %1$s)", s, elvis);
    }

    protected final void outputExpression(List<String> nullValueTester) {
        int size = nullValueTester.size();
        for (String s : nullValueTester) {
            this.p("if (null != ").p(s).p(") {\n\t");
        }
        this.outputExpression();
        this.pn();
        for (int i = 0; i < size; ++i) {
            this.pn("}");
        }
    }

    protected final void outputExpression() {
        boolean hasJavaExtension;
        boolean matched;
        if (S.isEmpty(this.s)) {
            return;
        }
        if (null != this.ctx && !this.ctx.getCodeBuilder().engine.enableJavaExtensions()) {
            this.p("\ntry{pe(").p(this.s).p(");} catch (RuntimeException e) {handleTemplateExecutionException(e);} ");
            return;
        }
        String s0 = this.s;
        boolean outerBracketsStripped = false;
        this.s = Token.stripOuterBrackets(this.s);
        outerBracketsStripped = this.s != s0;
        class Pair {
            IJavaExtension extension;
            String signature;

            Pair(IJavaExtension e, String s) {
                this.extension = e;
                this.signature = s;
            }
        }
        Stack<Pair> allMatched = new Stack<Pair>();
        do {
            matched = false;
            for (IJavaExtension e : extensions) {
                Pattern p = e.pattern1();
                Matcher m = p.matcher(this.s);
                if (!m.matches()) continue;
                matched = true;
                String signature = e instanceof IJavaExtension.VoidParameterExtension ? null : m.group(1);
                m = e.pattern2().matcher(this.s);
                this.s = m.replaceAll("");
                allMatched.push(new Pair(e, signature));
            }
        } while (matched);
        boolean bl = hasJavaExtension = !allMatched.empty();
        if (hasJavaExtension) {
            this.s = Token.processElvis(this.s);
            while (!allMatched.empty()) {
                Pair p = (Pair)allMatched.pop();
                this.s = p.extension.extend(this.s, p.signature);
            }
        } else {
            boolean matched2;
            String[] sa = Token.stripElvis(this.s);
            this.s = sa[0];
            String elvis = sa[1];
            do {
                matched2 = false;
                for (IJavaExtension e : extensions) {
                    Pattern p = e.pattern1();
                    Matcher m = p.matcher(this.s);
                    if (!m.matches()) continue;
                    matched2 = true;
                    String signature = e instanceof IJavaExtension.VoidParameterExtension ? null : m.group(1);
                    m = e.pattern2().matcher(this.s);
                    this.s = m.replaceAll("");
                    allMatched.push(new Pair(e, signature));
                }
            } while (matched2);
            while (!allMatched.empty()) {
                this.s = Token.processElvis(this.s);
                Pair p = (Pair)allMatched.pop();
                this.s = p.extension.extend(this.s, p.signature);
            }
            if (!S.isEmpty(elvis)) {
                elvis = elvis.replaceFirst("^\\s*\\?\\s*:\\s*", "");
                this.s = String.format("((null == %1$s) ? %2$s : %1$s)", this.s, elvis);
            }
        }
        if (outerBracketsStripped) {
            this.s = String.format("(%s)", this.s);
        }
        this.s = this.compact(this.s);
        boolean processed = false;
        for (IExpressionProcessor p : this.ctx.getEngine().getExtensionManager().expressionProcessors()) {
            if (!p.process(this.s, this)) continue;
            processed = true;
            break;
        }
        if (!processed) {
            this.p("\ntry{pe(").p(this.s).p(");} catch (RuntimeException e) {handleTemplateExecutionException(e);} ");
            this.pline();
        }
    }

    public Token ptline(String msg, Object ... args) {
        String s = String.format(msg, args);
        this.p("\t").p(s);
        this.pline();
        return this;
    }

    public Token p2tline(String msg, Object ... args) {
        String s = String.format(msg, args);
        this.p("\t\t").p(s);
        this.pline();
        return this;
    }

    public Token p3tline(String msg, Object ... args) {
        String s = String.format(msg, args);
        this.p("\t\t\t").p(s);
        this.pline();
        return this;
    }

    public Token p4tline(String msg, Object ... args) {
        String s = String.format(msg, args);
        this.p("\t\t\t\t").p(s);
        this.pline();
        return this;
    }

    public Token p5tline(String msg, Object ... args) {
        String s = String.format(msg, args);
        this.p("\t\t\t\t\t").p(s);
        this.pline();
        return this;
    }

    public Token pline(String msg, Object ... args) {
        String s = String.format(msg, args);
        this.p(s);
        this.pline();
        return this;
    }

    public Token pline() {
        this.p(" //line: ").pn(this.line);
        return this;
    }

    protected void pp(String s) {
        s = this.compact(s);
        s = s.replaceAll("(\\r?\\n)+", "\\\\n").replaceAll("\"", "\\\\\"");
        this.p("p(\"").p(s).p("\");");
        this.pline();
    }

    private static String compact_(String s) {
        String[] lines = s.split("[\\r\\n]+");
        TextBuilder tb = new TextBuilder();
        int i = 0;
        for (String line : lines) {
            if (i++ > 0) {
                tb.p(" ");
            }
            line = line.replaceAll("[ \t]+", " ");
            tb.p(line);
            if (!line.contains("//")) continue;
            tb.p("\n");
        }
        return tb.toString();
    }

    protected String compact(String s) {
        return this.compactMode() ? Token.compact_(s) : s;
    }

    public static void main(String[] args) {
        String s = "try {_.bindModel(_.campaign.designer.componentPanel.data, \n$('#panDesigner .design-panel.component')[0]);}";
        System.out.println(Token.compact_(s));
    }

    public static void main1(String[] args) {
    }

    static {
        String[] sa;
        logger = Logger.get(Token.class);
        extensions = new ArrayList<IJavaExtension>();
        for (String s : sa = new String[]{"raw", "escape", "escapeHtml", "escapeJavaScript", "escapeCsv", "escapeXml", "escapeJava", "camelCase", "capAll", "capFirst", "slugify", "noAccents"}) {
            Token.addExtension(new IJavaExtension.VoidParameterExtension("S", s));
        }
        Token.addExtension(new IJavaExtension.ParameterExtension("S", "escape", ".+"));
        R_ = new Regex("^\\s*(?@())\\s*$");
        P_ELVIS = Pattern.compile("(.*)(\\s*\\?\\s*:\\s*.*)");
    }
}

