/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.play;

import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.exception.CompileException;
import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.exception.RythmException;
import com.greenlaw110.rythm.internal.compiler.ClassReloadException;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.play.RythmPlugin;
import com.greenlaw110.rythm.play.RythmTemplateLoader;
import com.greenlaw110.rythm.play.TemplateParseException;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.template.ITemplate;
import java.util.Map;
import play.Logger;
import play.classloading.enhancers.ControllersEnhancer;
import play.exceptions.TemplateCompilationException;
import play.exceptions.TemplateExecutionException;
import play.exceptions.UnexpectedException;
import play.templates.TagContext;
import play.templates.Template;

public class RythmTemplate
extends Template {
    private TemplateClass tc;
    private static final ThreadLocal<Integer> refreshCounter = new ThreadLocal();

    RythmTemplate(ITemplateResource resource) {
        if (null == resource) {
            throw new NullPointerException();
        }
        this.tc = new TemplateClass(resource, RythmPlugin.engine, true);
        this.name = resource.getKey();
        this.source = this.tc.templateResource.asTemplateContent();
    }

    private RythmEngine engine() {
        return RythmPlugin.engine;
    }

    void refresh() {
        this.refresh(false);
    }

    void refresh(boolean forceRefresh) {
        if (!forceRefresh && this.engine().isProdMode()) {
            return;
        }
        try {
            this.engine().classLoader.detectChange(this.tc);
        }
        catch (ClassReloadException e) {
            RythmPlugin.debug("restart rythm engine to reload changed template...", new Object[0]);
            this.engine().restart((RuntimeException)((Object)e));
            this.refresh(forceRefresh);
        }
        catch (ParseException e) {
            TemplateInfo t = RythmTemplate.handleRythmException((RythmException)e);
            throw new TemplateParseException(t, e);
        }
        catch (CompileException e) {
            TemplateInfo t = RythmTemplate.handleRythmException((RythmException)e);
            throw new TemplateCompilationException((Template)t, Integer.valueOf(t.lineNo), e.originalMessage);
        }
        catch (RuntimeException e) {
            throw new UnexpectedException(String.format("Unknown error when refreshing rythm template: %s", this.tc.getKey()), (Throwable)e);
        }
        if (!this.tc.isValid) {
            RythmTemplateLoader.cache.remove(this.getName());
        } else {
            this.source = this.tc.templateResource.asTemplateContent();
        }
    }

    public boolean isValid() {
        return this.tc.isValid;
    }

    public void compile() {
        this.refresh();
    }

    protected String internalRender(Map<String, Object> args) {
        try {
            ITemplate t = this.tc.asTemplate();
            t.setRenderArgs(args);
            ControllersEnhancer.ControllerInstrumentation.initActionCall();
            if (!RythmPlugin.isActionCall()) {
                TagContext.init();
            }
            String s = t.render();
            if (!RythmPlugin.engine.isProdMode()) {
                refreshCounter.set(0);
            }
            return s;
        }
        catch (RythmException e) {
            Throwable cause = e.getCause();
            TemplateInfo t = RythmTemplate.handleRythmException(e);
            if (e instanceof CompileException) {
                throw new TemplateCompilationException((Template)t, Integer.valueOf(t.lineNo), e.getMessage());
            }
            throw new TemplateExecutionException((Template)t, Integer.valueOf(t.lineNo), e.errorMessage, (Throwable)e);
        }
        catch (Exception e) {
            throw new TemplateExecutionException((Template)this, Integer.valueOf(-1), e.getMessage(), (Throwable)e);
        }
    }

    String handleClassCastException(ClassCastException e, Map<String, Object> args) {
        Integer I = refreshCounter.get();
        if (null == I || I < 2) {
            if (null == I) {
                refreshCounter.set(1);
            } else {
                I = I + 1;
                refreshCounter.set(I);
            }
            if (Logger.isDebugEnabled()) {
                RythmPlugin.debug("ClassCastException detected, force refresh template class and continue...", new Object[0]);
            }
            this.tc.refresh(true);
            return this.internalRender(args);
        }
        refreshCounter.set(0);
        throw new UnexpectedException("Too many ClassCastException encountered, please restart Play", (Throwable)e);
    }

    static TemplateInfo handleRythmException(RythmException e) {
        TemplateInfo t;
        int line = e.templateLineNumber;
        if (-1 == line) {
            line = e.javaLineNumber;
            t = new TemplateInfo(e.getTemplateName(), e.getJavaSource(), line);
        } else {
            t = new TemplateInfo(e.getTemplateName(), e.getTemplateSource(), line);
        }
        return t;
    }

    public String getName() {
        return this.tc.getKey();
    }

    static class TemplateInfo
    extends Template {
        public int lineNo = -1;

        public void compile() {
        }

        protected String internalRender(Map<String, Object> args) {
            return null;
        }

        TemplateInfo(String name, String source, int lineNo) {
            this.source = source;
            this.lineNo = lineNo;
            this.name = name;
        }
    }
}

