/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal;

import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.CodeBuilder;
import com.greenlaw110.rythm.internal.TemplateTokenizer;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.spi.IBlockHandler;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IDialect;
import com.greenlaw110.rythm.utils.TextBuilder;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class TemplateParser
implements IContext {
    private final ILogger logger = Logger.get(TemplateParser.class);
    private final CodeBuilder cb;
    private String template;
    private int totalLines;
    int cursor = 0;
    private Stack<IBlockHandler> blocks = new Stack();
    private Stack<Boolean> compactStack = new Stack();
    private Stack<IContext.Break> breakStack = new Stack();
    private Stack<IContext.Continue> continueStack = new Stack();

    public TemplateParser(CodeBuilder cb) {
        this.template = cb.template();
        this.totalLines = StringUtils.countMatches((CharSequence)this.template, (CharSequence)"\n") + 1;
        this.cb = cb;
    }

    void parse() {
        TemplateTokenizer tt = new TemplateTokenizer(this.template, this);
        try {
            for (TextBuilder builder : tt) {
                this.cb.addBuilder(builder);
            }
        }
        catch (ExitInstruction exitInstruction) {
            // empty catch block
        }
    }

    @Override
    public TemplateClass getTemplateClass() {
        return this.cb.getTemplateClass();
    }

    @Override
    public CodeBuilder getCodeBuilder() {
        return this.cb;
    }

    @Override
    public IDialect getDialect() {
        return this.cb.engine.getDialectManager().get();
    }

    @Override
    public void setDialect(String dialect) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRemain() {
        return this.cursor < this.template.length() ? this.template.substring(this.cursor) : "";
    }

    @Override
    public int cursor() {
        return this.cursor;
    }

    @Override
    public boolean hasRemain() {
        return this.cursor < this.template.length();
    }

    @Override
    public char peek() {
        if (!this.hasRemain()) {
            return '\u0000';
        }
        return this.template.charAt(this.cursor);
    }

    @Override
    public char pop() {
        if (!this.hasRemain()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        char c = this.template.charAt(this.cursor);
        this.step(1);
        return c;
    }

    @Override
    public void step(int i) {
        this.cursor += i;
    }

    @Override
    public String getTemplateSource(int start, int end) {
        return this.template.substring(start, end);
    }

    @Override
    public void openBlock(IBlockHandler bh) {
        bh.openBlock();
        this.blocks.push(bh);
    }

    @Override
    public IBlockHandler currentBlock() {
        return this.blocks.isEmpty() ? null : this.blocks.peek();
    }

    @Override
    public String closeBlock() throws ParseException {
        if (this.blocks.isEmpty()) {
            throw new ParseException(this.cb.getTemplateClass(), this.currentLine(), "No open block found", new Object[0]);
        }
        IBlockHandler bh = this.blocks.pop();
        return null == bh ? "" : bh.closeBlock();
    }

    @Override
    public int currentLine() {
        if (null == this.template) {
            return -1;
        }
        if (this.cursor >= this.template.length()) {
            return this.totalLines;
        }
        return StringUtils.countMatches((CharSequence)this.template.substring(0, this.cursor), (CharSequence)"\n") + 1;
    }

    @Override
    public RythmEngine getEngine() {
        return this.cb.engine;
    }

    @Override
    public boolean compactMode() {
        if (!this.compactStack.empty()) {
            return this.compactStack.peek();
        }
        return this.getEngine().compactMode();
    }

    @Override
    public void pushCompact(Boolean compact) {
        this.compactStack.push(compact);
    }

    @Override
    public Boolean peekCompact() {
        if (this.compactStack.empty()) {
            return null;
        }
        return this.compactStack.peek();
    }

    @Override
    public Boolean popCompact() {
        if (this.compactStack.empty()) {
            return null;
        }
        return this.compactStack.pop();
    }

    @Override
    public void pushBreak(IContext.Break b) {
        this.breakStack.push(b);
    }

    @Override
    public IContext.Break peekBreak() {
        if (this.breakStack.empty()) {
            return null;
        }
        return this.breakStack.peek();
    }

    @Override
    public IContext.Break popBreak() {
        if (this.breakStack.empty()) {
            return null;
        }
        return this.breakStack.pop();
    }

    @Override
    public void pushContinue(IContext.Continue b) {
        this.continueStack.push(b);
    }

    @Override
    public IContext.Continue peekContinue() {
        if (this.continueStack.empty()) {
            return null;
        }
        return this.continueStack.peek();
    }

    @Override
    public IContext.Continue popContinue() {
        if (this.continueStack.empty()) {
            return null;
        }
        return this.continueStack.pop();
    }

    private TemplateParser(String s) {
        this.template = s;
        this.totalLines = this.template.split("(\\r\\n|\\n|\\r)").length + 1;
        this.cb = null;
    }

    public static void main(String[] args) {
        TemplateParser tp = new TemplateParser("\nHello \n\r\nworld!");
        System.out.println(tp.totalLines);
        System.out.println(tp.currentLine());
        tp.step(5);
        System.out.println("5 steps ahead");
        System.out.println(tp.currentLine());
        System.out.println(tp.getRemain());
        tp.step(4);
        System.out.println("4 steps ahead");
        System.out.println(tp.currentLine());
        System.out.println(tp.getRemain());
    }

    public static class ExitInstruction
    extends RuntimeException {
    }
}

