/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.BlockCodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.Patterns;
import com.greenlaw110.rythm.internal.parser.build_in.CaretParserFactoryBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class AssignParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.ASSIGN;
    }

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Regex r = AssignParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("bad @assign statement. Correct usage: @assign(\"myVariable\"){...}", new Object[0]);
                }
                int curLine = this.ctx().currentLine();
                this.step(r.stringMatched().length());
                String s = r.stringMatched(1);
                s = S.stripBrace(s);
                return new AssignToken(s, this.ctx());
            }
        };
    }

    @Override
    protected String patternStr() {
        return "%s%s\\s*((?@()))[\\s]*\\{?\\s*";
    }

    public static void main(String[] args) {
        Regex r = new AssignParser().reg(new Rythm());
        if (r.search("@assign(\"JS\", false){..}")) {
            System.out.println(r.stringMatched());
            System.out.println(r.stringMatched(1));
        }
    }

    public class AssignToken
    extends BlockCodeToken {
        private String assignTo;
        private boolean isFinal;

        public AssignToken(String assignTo, IContext context) {
            super(null, context);
            String[] sa = assignTo.split(",");
            this.assignTo = S.stripQuotation(sa[0]);
            if (Patterns.RESERVED.matches(this.assignTo)) {
                CaretParserFactoryBase.raiseParseException(this.ctx, "assign variable name is reserved: %s", this.assignTo);
            }
            if (sa.length > 1) {
                this.isFinal = Boolean.parseBoolean(sa[1].trim());
            }
        }

        @Override
        public void output() {
            String assignTo = this.assignTo;
            if (this.isFinal) {
                assignTo = this.assignTo + "___";
            }
            this.p2tline("Object ", new Object[0]).p(assignTo).p(" = null;");
            this.p2tline("{", new Object[0]);
            this.p3tline("StringBuilder sbOld = getOut();", new Object[0]);
            this.p3tline("StringBuilder sbNew = new StringBuilder();", new Object[0]);
            this.p3tline("setOut(sbNew);", new Object[0]);
        }

        @Override
        public String closeBlock() {
            String assignTo = this.assignTo;
            if (this.isFinal) {
                assignTo = this.assignTo + "___";
            }
            StringBuilder sbNew = new StringBuilder();
            StringBuilder sbOld = this.getOut();
            this.setOut(sbNew);
            this.p3tline("String s = sbNew.toString();", new Object[0]);
            this.p3tline("setOut(sbOld);", new Object[0]);
            this.p3t(assignTo).p(" = s;");
            this.pline();
            this.p2tline("}", new Object[0]);
            if (this.isFinal) {
                this.p2t("final Object ").p(this.assignTo).p(" = ").p(assignTo).p(";");
                this.pline();
            }
            String s = sbNew.toString();
            this.setOut(sbOld);
            return s;
        }
    }
}

