/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.BlockCodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.spi.Token;
import com.greenlaw110.rythm.utils.TextBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompactParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.COMPACT;
    }

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Matcher m = CompactParser.this.ptn(this.dialect()).matcher(this.remain());
                if (!m.matches()) {
                    return null;
                }
                this.step(m.group(1).length());
                return new BlockCodeToken("", this.ctx()){

                    @Override
                    public void openBlock() {
                        this.ctx().getCodeBuilder().addBuilder(new Token("", this.ctx()){

                            @Override
                            protected void output() {
                                this.ctx().pushCompact(true);
                                super.output();
                            }
                        });
                    }

                    @Override
                    public String closeBlock() {
                        this.ctx().getCodeBuilder().addBuilder(new Token("", this.ctx()){

                            @Override
                            protected void output() {
                                this.ctx().popCompact();
                                super.output();
                            }
                        });
                        return "";
                    }
                };
            }
        };
    }

    @Override
    protected String patternStr() {
        return "(%s%s\\s*\\(\\s*\\)[\\s]*\\{).*";
    }

    public static void main(String[] args) {
        Pattern p = new CompactParser().ptn(new Rythm());
        Matcher m = p.matcher("@compact() {\n    @body\n}");
        if (m.find()) {
            System.out.println(m.group(1));
        }
    }
}

