/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUnmarshallerContext {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final JsonParser jsonParser;
    private final Stack<String> stack = new Stack();
    private String stackString = "";
    private String currentField;
    private Map<String, String> metadata = new HashMap<String, String>();
    private List<MetadataExpression> metadataExpressions = new ArrayList<MetadataExpression>();
    public JsonToken currentToken;

    public JsonUnmarshallerContext(JsonParser jsonParser) {
        this.jsonParser = jsonParser;
    }

    public int getCurrentDepth() {
        int depth = this.stack.size();
        if (this.currentField != null) {
            ++depth;
        }
        return depth;
    }

    public String readText() throws IOException {
        switch (this.currentToken) {
            case VALUE_STRING: {
                String text = this.jsonParser.getText();
                return text;
            }
            case VALUE_FALSE: {
                return "false";
            }
            case VALUE_TRUE: {
                return "true";
            }
            case VALUE_NULL: {
                return null;
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return this.jsonParser.getNumberValue().toString();
            }
            case FIELD_NAME: {
                return this.jsonParser.getText();
            }
        }
        throw new RuntimeException("We expected a VALUE token but got: " + this.currentToken);
    }

    public boolean isStartOfDocument() {
        return this.jsonParser.getCurrentToken() == null;
    }

    public boolean testExpression(String expression) {
        if (expression.equals(".")) {
            return true;
        }
        return this.stackString.endsWith(expression);
    }

    public boolean testExpression(String expression, int startingStackDepth) {
        if (expression.equals(".")) {
            return true;
        }
        int index = -1;
        while ((index = expression.indexOf("/", index + 1)) > -1) {
            if (expression.charAt(index + 1) == '@') continue;
            ++startingStackDepth;
        }
        return this.stackString.endsWith("/" + expression);
    }

    public JsonToken nextToken() throws IOException {
        JsonToken token = this.jsonParser.nextToken();
        this.updateContext(token);
        return token;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void registerMetadataExpression(String expression, int targetDepth, String storageKey) {
        this.metadataExpressions.add(new MetadataExpression(expression, targetDepth, storageKey));
    }

    private void updateContext(JsonToken token) throws IOException {
        if (token == null) {
            return;
        }
        this.currentToken = token;
        if (token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY) {
            if (this.currentField != null) {
                this.stack.push(this.currentField);
                this.currentField = null;
            } else {
                this.stack.push(token.toString());
            }
        } else if (token == JsonToken.END_OBJECT || token == JsonToken.END_ARRAY) {
            if (!this.stack.isEmpty()) {
                this.stack.pop();
            }
            this.currentField = null;
        } else if (token == JsonToken.FIELD_NAME) {
            String t;
            this.currentField = t = this.jsonParser.getText();
        }
        this.rebuildStackString();
    }

    public String toString() {
        return this.stackString;
    }

    private void rebuildStackString() {
        this.stackString = "";
        for (String s : this.stack) {
            this.stackString = this.stackString + "/" + s;
        }
        if (this.currentField != null) {
            this.stackString = this.stackString + "/" + this.currentField;
        }
    }

    private class MetadataExpression {
        public String expression;
        public int targetDepth;
        public String key;

        public MetadataExpression(String expression, int targetDepth, String key) {
            this.expression = expression;
            this.targetDepth = targetDepth;
            this.key = key;
        }
    }
}

