/*
 * Decompiled with CFR 0.152.
 */
package play.modules.s3blobs;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.exceptions.ConfigurationException;
import play.modules.s3blobs.S3Blob;

public class S3Blobs
extends PlayPlugin {
    public void onApplicationStart() {
        String secretKey;
        Logger.info((String)"Starting the S3Blobs module", (Object[])new Object[0]);
        if (!Play.configuration.containsKey("aws.access.key")) {
            throw new ConfigurationException("Bad configuration for s3: no access key");
        }
        if (!Play.configuration.containsKey("aws.secret.key")) {
            throw new ConfigurationException("Bad configuration for s3: no secret key");
        }
        if (!Play.configuration.containsKey("s3.bucket")) {
            throw new ConfigurationException("Bad configuration for s3: no s3 bucket");
        }
        S3Blob.s3Bucket = Play.configuration.getProperty("s3.bucket");
        String accessKey = Play.configuration.getProperty("aws.access.key");
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(accessKey, secretKey = Play.configuration.getProperty("aws.secret.key"));
        S3Blob.s3Client = new AmazonS3Client((AWSCredentials)awsCredentials);
        if (!S3Blob.s3Client.doesBucketExist(S3Blob.s3Bucket)) {
            S3Blob.s3Client.createBucket(S3Blob.s3Bucket);
        }
    }
}

