/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.HypervisorType;
import com.amazonaws.services.ec2.model.ImageState;
import com.amazonaws.services.ec2.model.ProductCode;
import com.amazonaws.services.ec2.model.StateReason;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.VirtualizationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image {
    private String imageId;
    private String imageLocation;
    private String state;
    private String ownerId;
    private Boolean publicValue;
    private List<ProductCode> productCodes;
    private String architecture;
    private String imageType;
    private String kernelId;
    private String ramdiskId;
    private String platform;
    private StateReason stateReason;
    private String imageOwnerAlias;
    private String name;
    private String description;
    private String rootDeviceType;
    private String rootDeviceName;
    private List<BlockDeviceMapping> blockDeviceMappings;
    private String virtualizationType;
    private List<Tag> tags;
    private String hypervisor;

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public Image withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    public Image withImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Image withState(String state) {
        this.state = state;
        return this;
    }

    public void setState(ImageState state) {
        this.state = state.toString();
    }

    public Image withState(ImageState state) {
        this.state = state.toString();
        return this;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public Image withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public Boolean isPublic() {
        return this.publicValue;
    }

    public void setPublic(Boolean publicValue) {
        this.publicValue = publicValue;
    }

    public Image withPublic(Boolean publicValue) {
        this.publicValue = publicValue;
        return this;
    }

    public Boolean getPublic() {
        return this.publicValue;
    }

    public List<ProductCode> getProductCodes() {
        if (this.productCodes == null) {
            this.productCodes = new ArrayList<ProductCode>();
        }
        return this.productCodes;
    }

    public void setProductCodes(Collection<ProductCode> productCodes) {
        if (productCodes == null) {
            this.productCodes = null;
            return;
        }
        ArrayList<ProductCode> productCodesCopy = new ArrayList<ProductCode>(productCodes.size());
        productCodesCopy.addAll(productCodes);
        this.productCodes = productCodesCopy;
    }

    public Image withProductCodes(ProductCode ... productCodes) {
        if (this.getProductCodes() == null) {
            this.setProductCodes(new ArrayList<ProductCode>(productCodes.length));
        }
        for (ProductCode value : productCodes) {
            this.getProductCodes().add(value);
        }
        return this;
    }

    public Image withProductCodes(Collection<ProductCode> productCodes) {
        if (productCodes == null) {
            this.productCodes = null;
        } else {
            ArrayList<ProductCode> productCodesCopy = new ArrayList<ProductCode>(productCodes.size());
            productCodesCopy.addAll(productCodes);
            this.productCodes = productCodesCopy;
        }
        return this;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public Image withArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public String getImageType() {
        return this.imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public Image withImageType(String imageType) {
        this.imageType = imageType;
        return this;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public Image withKernelId(String kernelId) {
        this.kernelId = kernelId;
        return this;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public Image withRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
        return this;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Image withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public StateReason getStateReason() {
        return this.stateReason;
    }

    public void setStateReason(StateReason stateReason) {
        this.stateReason = stateReason;
    }

    public Image withStateReason(StateReason stateReason) {
        this.stateReason = stateReason;
        return this;
    }

    public String getImageOwnerAlias() {
        return this.imageOwnerAlias;
    }

    public void setImageOwnerAlias(String imageOwnerAlias) {
        this.imageOwnerAlias = imageOwnerAlias;
    }

    public Image withImageOwnerAlias(String imageOwnerAlias) {
        this.imageOwnerAlias = imageOwnerAlias;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Image withName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Image withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    public void setRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
    }

    public Image withRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
        return this;
    }

    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    public void setRootDeviceName(String rootDeviceName) {
        this.rootDeviceName = rootDeviceName;
    }

    public Image withRootDeviceName(String rootDeviceName) {
        this.rootDeviceName = rootDeviceName;
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>(blockDeviceMappings.size());
        blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        this.blockDeviceMappings = blockDeviceMappingsCopy;
    }

    public Image withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.getBlockDeviceMappings() == null) {
            this.setBlockDeviceMappings(new ArrayList<BlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping value : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(value);
        }
        return this;
    }

    public Image withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
        } else {
            ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>(blockDeviceMappings.size());
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
            this.blockDeviceMappings = blockDeviceMappingsCopy;
        }
        return this;
    }

    public String getVirtualizationType() {
        return this.virtualizationType;
    }

    public void setVirtualizationType(String virtualizationType) {
        this.virtualizationType = virtualizationType;
    }

    public Image withVirtualizationType(String virtualizationType) {
        this.virtualizationType = virtualizationType;
        return this;
    }

    public void setVirtualizationType(VirtualizationType virtualizationType) {
        this.virtualizationType = virtualizationType.toString();
    }

    public Image withVirtualizationType(VirtualizationType virtualizationType) {
        this.virtualizationType = virtualizationType.toString();
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public Image withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public Image withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public void setHypervisor(String hypervisor) {
        this.hypervisor = hypervisor;
    }

    public Image withHypervisor(String hypervisor) {
        this.hypervisor = hypervisor;
        return this;
    }

    public void setHypervisor(HypervisorType hypervisor) {
        this.hypervisor = hypervisor.toString();
    }

    public Image withHypervisor(HypervisorType hypervisor) {
        this.hypervisor = hypervisor.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageId != null) {
            sb.append("ImageId: " + this.imageId + ", ");
        }
        if (this.imageLocation != null) {
            sb.append("ImageLocation: " + this.imageLocation + ", ");
        }
        if (this.state != null) {
            sb.append("State: " + this.state + ", ");
        }
        if (this.ownerId != null) {
            sb.append("OwnerId: " + this.ownerId + ", ");
        }
        if (this.publicValue != null) {
            sb.append("Public: " + this.publicValue + ", ");
        }
        if (this.productCodes != null) {
            sb.append("ProductCodes: " + this.productCodes + ", ");
        }
        if (this.architecture != null) {
            sb.append("Architecture: " + this.architecture + ", ");
        }
        if (this.imageType != null) {
            sb.append("ImageType: " + this.imageType + ", ");
        }
        if (this.kernelId != null) {
            sb.append("KernelId: " + this.kernelId + ", ");
        }
        if (this.ramdiskId != null) {
            sb.append("RamdiskId: " + this.ramdiskId + ", ");
        }
        if (this.platform != null) {
            sb.append("Platform: " + this.platform + ", ");
        }
        if (this.stateReason != null) {
            sb.append("StateReason: " + this.stateReason + ", ");
        }
        if (this.imageOwnerAlias != null) {
            sb.append("ImageOwnerAlias: " + this.imageOwnerAlias + ", ");
        }
        if (this.name != null) {
            sb.append("Name: " + this.name + ", ");
        }
        if (this.description != null) {
            sb.append("Description: " + this.description + ", ");
        }
        if (this.rootDeviceType != null) {
            sb.append("RootDeviceType: " + this.rootDeviceType + ", ");
        }
        if (this.rootDeviceName != null) {
            sb.append("RootDeviceName: " + this.rootDeviceName + ", ");
        }
        if (this.blockDeviceMappings != null) {
            sb.append("BlockDeviceMappings: " + this.blockDeviceMappings + ", ");
        }
        if (this.virtualizationType != null) {
            sb.append("VirtualizationType: " + this.virtualizationType + ", ");
        }
        if (this.tags != null) {
            sb.append("Tags: " + this.tags + ", ");
        }
        if (this.hypervisor != null) {
            sb.append("Hypervisor: " + this.hypervisor + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getImageLocation() == null ? 0 : this.getImageLocation().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.isPublic() == null ? 0 : this.isPublic().hashCode());
        hashCode = 31 * hashCode + (this.getProductCodes() == null ? 0 : ((Object)this.getProductCodes()).hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getImageType() == null ? 0 : this.getImageType().hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getStateReason() == null ? 0 : this.getStateReason().hashCode());
        hashCode = 31 * hashCode + (this.getImageOwnerAlias() == null ? 0 : this.getImageOwnerAlias().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceType() == null ? 0 : this.getRootDeviceType().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceName() == null ? 0 : this.getRootDeviceName().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : ((Object)this.getBlockDeviceMappings()).hashCode());
        hashCode = 31 * hashCode + (this.getVirtualizationType() == null ? 0 : this.getVirtualizationType().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        hashCode = 31 * hashCode + (this.getHypervisor() == null ? 0 : this.getHypervisor().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getImageLocation() == null ^ this.getImageLocation() == null) {
            return false;
        }
        if (other.getImageLocation() != null && !other.getImageLocation().equals(this.getImageLocation())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.isPublic() == null ^ this.isPublic() == null) {
            return false;
        }
        if (other.isPublic() != null && !other.isPublic().equals(this.isPublic())) {
            return false;
        }
        if (other.getProductCodes() == null ^ this.getProductCodes() == null) {
            return false;
        }
        if (other.getProductCodes() != null && !((Object)other.getProductCodes()).equals(this.getProductCodes())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getImageType() == null ^ this.getImageType() == null) {
            return false;
        }
        if (other.getImageType() != null && !other.getImageType().equals(this.getImageType())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getStateReason() == null ^ this.getStateReason() == null) {
            return false;
        }
        if (other.getStateReason() != null && !other.getStateReason().equals(this.getStateReason())) {
            return false;
        }
        if (other.getImageOwnerAlias() == null ^ this.getImageOwnerAlias() == null) {
            return false;
        }
        if (other.getImageOwnerAlias() != null && !other.getImageOwnerAlias().equals(this.getImageOwnerAlias())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRootDeviceType() == null ^ this.getRootDeviceType() == null) {
            return false;
        }
        if (other.getRootDeviceType() != null && !other.getRootDeviceType().equals(this.getRootDeviceType())) {
            return false;
        }
        if (other.getRootDeviceName() == null ^ this.getRootDeviceName() == null) {
            return false;
        }
        if (other.getRootDeviceName() != null && !other.getRootDeviceName().equals(this.getRootDeviceName())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !((Object)other.getBlockDeviceMappings()).equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getVirtualizationType() == null ^ this.getVirtualizationType() == null) {
            return false;
        }
        if (other.getVirtualizationType() != null && !other.getVirtualizationType().equals(this.getVirtualizationType())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !((Object)other.getTags()).equals(this.getTags())) {
            return false;
        }
        if (other.getHypervisor() == null ^ this.getHypervisor() == null) {
            return false;
        }
        return other.getHypervisor() == null || other.getHypervisor().equals(this.getHypervisor());
    }
}

