/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class LoadServiceResource {
    private final URL resource;
    private final File path;
    private final String name;
    private final boolean absolute;

    public LoadServiceResource(URL resource2, String name2) {
        this.resource = resource2;
        this.path = null;
        this.name = name2;
        this.absolute = false;
    }

    public LoadServiceResource(URL resource2, String name2, boolean absolute) {
        this.resource = resource2;
        this.path = null;
        this.name = name2;
        this.absolute = absolute;
    }

    public LoadServiceResource(File path2, String name2) {
        this.resource = null;
        this.path = path2;
        this.name = name2;
        this.absolute = false;
    }

    public LoadServiceResource(File path2, String name2, boolean absolute) {
        this.resource = null;
        this.path = path2;
        this.name = name2;
        this.absolute = absolute;
    }

    public InputStream getInputStream() throws IOException {
        if (this.resource != null) {
            return this.resource.openStream();
        }
        byte[] bytes2 = new byte[(int)this.path.length()];
        ByteBuffer buffer = ByteBuffer.wrap(bytes2);
        FileInputStream fis = new FileInputStream(this.path);
        FileChannel fc = fis.getChannel();
        fc.read(buffer);
        fis.close();
        return new ByteArrayInputStream(bytes2);
    }

    public String getName() {
        return this.name;
    }

    public File getPath() {
        return this.path;
    }

    public URL getURL() throws IOException {
        if (this.resource != null) {
            return this.resource;
        }
        return this.path.toURI().toURL();
    }

    public boolean isAbsolute() {
        return this.absolute;
    }
}

