/*
 * Decompiled with CFR 0.152.
 */
package play.modules.sass;

import java.io.PrintStream;
import play.Play;
import play.PlayPlugin;
import play.modules.sass.Engine;
import play.mvc.Http;
import play.vfs.VirtualFile;

public class Plugin
extends PlayPlugin {
    Engine sass;

    public void onLoad() {
        this.sass = new Engine(Play.getVirtualFile((String)"haml-2.2.16").getRealFile());
    }

    public boolean serveStatic(VirtualFile file, Http.Request request, Http.Response response) {
        if (file.getName().endsWith(".sass")) {
            try {
                String css = this.sass.compile(file.getRealFile(), Play.mode == Play.Mode.DEV);
                response.contentType = "text/css";
                response.status = 200;
                if (Play.mode == Play.Mode.PROD) {
                    response.cacheFor("1h");
                }
                response.print((Object)css);
            }
            catch (Exception e) {
                response.contentType = "text/css";
                response.status = 500;
                response.print((Object)"Oops,\n");
                e.printStackTrace(new PrintStream(response.out));
            }
            return true;
        }
        if (file.getName().endsWith(".rb")) {
            response.status = 404;
            return true;
        }
        return super.serveStatic(file, request, response);
    }
}

