/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import jruby.objectweb.asm.AnnotationVisitor;
import org.jruby.Ruby;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.impl.HeapBasedVariableCompiler;
import org.jruby.compiler.impl.RootScopedBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StackBasedVariableCompiler;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class MethodBodyCompiler
extends RootScopedBodyCompiler {
    protected boolean specificArity;
    protected String rubyName;

    public MethodBodyCompiler(StandardASMCompiler scriptCompiler, String rubyName, String javaName, ASTInspector inspector, StaticScope scope) {
        super(scriptCompiler, javaName, inspector, scope);
        this.rubyName = rubyName;
    }

    public boolean isSpecificArity() {
        return this.specificArity;
    }

    public String getSignature() {
        if (this.shouldUseBoxedArgs(this.scope)) {
            this.specificArity = false;
            return StandardASMCompiler.getStaticMethodSignature(this.script.getClassname(), 4);
        }
        this.specificArity = true;
        return StandardASMCompiler.getStaticMethodSignature(this.script.getClassname(), this.scope.getRequiredArgs());
    }

    protected void createVariableCompiler() {
        this.variableCompiler = this.inspector == null ? new HeapBasedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex()) : (this.inspector.hasClosure() || this.inspector.hasScopeAwareMethods() ? new HeapBasedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex()) : new StackBasedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex()));
    }

    public void beginMethod(CompilerCallback args2, StaticScope scope) {
        this.method.start();
        this.method.aload(1);
        this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        this.method.astore(this.getRuntimeIndex());
        this.method.aload(this.getRuntimeIndex());
        this.invokeRuby("getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        this.method.astore(this.getNilIndex());
        this.variableCompiler.beginMethod(args2, scope);
        this.method.label(this.scopeStart);
    }

    public void endBody() {
        this.method.areturn();
        this.method.label(this.scopeEnd);
        this.variableCompiler.declareLocals(this.scope, this.scopeStart, this.scopeEnd);
        AnnotationVisitor annotation2 = this.method.visitAnnotation(CodegenUtils.ci(JRubyMethod.class), true);
        annotation2.visit("name", this.rubyName);
        annotation2.visit("frame", true);
        annotation2.visit("required", this.scope.getRequiredArgs());
        annotation2.visit("optional", this.scope.getOptionalArgs());
        annotation2.visit("rest", this.scope.getRestArg());
        this.method.end();
        if (this.specificArity) {
            this.method = new SkinnyMethodAdapter(this.script.getClassVisitor().visitMethod(9, this.methodName, StandardASMCompiler.getStaticMethodSignature(this.script.getClassname(), 4), null, null));
            this.method.start();
            this.method.aload(1);
            this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            this.method.aload(3);
            this.method.pushInt(this.scope.getRequiredArgs());
            this.method.pushInt(this.scope.getRequiredArgs());
            this.method.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
            this.method.pop();
            this.loadThis();
            this.loadThreadContext();
            this.loadSelf();
            for (int i = 0; i < this.scope.getRequiredArgs(); ++i) {
                this.method.aload(3);
                this.method.ldc(i);
                this.method.arrayload();
            }
            this.method.aload(4);
            this.method.invokestatic(this.script.getClassname(), this.methodName, this.getSignature());
            this.method.areturn();
            this.method.end();
        }
    }

    public void performReturn() {
        if (this.inNestedMethod) {
            this.loadThreadContext();
            this.invokeUtilityMethod("returnJump", CodegenUtils.sig(JumpException.ReturnJump.class, IRubyObject.class, ThreadContext.class));
            this.method.athrow();
        } else {
            this.method.areturn();
        }
    }

    public void issueBreakEvent(CompilerCallback value2) {
        if (this.currentLoopLabels != null) {
            value2.call(this);
            this.issueLoopBreak();
        } else if (this.inNestedMethod) {
            this.loadThreadContext();
            value2.call(this);
            this.invokeUtilityMethod("breakJump", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        } else {
            this.loadRuntime();
            value2.call(this);
            this.invokeUtilityMethod("breakLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
        }
    }

    public void issueNextEvent(CompilerCallback value2) {
        if (this.currentLoopLabels != null) {
            value2.call(this);
            this.issueLoopNext();
        } else if (this.inNestedMethod) {
            value2.call(this);
            this.invokeUtilityMethod("nextJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
        } else {
            this.loadRuntime();
            value2.call(this);
            this.invokeUtilityMethod("nextLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
        }
    }

    public void issueRedoEvent() {
        if (this.currentLoopLabels != null) {
            this.issueLoopRedo();
        } else if (this.inNestedMethod) {
            this.invokeUtilityMethod("redoJump", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        } else {
            this.loadRuntime();
            this.invokeUtilityMethod("redoLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class));
        }
    }
}

