/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import org.jruby.Ruby;
import org.jruby.RubyGlobal;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyInterfaceAdapter;
import org.jruby.embed.EmbedRubyObjectAdapter;
import org.jruby.embed.EmbedRubyRuntimeAdapter;
import org.jruby.embed.LocalContextProvider;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.PathType;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.internal.EmbedRubyInterfaceAdapterImpl;
import org.jruby.embed.internal.EmbedRubyObjectAdapterImpl;
import org.jruby.embed.internal.EmbedRubyRuntimeAdapterImpl;
import org.jruby.embed.internal.SingleThreadLocalContextProvider;
import org.jruby.embed.internal.SingletonLocalContextProvider;
import org.jruby.embed.internal.ThreadSafeLocalContextProvider;
import org.jruby.embed.io.ReaderInputStream;
import org.jruby.embed.io.WriterOutputStream;
import org.jruby.embed.util.SystemPropertyCatcher;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptingContainer {
    private static final String defaultProps = "org/jruby/embed/jruby-embed.properties";
    private final Map<String, String[]> properties;
    private LocalContextProvider provider = null;
    private EmbedRubyRuntimeAdapter runtimeAdapter = new EmbedRubyRuntimeAdapterImpl(this);
    private EmbedRubyObjectAdapter objectAdapter = new EmbedRubyObjectAdapterImpl(this);
    private EmbedRubyInterfaceAdapter interfaceAdapter = new EmbedRubyInterfaceAdapterImpl(this);

    public ScriptingContainer() {
        this(LocalContextScope.SINGLETON, LocalVariableBehavior.TRANSIENT, defaultProps);
    }

    public ScriptingContainer(LocalContextScope scope) {
        this(scope, LocalVariableBehavior.TRANSIENT, defaultProps);
    }

    public ScriptingContainer(LocalVariableBehavior behavior) {
        this(LocalContextScope.SINGLETON, behavior, defaultProps);
    }

    public ScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior) {
        this(scope, behavior, defaultProps);
    }

    public ScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior, String propertyname) {
        this.provider = this.getProviderInstance(scope, behavior);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        this.properties = Collections.unmodifiableMap(map);
        if (propertyname == null || propertyname.length() == 0) {
            return;
        }
        this.prepareProperties(propertyname, map);
        try {
            SystemPropertyCatcher.setJRubyHome(this);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private LocalContextProvider getProviderInstance(LocalContextScope scope, LocalVariableBehavior behavior) {
        switch (scope) {
            case THREADSAFE: {
                return new ThreadSafeLocalContextProvider(behavior);
            }
            case SINGLETHREAD: {
                return new SingleThreadLocalContextProvider(behavior);
            }
        }
        return new SingletonLocalContextProvider(behavior);
    }

    private void prepareProperties(String propertyname, Map<String, String[]> map) {
        try {
            PropertyResourceBundle resource2 = new PropertyResourceBundle(this.getClass().getClassLoader().getResourceAsStream(propertyname));
            Enumeration<String> keys2 = resource2.getKeys();
            while (keys2.hasMoreElements()) {
                String key2 = keys2.nextElement();
                String[] values = resource2.getString(key2).split(",\\s*");
                for (int i = 0; i < values.length; ++i) {
                    values[i] = values[i].trim();
                }
                map.put(key2, values);
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String[] getProperty(String key2) {
        return this.properties.get(key2);
    }

    public String getSupportedRubyVersion() {
        Ruby ruby = this.getRuntime();
        RubyInstanceConfig config = ruby.getInstanceConfig();
        return config.getVersionString().trim();
    }

    public LocalContextProvider getProvider() {
        return this.provider;
    }

    public Ruby getRuntime() {
        return this.provider.getRuntime();
    }

    public BiVariableMap getVarMap() {
        return this.provider.getVarMap();
    }

    public Map getAttributeMap() {
        return this.provider.getAttributeMap();
    }

    public Object getAttribute(Object key2) {
        return this.provider.getAttributeMap().get(key2);
    }

    public Object setAttribute(Object key2, Object value2) {
        return this.provider.getAttributeMap().put(key2, value2);
    }

    public Object removeAttribute(Object key2) {
        return this.provider.getAttributeMap().remove(key2);
    }

    public Object get(String key2) {
        return this.provider.getVarMap().get(key2);
    }

    public Object put(String key2, Object value2) {
        return this.provider.getVarMap().put(key2, value2);
    }

    public EmbedEvalUnit parse(String script, int ... lines2) {
        return this.runtimeAdapter.parse(script, lines2);
    }

    public EmbedEvalUnit parse(Reader reader, String filename2, int ... lines2) {
        return this.runtimeAdapter.parse(reader, filename2, lines2);
    }

    public EmbedEvalUnit parse(PathType type2, String filename2, int ... lines2) {
        return this.runtimeAdapter.parse(type2, filename2, lines2);
    }

    public EmbedEvalUnit parse(InputStream istream, String filename2, int ... lines2) {
        return this.runtimeAdapter.parse(istream, filename2, lines2);
    }

    public Object runScriptlet(String script) {
        EmbedEvalUnit unit = this.parse(script, new int[0]);
        return this.runUnit(unit);
    }

    private Object runUnit(EmbedEvalUnit unit) {
        if (unit == null) {
            return null;
        }
        IRubyObject ret = unit.run();
        return JavaEmbedUtils.rubyToJava(ret);
    }

    public Object runScriptlet(Reader reader, String filename2) {
        EmbedEvalUnit unit = this.parse(reader, filename2, new int[0]);
        return this.runUnit(unit);
    }

    public Object runScriptlet(InputStream istream, String filename2) {
        EmbedEvalUnit unit = this.parse(istream, filename2, new int[0]);
        return this.runUnit(unit);
    }

    public Object runScriptlet(PathType type2, String filename2) {
        EmbedEvalUnit unit = this.parse(type2, filename2, new int[0]);
        return this.runUnit(unit);
    }

    public EmbedRubyRuntimeAdapter newRuntimeAdapter() {
        return this.runtimeAdapter;
    }

    public EmbedRubyObjectAdapter newObjectAdapter() {
        return this.objectAdapter;
    }

    public <T> T callMethod(Object receiver2, String methodName, Class<T> returnType) {
        return this.objectAdapter.callMethod(receiver2, methodName, returnType);
    }

    public <T> T callMethod(Object receiver2, String methodName, Object singleArg, Class<T> returnType) {
        return this.objectAdapter.callMethod(receiver2, methodName, singleArg, returnType);
    }

    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Class<T> returnType) {
        return this.objectAdapter.callMethod(receiver2, methodName, args2, returnType);
    }

    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Block block, Class<T> returnType) {
        return this.objectAdapter.callMethod(receiver2, methodName, args2, block, returnType);
    }

    public <T> T callMethod(Object receiver2, String methodName, Class<T> returnType, EmbedEvalUnit unit) {
        return this.objectAdapter.callMethod(receiver2, methodName, returnType, unit);
    }

    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Class<T> returnType, EmbedEvalUnit unit) {
        return this.objectAdapter.callMethod(receiver2, methodName, args2, returnType, unit);
    }

    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Block block, Class<T> returnType, EmbedEvalUnit unit) {
        return this.objectAdapter.callMethod(receiver2, methodName, args2, block, returnType, unit);
    }

    public <T> T callSuper(Object receiver2, Object[] args2, Class<T> returnType) {
        return this.objectAdapter.callSuper(receiver2, args2, returnType);
    }

    public <T> T callSuper(Object receiver2, Object[] args2, Block block, Class<T> returnType) {
        return this.objectAdapter.callSuper(receiver2, args2, block, returnType);
    }

    public <T> T getInstance(Object receiver2, Class<T> clazz) {
        return this.interfaceAdapter.getInstance(receiver2, clazz);
    }

    public void setReader(Reader reader) {
        Reader old;
        if (reader == null) {
            return;
        }
        Map map = this.getAttributeMap();
        if (map.containsKey((Object)AttributeName.READER) && (old = (Reader)map.get((Object)AttributeName.READER)) == reader) {
            return;
        }
        map.put(AttributeName.READER, reader);
        ReaderInputStream istream = new ReaderInputStream(reader);
        Ruby runtime2 = this.getRuntime();
        RubyIO io2 = new RubyIO(runtime2, istream);
        io2.getOpenFile().getMainStream().setSync(true);
        runtime2.defineVariable(new RubyGlobal.InputGlobalVariable(runtime2, "$stdin", io2));
        runtime2.defineGlobalConstant("STDIN", io2);
    }

    public Reader getReader() {
        Map map = this.getAttributeMap();
        if (map.containsKey((Object)AttributeName.READER)) {
            return (Reader)this.getAttributeMap().get((Object)AttributeName.READER);
        }
        return null;
    }

    public InputStream getIn() {
        return this.getRuntime().getIn();
    }

    public void setWriter(Writer writer) {
        Writer old;
        if (writer == null) {
            return;
        }
        Map map = this.getAttributeMap();
        if (map.containsKey((Object)AttributeName.WRITER) && (old = (Writer)map.get((Object)AttributeName.WRITER)) == writer) {
            return;
        }
        map.put(AttributeName.WRITER, writer);
        PrintStream pstream = new PrintStream(new WriterOutputStream(writer));
        this.setOutputStream(pstream);
    }

    private void setOutputStream(PrintStream pstream) {
        if (pstream == null) {
            return;
        }
        Ruby runtime2 = this.getRuntime();
        RubyIO io2 = new RubyIO(runtime2, pstream);
        io2.getOpenFile().getMainStream().setSync(true);
        this.gulpWarning();
        runtime2.defineVariable(new RubyGlobal.OutputGlobalVariable(runtime2, "$stdout", io2));
        runtime2.defineGlobalConstant("STDOUT", io2);
        runtime2.getGlobalVariables().alias("$>", "$stdout");
        runtime2.getGlobalVariables().alias("$defout", "$stdout");
        this.revertWarning();
    }

    public void resetWriter() {
        PrintStream pstream = this.provider.getRubyInstanceConfig().getOutput();
        this.setOutputStream(pstream);
    }

    public Writer getWriter() {
        Map map = this.getAttributeMap();
        if (map.containsKey((Object)AttributeName.WRITER)) {
            return (Writer)this.getAttributeMap().get((Object)AttributeName.WRITER);
        }
        return null;
    }

    public PrintStream getOut() {
        return this.getRuntime().getOut();
    }

    public void setErrorWriter(Writer errorWriter) {
        Writer old;
        if (errorWriter == null) {
            return;
        }
        Map map = this.getAttributeMap();
        if (map.containsKey((Object)AttributeName.ERROR_WRITER) && (old = (Writer)map.get((Object)AttributeName.ERROR_WRITER)) == errorWriter) {
            return;
        }
        map.put(AttributeName.ERROR_WRITER, errorWriter);
        PrintStream pstream = new PrintStream(new WriterOutputStream(errorWriter));
        this.setErrorStream(pstream);
    }

    private void setErrorStream(PrintStream error2) {
        if (error2 == null) {
            return;
        }
        Ruby runtime2 = this.getRuntime();
        RubyIO io2 = new RubyIO(runtime2, error2);
        io2.getOpenFile().getMainStream().setSync(true);
        runtime2.defineVariable(new RubyGlobal.OutputGlobalVariable(runtime2, "$stderr", io2));
        runtime2.defineGlobalConstant("STDERR", io2);
        runtime2.getGlobalVariables().alias("$deferr", "$stderr");
    }

    public void resetErrorWriter() {
        PrintStream error2 = this.provider.getRubyInstanceConfig().getError();
        this.setErrorStream(error2);
    }

    public Writer getErrorWriter() {
        Map map = this.getAttributeMap();
        if (map.containsKey((Object)AttributeName.ERROR_WRITER)) {
            return (Writer)this.getAttributeMap().get((Object)AttributeName.ERROR_WRITER);
        }
        return null;
    }

    public PrintStream getErr() {
        return this.getRuntime().getErr();
    }

    private void gulpWarning() {
        Boolean gulping = true;
        Object obj = this.getAttribute((Object)AttributeName.WARNING_GULPING);
        if (obj != null && obj instanceof Boolean) {
            gulping = (Boolean)obj;
        }
        if (!gulping.booleanValue()) {
            return;
        }
        RubyIO dummy_io = new RubyIO(this.getRuntime(), new PrintStream(new WriterOutputStream(new StringWriter())));
        this.getRuntime().getGlobalVariables().set("$stderr", dummy_io);
    }

    private void revertWarning() {
        Writer errorWriter;
        Boolean gulping = true;
        Object obj = this.getAttribute((Object)AttributeName.WARNING_GULPING);
        if (obj != null && obj instanceof Boolean) {
            gulping = (Boolean)obj;
        }
        if (!gulping.booleanValue()) {
            return;
        }
        Map map = this.getAttributeMap();
        PrintStream pstream = null;
        if (map.containsKey((Object)AttributeName.ERROR_WRITER) && (errorWriter = (Writer)map.get((Object)AttributeName.ERROR_WRITER)) != null) {
            pstream = new PrintStream(new WriterOutputStream(errorWriter));
        }
        if (pstream == null) {
            pstream = new PrintStream(System.err);
        }
        RubyIO error_io = new RubyIO(this.getRuntime(), pstream);
        this.getRuntime().getGlobalVariables().set("$stderr", error_io);
    }
}

