/*
 * Decompiled with CFR 0.152.
 */
package play.modules.sass;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;
import play.Logger;
import play.Play;
import play.libs.IO;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine {
    ScriptingContainer scriptingContainer;
    Pattern extractLog = Pattern.compile("([a-zA-Z_0-9-]+[.]s[ca]ss:\\d+:.+)$", 8);
    Pattern extractLog2 = Pattern.compile("([(]s[ca]ss[)]:\\d+:.+)$", 8);
    StringWriter errors = new StringWriter();
    List<String> sassPaths;
    Pattern imports = Pattern.compile("@import\\s+[\"']?([^\\s'\";]+)[\"']?");
    Map<File, CachedCSS> cache = new HashMap<File, CachedCSS>();

    Engine(File root) {
        ArrayList<String> loadPaths = new ArrayList<String>();
        loadPaths.add(new File(root, "lib").getAbsolutePath());
        for (VirtualFile vf : Play.roots) {
            loadPaths.add(new File(vf.getRealFile(), "public/stylesheets").getAbsolutePath());
        }
        System.setProperty("jruby.jit.codeCache", new File(Play.tmpDir, "jruby-cache").getAbsolutePath());
        this.scriptingContainer = new ScriptingContainer(LocalContextScope.SINGLETON);
        this.scriptingContainer.getProvider().setLoadPaths(loadPaths);
        this.scriptingContainer.setCompileMode(RubyInstanceConfig.CompileMode.JIT);
        this.scriptingContainer.getProvider().getRubyInstanceConfig();
        RubyInstanceConfig.FASTEST_COMPILE_ENABLED = true;
        this.scriptingContainer.getProvider().getRubyInstanceConfig();
        RubyInstanceConfig.FRAMELESS_COMPILE_ENABLED = true;
        this.scriptingContainer.getProvider().getRubyInstanceConfig();
        RubyInstanceConfig.POSITIONLESS_COMPILE_ENABLED = true;
        this.scriptingContainer.getProvider().getRubyInstanceConfig();
        RubyInstanceConfig.FASTCASE_COMPILE_ENABLED = true;
        this.scriptingContainer.getProvider().getRubyInstanceConfig();
        RubyInstanceConfig.FASTSEND_COMPILE_ENABLED = true;
        this.scriptingContainer.getProvider().getRubyInstanceConfig();
        RubyInstanceConfig.INLINE_DYNCALL_ENABLED = true;
        this.scriptingContainer.setErrorWriter((Writer)this.errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compile(File css, boolean dev) {
        CachedCSS cachedCSS = this.cache.get(css);
        if (cachedCSS != null && (!dev || cachedCSS.isStillValid())) {
            return cachedCSS.css;
        }
        this.sassPaths = new ArrayList<String>();
        this.sassPaths.add(Play.getFile((String)"public/stylesheets").getAbsolutePath());
        StringBuffer extensions = new StringBuffer();
        for (VirtualFile vf : Play.modules.values()) {
            File style = new File(vf.getRealFile(), "public/stylesheets");
            this.sassPaths.add(style.getAbsolutePath());
            if (!style.exists()) continue;
            for (File f : style.listFiles()) {
                if (!f.isFile() || !f.getName().endsWith(".rb")) continue;
                extensions.append("require '" + f.getName().subSequence(0, f.getName().length() - 3) + "'\n");
            }
        }
        ArrayList<File> dependencies = new ArrayList<File>();
        this.findDependencies(css, dependencies);
        Class<Engine> clazz = Engine.class;
        synchronized (Engine.class) {
            StringBuffer result = new StringBuffer();
            this.errors.getBuffer().setLength(0);
            this.scriptingContainer.put("@result", (Object)result);
            StringBuffer sb = new StringBuffer("[");
            for (int i = 0; i < this.sassPaths.size(); ++i) {
                sb.append("'");
                sb.append(this.sassPaths.get(i));
                sb.append("'");
                if (i >= this.sassPaths.size() - 1) continue;
                sb.append(",");
            }
            sb.append("]");
            try {
                this.scriptingContainer.runScriptlet(this.script("require 'sass'", extensions.toString(), "options = {}", "options[:load_paths] = " + sb, "options[:cache_location] = '" + new File(Play.tmpDir, "sass-cache").getAbsolutePath() + "'", "options[:style] = " + (dev ? ":expanded" : ":compressed") + "", "options[:line_comments] = " + (dev ? "true" : "false") + "", "options[:syntax] = " + (css.getAbsolutePath().endsWith(".scss") ? ":scss" : ":sass") + "", "input = File.new('" + css.getAbsolutePath() + "', 'r')", "tree = ::Sass::Engine.new(input.read(), options).to_tree", "@result.append(tree.render)"));
            }
            catch (Exception e) {
                String error = "";
                Matcher matcher = this.extractLog.matcher(this.errors.toString());
                while (matcher.find()) {
                    error = matcher.group(1);
                    Logger.error((String)error, (Object[])new Object[0]);
                }
                matcher = this.extractLog2.matcher(this.errors.toString());
                while (matcher.find()) {
                    error = matcher.group(1).replace("(sass)", css.getName());
                    Logger.error((String)error, (Object[])new Object[0]);
                }
                if (error.equals("")) {
                    Logger.error((Throwable)e, (String)"SASS Error", (Object[])new Object[0]);
                    error = "Check logs";
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return "/** The CSS was not generated because the " + css.getName() + " file has errors; check logs **/\n\n" + "body:before {display: block; color: #c00; white-space: pre; font-family: monospace; background: #FDD9E1; border-top: 1px solid pink; border-bottom: 1px solid pink; padding: 10px; content: \"[SASS ERROR] " + error.replace("\"", "'") + "\"; }";
            }
            cachedCSS = new CachedCSS(result.toString(), dependencies);
            this.cache.put(css, cachedCSS);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return cachedCSS.css;
        }
    }

    private String script(String ... lines) {
        StringBuffer buffer = new StringBuffer();
        for (String line : lines) {
            buffer.append(line);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private void findDependencies(File sass, List<File> all) {
        try {
            if (sass.exists()) {
                all.add(sass);
                Matcher m = this.imports.matcher(IO.readContentAsString((File)sass));
                block2: while (m.find()) {
                    String fileName = m.group(1);
                    for (String path : this.sassPaths) {
                        File depSass = new File(path + "/" + fileName);
                        if (!depSass.exists()) {
                            depSass = new File(depSass.getParentFile() + "/_" + depSass.getName() + ".sass");
                        }
                        if (!depSass.exists()) continue;
                        this.findDependencies(depSass, all);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"in SASS.findDependencies", (Object[])new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CachedCSS {
        List<File> deps;
        long ts = System.currentTimeMillis();
        String css;

        public CachedCSS(String css, List<File> deps) {
            this.css = css;
            this.deps = deps;
        }

        public boolean isStillValid() {
            for (File f : this.deps) {
                if (f.lastModified() <= this.ts) continue;
                return false;
            }
            return true;
        }
    }
}

