/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class InterfaceJavaProxy
extends JavaProxy {
    public InterfaceJavaProxy(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    public static RubyClass createInterfaceJavaProxy(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyClass ifcJavaProxy = runtime2.defineClass("InterfaceJavaProxy", runtime2.getJavaSupport().getJavaProxyClass(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new InterfaceJavaProxy(runtime2, klazz);
            }
        });
        RubyClass javaIfcExtender = runtime2.defineClass("JavaInterfaceExtender", runtime2.getObject(), runtime2.getObject().getAllocator());
        javaIfcExtender.defineAnnotatedMethods(JavaInterfaceExtender.class);
        return ifcJavaProxy;
    }

    public static class JavaInterfaceExtender {
        @JRubyMethod(backtrace=true)
        public static IRubyObject initialize(ThreadContext context, IRubyObject self, IRubyObject javaClassName, Block block) {
            Ruby runtime2 = context.getRuntime();
            self.getInstanceVariables().setInstanceVariable("@java_class", JavaClass.forNameVerbose(runtime2, javaClassName.asJavaString()));
            self.getInstanceVariables().setInstanceVariable("@block", RubyProc.newProc(runtime2, block, Block.Type.PROC));
            return runtime2.getNil();
        }

        @JRubyMethod(backtrace=true)
        public static IRubyObject extend_proxy(ThreadContext context, IRubyObject self, IRubyObject proxyClass) {
            return proxyClass.callMethod(context, "class_eval", IRubyObject.NULL_ARRAY, ((RubyProc)self.getInstanceVariables().getInstanceVariable("@block")).getBlock());
        }
    }
}

