/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scaffold;

import java.io.File;
import java.util.List;
import javax.persistence.GeneratedValue;
import play.Logger;
import play.Play;
import play.i18n.MessagesPlugin;
import play.modules.scaffold.entity.Entity;
import play.modules.scaffold.entity.PersistenceStrategy;
import play.modules.scaffold.generator.ScaffoldingGenerator;
import play.modules.scaffold.utils.Fields;

public class Generate {
    private static final String EXCLUDE = "--exclude";
    private static final String INCLUDE = "--include";
    private static final String OVERWRITE = "--overwrite";
    private static final String WITH_LAYOUT = "--with-layout";
    private static final String WITH_LOGIN = "--with-login";
    private static final String ALL = "--all";
    private static final String INVALID_MODELPATTERN = "Invalid pattern, provide a text string with optional '*' wildcard";
    boolean forceOverwrite = false;
    String includeRegEx = null;
    String excludeRegEx = null;
    boolean includeLayout = false;
    boolean includeLogin = false;

    public void parseArguments(String[] args) {
        String gettingArgumentsForCommand = null;
        for (String arg : args) {
            if (gettingArgumentsForCommand != null) {
                if (gettingArgumentsForCommand.equalsIgnoreCase(INCLUDE)) {
                    this.includeRegEx = Generate.validateFilePatternArgs(INCLUDE, arg);
                } else if (gettingArgumentsForCommand.equalsIgnoreCase(EXCLUDE)) {
                    this.excludeRegEx = Generate.validateFilePatternArgs(EXCLUDE, arg);
                }
                gettingArgumentsForCommand = null;
                continue;
            }
            String lowerArg = arg.toLowerCase();
            if (!arg.startsWith("--")) continue;
            if (lowerArg.equals(OVERWRITE)) {
                this.forceOverwrite = true;
                Logger.info((String)"--overwrite: We will force overwrite target files", (Object[])new Object[0]);
                continue;
            }
            if (lowerArg.equalsIgnoreCase(INCLUDE)) {
                gettingArgumentsForCommand = INCLUDE;
                continue;
            }
            if (lowerArg.equalsIgnoreCase(EXCLUDE)) {
                gettingArgumentsForCommand = EXCLUDE;
                continue;
            }
            if (lowerArg.startsWith("--include=")) {
                this.includeRegEx = Generate.validateFilePatternArgs(INCLUDE, arg.split("=")[1]);
                continue;
            }
            if (lowerArg.startsWith("--exclude=")) {
                this.excludeRegEx = Generate.validateFilePatternArgs(EXCLUDE, arg.split("=")[1]);
                continue;
            }
            if (lowerArg.equalsIgnoreCase(WITH_LAYOUT)) {
                this.includeLayout = true;
                continue;
            }
            if (lowerArg.equalsIgnoreCase(WITH_LOGIN)) {
                this.includeLogin = true;
                continue;
            }
            if (lowerArg.equalsIgnoreCase(ALL)) {
                this.forceOverwrite = true;
                this.includeLayout = true;
                this.includeLogin = true;
                continue;
            }
            Logger.warn((String)"Invalid argument: %s", (Object[])new Object[]{arg});
            System.exit(-1);
        }
    }

    public void validate() {
        if (this.includeLogin) {
            try {
                Class.forName("controllers.Secure", false, (ClassLoader)Play.classloader);
            }
            catch (ClassNotFoundException e) {
                Logger.warn((String)" ! controllers.Secure could not be found", (Object[])new Object[0]);
                Logger.warn((String)" ! check application.conf to ensure module.secure is imported", (Object[])new Object[0]);
                this.includeLogin = false;
            }
        }
    }

    public void generateScaffolding() {
        List classes = Play.classloader.getAllClasses();
        ScaffoldingGenerator generator = new ScaffoldingGenerator();
        generator.setForceOverwrite(this.forceOverwrite);
        generator.setIncludeLayout(this.includeLayout);
        generator.setIncludeLogin(this.includeLogin);
        for (Class clazz : classes) {
            PersistenceStrategy persistenceStrategy = PersistenceStrategy.forModel(clazz);
            if (persistenceStrategy == null) continue;
            String simpleName = clazz.getSimpleName();
            boolean includeEntity = false;
            if (this.includeRegEx == null) {
                includeEntity = true;
            }
            if (this.includeRegEx != null && Generate.match(simpleName, this.includeRegEx)) {
                includeEntity = true;
            }
            if (this.excludeRegEx != null && Generate.match(simpleName, this.excludeRegEx)) {
                includeEntity = false;
            }
            if (includeEntity) {
                Entity entity = new Entity(clazz);
                if (persistenceStrategy == PersistenceStrategy.PURE_JPA) {
                    String idField = entity.getIdField();
                    if (idField == null) {
                        Logger.warn((String)"Can not process %s because it needs an @Id annotated column", (Object[])new Object[]{simpleName});
                        continue;
                    }
                    if (!Fields.annotations(clazz, idField).contains(GeneratedValue.class)) {
                        Logger.warn((String)"Can not process %s because key must be auto-generated (use @GeneratedValue)", (Object[])new Object[]{simpleName});
                        continue;
                    }
                }
                generator.addEntity(entity);
                continue;
            }
            Logger.info((String)"Skipping %s", (Object[])new Object[]{simpleName});
        }
        generator.generate();
    }

    public void run(String[] args) {
        this.parseArguments(args);
        this.validate();
        this.generateScaffolding();
    }

    public static void main(String[] args) throws Exception {
        File root = new File(System.getProperty("application.path"));
        Play.init((File)root, (String)System.getProperty("play.id", ""));
        Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
        MessagesPlugin plugin = new MessagesPlugin();
        plugin.onApplicationStart();
        Generate generator = new Generate();
        generator.run(args);
    }

    private static String validateFilePatternArgs(String cmd, String arg) {
        if (arg.isEmpty()) {
            Logger.warn((String)(cmd + ": " + INVALID_MODELPATTERN), (Object[])new Object[0]);
            System.exit(-1);
        }
        String regex = arg;
        Logger.info((String)(cmd + ": files that match: %s"), (Object[])new Object[]{regex});
        return regex;
    }

    public static boolean match(String text, String pattern) {
        String normalizedText = text.toLowerCase();
        String normalizedPattern = pattern.toLowerCase();
        String[] subsections = normalizedPattern.split("[\\*~]");
        int section = 0;
        for (String subsection : subsections) {
            int idx = normalizedText.indexOf(subsection);
            if (idx == -1) {
                return false;
            }
            if (section == 0 && !normalizedPattern.startsWith("*") && !normalizedPattern.startsWith("~") && idx != 0) {
                return false;
            }
            if (!(section != subsections.length - 1 || normalizedPattern.endsWith("*") || normalizedPattern.endsWith("~") || normalizedText.endsWith(subsection))) {
                return false;
            }
            normalizedText = normalizedText.substring(idx + subsection.length());
            ++section;
        }
        return true;
    }
}

