/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scaffold.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.modules.scaffold.Scaffolding;
import play.modules.scaffold.ScaffoldingException;
import play.modules.scaffold.entity.PersistenceStrategy;
import play.modules.scaffold.form.FormElement;
import play.modules.scaffold.strategy.ViewScaffoldingStrategy;
import play.modules.scaffold.utils.Classes;
import play.modules.scaffold.utils.Filterable;
import play.modules.scaffold.utils.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity {
    private String packageName;
    private String name;
    private String controllerName;
    private Class<?> modelType;
    private PersistenceStrategy persistenceStrategy;
    private String idField;
    private Class<?> idClass;
    private List<FormElement> formElements;
    private ViewScaffoldingStrategy scaffoldingStrategy;
    private static Map<String, Entity> ENTITY_CACHE = new HashMap<String, Entity>();

    public Entity(Class<?> clazz) {
        this.modelType = clazz;
        this.name = clazz.getSimpleName();
        this.packageName = Classes.getPackageName(clazz);
        Scaffolding scaffolding = clazz.getAnnotation(Scaffolding.class);
        String controllerOverride = null;
        if (scaffolding != null) {
            controllerOverride = scaffolding.controller();
        }
        this.controllerName = controllerOverride != null ? controllerOverride : Strings.pluralize(this.name);
        this.persistenceStrategy = PersistenceStrategy.forModel(clazz);
        if (this.persistenceStrategy == null) {
            this.persistenceStrategy = PersistenceStrategy.forEmbeddable(clazz);
        }
        if (this.persistenceStrategy == null) {
            throw new ScaffoldingException("Could not determine persistence strategy for " + clazz.getName());
        }
        this.scaffoldingStrategy = this.persistenceStrategy.getViewScaffoldingStrategy();
        this.formElements = new ArrayList<FormElement>();
        List<Field> fields = Entity.publicFields(clazz);
        for (Field field : fields) {
            if (this.persistenceStrategy.isId(field)) {
                this.idField = field.getName();
                this.idClass = field.getType();
            }
            this.addFormElement(field);
        }
    }

    public static List<Field> publicFields(Class<?> clazz) {
        List<Field> fields = Classes.publicFields(clazz);
        Filterable.remove(fields, new Filterable<Field>(){

            @Override
            public boolean filter(Field input) {
                int modifiers = input.getModifiers();
                return Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers);
            }
        });
        return fields;
    }

    private void addFormElement(Field field) {
        FormElement formElement = this.scaffoldingStrategy.render(field);
        if (formElement != null) {
            this.formElements.add(formElement);
        }
    }

    public List<FormElement> getFormElements() {
        return this.formElements;
    }

    public String getIdField() {
        return this.idField;
    }

    public Class<?> getModelType() {
        return this.modelType;
    }

    public Class<?> getIdClass() {
        return this.idClass;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public PersistenceStrategy getPersistenceStrategy() {
        return this.persistenceStrategy;
    }

    public ViewScaffoldingStrategy getScaffoldingStrategy() {
        return this.scaffoldingStrategy;
    }

    public String getPackage() {
        return this.packageName;
    }

    public boolean getUsesPlayModelSupport() {
        return this.persistenceStrategy.getUsesPlayModelSupport();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
    }

    public String toString() {
        return "Entity [packageName=" + this.packageName + ", name=" + this.name + "]";
    }

    public static Entity from(Class<?> clazz) {
        Entity entity = ENTITY_CACHE.get(clazz.getName());
        if (entity == null) {
            entity = new Entity(clazz);
            ENTITY_CACHE.put(clazz.getName(), entity);
        }
        return entity;
    }
}

