/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scaffold.form;

import java.lang.reflect.Field;
import java.util.List;
import play.modules.scaffold.entity.Entity;
import play.modules.scaffold.form.FormElementType;
import play.modules.scaffold.utils.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormElement {
    private String label;
    private String name;
    private Class<?> fieldType;
    private FormElementType formElementType;
    private List<String> options;
    private boolean required;
    private boolean multiple;
    private Entity fieldAsEntity;
    private FormElement parent;

    public FormElement(Field field, FormElementType type) {
        this(field, type, null);
    }

    public FormElement(Field field, FormElementType formElementType, List<String> options) {
        this(field.getName(), field.getType(), formElementType, options);
    }

    public FormElement(FormElement copy, FormElementType formElementType) {
        this(copy, copy.fieldType, formElementType);
    }

    public FormElement(FormElement copy, Class<?> fieldType, FormElementType formElementType) {
        this(copy.name, fieldType, formElementType, copy.options);
    }

    public FormElement(String fieldName, Class<?> fieldType, FormElementType formElementType, List<String> options) {
        this.name = fieldName;
        this.label = Strings.wordify(fieldName);
        this.fieldType = fieldType;
        this.options = options;
        this.formElementType = formElementType;
        if (formElementType == FormElementType.EMBEDDED) {
            this.fieldAsEntity = Entity.from(fieldType);
            List<FormElement> childFormElements = this.fieldAsEntity.getFormElements();
            for (FormElement childFormElement : childFormElements) {
                childFormElement.setParent(this);
            }
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path(".");
    }

    public String path(String separator) {
        if (this.parent != null) {
            FormElement topMostParent = this.parent;
            while (topMostParent.getParent() != null) {
                topMostParent = topMostParent.getParent();
            }
            StringBuilder sb = new StringBuilder();
            while (topMostParent != null) {
                sb.append(topMostParent.getName());
                sb.append(separator);
                topMostParent = topMostParent.getParent();
            }
            sb.append(this.name);
            return sb.toString();
        }
        return this.name;
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public FormElementType getType() {
        return this.formElementType;
    }

    public boolean isCheckbox() {
        return this.formElementType == FormElementType.CHECKBOX;
    }

    public boolean isSelect() {
        return this.formElementType == FormElementType.SELECT;
    }

    public boolean isDate() {
        return this.formElementType == FormElementType.DATE;
    }

    public boolean isText() {
        return this.formElementType == FormElementType.TEXT;
    }

    public boolean isList() {
        return this.formElementType == FormElementType.LIST;
    }

    public boolean isHidden() {
        return this.formElementType == FormElementType.HIDDEN;
    }

    public boolean isPassword() {
        return this.formElementType == FormElementType.PASSWORD;
    }

    public boolean isTextArea() {
        return this.formElementType == FormElementType.TEXTAREA;
    }

    public boolean isRelation() {
        return this.formElementType == FormElementType.RELATION;
    }

    public boolean isEmbedded() {
        return this.formElementType == FormElementType.EMBEDDED;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public Entity getFieldAsEntity() {
        return this.fieldAsEntity;
    }

    public FormElement acceptMultiple() {
        this.multiple = true;
        return this;
    }

    public FormElement getParent() {
        return this.parent;
    }

    public void setParent(FormElement parent) {
        this.parent = parent;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String toString() {
        return this.name + " as " + this.fieldType.getName();
    }
}

