/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scaffold.generator;

import java.util.ArrayList;
import java.util.List;
import play.modules.scaffold.entity.Entity;
import play.modules.scaffold.entity.PersistenceStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseAccessScaffolding {
    public static List<String> additionalImportsFor(PersistenceStrategy strategy) {
        ArrayList<String> imports = new ArrayList<String>();
        switch (strategy) {
            case PLAY_JPA: {
                break;
            }
            case PURE_JPA: {
                imports.add("import play.db.jpa.JPA;");
                break;
            }
            case SIENA: {
                imports.add("import siena.Model;");
            }
        }
        return imports;
    }

    public static String allFor(Class<?> clazz) {
        Entity entity = new Entity(clazz);
        return DatabaseAccessScaffolding.allFor(entity);
    }

    public static String allFor(Entity entity) {
        String query = null;
        switch (entity.getPersistenceStrategy()) {
            case PLAY_JPA: {
                query = entity.getPackageName() + "." + entity.getName() + ".all().fetch()";
                break;
            }
            case PURE_JPA: {
                query = "play.db.jpa.JPA.em().createQuery(\"from " + entity.getName() + "\").getResultList()";
                break;
            }
            case SIENA: {
                query = "siena.Model.all(" + entity.getName() + ".class).fetch()";
            }
        }
        return query;
    }

    public static String findByIdFor(Entity entity) {
        return DatabaseAccessScaffolding.findByIdFor(entity, "id");
    }

    public static String findByIdFor(Entity entity, String fieldName) {
        String stmt = null;
        switch (entity.getPersistenceStrategy()) {
            case PLAY_JPA: {
                stmt = entity.getName() + ".findById(" + fieldName + ")";
                break;
            }
            case PURE_JPA: {
                stmt = "JPA.em().find(" + entity.getModelType().getName() + ".class, " + fieldName + ")";
                break;
            }
            case SIENA: {
                stmt = "Model.all(" + entity.getModelType().getName() + ".class).filter(\"" + entity.getIdField() + "\", " + fieldName + ").get()";
            }
        }
        return stmt;
    }

    public static String saveFor(Entity entity) {
        return DatabaseAccessScaffolding.saveFor(entity, "entity");
    }

    public static String saveFor(Entity entity, String fieldName) {
        String stmt = null;
        switch (entity.getPersistenceStrategy()) {
            case PLAY_JPA: {
                stmt = fieldName + ".save()";
                break;
            }
            case PURE_JPA: {
                stmt = "JPA.em().persist(" + fieldName + ")";
                break;
            }
            case SIENA: {
                stmt = fieldName + ".insert()";
            }
        }
        return stmt;
    }

    public static String updateFor(Entity entity) {
        return DatabaseAccessScaffolding.updateFor(entity, "entity");
    }

    public static String updateFor(Entity entity, String fieldName) {
        String stmt = null;
        switch (entity.getPersistenceStrategy()) {
            case PLAY_JPA: {
                stmt = fieldName + ".save()";
                break;
            }
            case PURE_JPA: {
                stmt = "JPA.em().merge(" + fieldName + ")";
                break;
            }
            case SIENA: {
                stmt = fieldName + ".update()";
            }
        }
        return stmt;
    }

    public static String deleteFor(Entity entity) {
        return DatabaseAccessScaffolding.deleteFor(entity, "entity");
    }

    public static String deleteFor(Entity entity, String fieldName) {
        String stmt = null;
        switch (entity.getPersistenceStrategy()) {
            case PLAY_JPA: {
                stmt = fieldName + ".delete()";
                break;
            }
            case PURE_JPA: {
                stmt = "JPA.em().remove(" + fieldName + ")";
                break;
            }
            case SIENA: {
                stmt = fieldName + ".delete()";
            }
        }
        return stmt;
    }

    public static boolean requiresReattachFor(Entity entity) {
        boolean requiresReattach = false;
        switch (entity.getPersistenceStrategy()) {
            case PLAY_JPA: {
                requiresReattach = true;
            }
        }
        return requiresReattach;
    }

    public static String reattachFor(Entity entity) {
        return DatabaseAccessScaffolding.reattachFor(entity, "entity");
    }

    public static String reattachFor(Entity entity, String fieldName) {
        String stmt = null;
        switch (entity.getPersistenceStrategy()) {
            case PLAY_JPA: {
                stmt = fieldName + ".merge()";
            }
        }
        return stmt;
    }
}

