/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scaffold.strategy;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import play.modules.scaffold.NoScaffolding;
import play.modules.scaffold.ViewScaffoldingOverride;
import play.modules.scaffold.form.FormElement;
import play.modules.scaffold.form.FormElementType;
import play.modules.scaffold.strategy.ViewScaffoldingStrategy;
import play.modules.scaffold.utils.Enums;
import play.modules.scaffold.utils.Fields;

public class DefaultViewScaffoldingStrategy
implements ViewScaffoldingStrategy {
    public FormElement render(Field field) {
        FormElementType type;
        String name = field.getName();
        List options = null;
        Class<Enum> classType = field.getType();
        List<String> annotationNames = Fields.annotationNames(field);
        if (classType.equals(Boolean.class) || classType.equals(Boolean.TYPE)) {
            type = FormElementType.CHECKBOX;
        } else if (classType.equals(Date.class)) {
            type = FormElementType.DATE;
        } else if (classType.isEnum()) {
            type = FormElementType.SELECT;
            Class<Enum> enumClass = classType;
            options = Enums.list((Enum[])Enums.values(enumClass));
        } else {
            type = annotationNames.contains("play.data.validation.Password") ? FormElementType.PASSWORD : FormElementType.TEXT;
        }
        NoScaffolding formHint = field.getAnnotation(NoScaffolding.class);
        if (formHint != null) {
            return null;
        }
        ViewScaffoldingOverride formOverride = field.getAnnotation(ViewScaffoldingOverride.class);
        if (formOverride != null) {
            type = formOverride.type();
        }
        FormElement element = new FormElement(field, type, options);
        if (annotationNames.contains("play.data.validation.Required")) {
            element.setRequired(true);
        }
        return element;
    }
}

