/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scaffold.strategy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import javax.persistence.Embedded;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.apache.commons.lang.StringUtils;
import play.modules.scaffold.form.FormElement;
import play.modules.scaffold.form.FormElementType;
import play.modules.scaffold.strategy.DefaultViewScaffoldingStrategy;
import play.modules.scaffold.utils.Fields;

public class JpaViewScaffoldingStrategy
extends DefaultViewScaffoldingStrategy {
    public FormElement render(Field field) {
        FormElement defaultValue = super.render(field);
        if (defaultValue == null) {
            return null;
        }
        List<Class<? extends Annotation>> annotations = Fields.annotations(field);
        List<String> annotationNames = Fields.annotationNames(field);
        if (defaultValue.getType() == FormElementType.TEXT && annotations.contains(Lob.class)) {
            return new FormElement(defaultValue, FormElementType.TEXTAREA);
        }
        if (annotations.contains(Id.class)) {
            return new FormElement(defaultValue, FormElementType.HIDDEN);
        }
        if (annotations.contains(Embedded.class)) {
            return new FormElement(defaultValue, FormElementType.EMBEDDED);
        }
        if (annotations.contains(OneToOne.class)) {
            OneToOne ann = field.getAnnotation(OneToOne.class);
            if (!StringUtils.isEmpty((String)ann.mappedBy())) {
                return null;
            }
            return new FormElement(defaultValue, FormElementType.RELATION);
        }
        if (annotations.contains(ManyToOne.class)) {
            return new FormElement(defaultValue, FormElementType.RELATION);
        }
        if (Collection.class.isAssignableFrom(field.getType())) {
            Class parameterizedType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            if (annotationNames.contains("javax.persistence.ElementCollection") || annotationNames.contains("org.hibernate.annotations.CollectionOfElements")) {
                return new FormElement(defaultValue, parameterizedType, FormElementType.LIST);
            }
            if (annotations.contains(OneToMany.class)) {
                OneToMany ann = field.getAnnotation(OneToMany.class);
                if (!StringUtils.isEmpty((String)ann.mappedBy())) {
                    return null;
                }
                return new FormElement(defaultValue, parameterizedType, FormElementType.RELATION).acceptMultiple();
            }
            if (annotations.contains(ManyToMany.class)) {
                ManyToMany ann = field.getAnnotation(ManyToMany.class);
                if (!StringUtils.isEmpty((String)ann.mappedBy())) {
                    return null;
                }
                return new FormElement(defaultValue, parameterizedType, FormElementType.RELATION).acceptMultiple();
            }
        }
        return defaultValue;
    }
}

