/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scaffold.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import play.modules.scaffold.utils.Executable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classes {
    public static List<Field> publicFields(Class<?> clazz) {
        final ArrayList<Field> output = new ArrayList<Field>();
        Classes.foreachSuperclass(clazz, false, new Executable<Class<?>>(){

            @Override
            public void execute(Class<?> superclass) {
                Field[] fields;
                for (Field field : fields = superclass.getDeclaredFields()) {
                    if (!Modifier.isPublic(field.getModifiers())) continue;
                    output.add(field);
                }
            }
        });
        return output;
    }

    public static List<String> superclasses(Class<?> clazz) {
        final ArrayList<String> output = new ArrayList<String>();
        Classes.foreachSuperclass(clazz, true, new Executable<Class<?>>(){

            @Override
            public void execute(Class<?> superclass) {
                output.add(superclass.getName());
            }
        });
        return output;
    }

    public static List<String> annotations(Class<?> clazz) {
        Annotation[] annotations;
        ArrayList<String> output = new ArrayList<String>();
        for (Annotation ann : annotations = clazz.getAnnotations()) {
            output.add(ann.annotationType().getName());
        }
        return output;
    }

    private static void foreachSuperclass(Class<?> clazz, boolean skipCurrent, Executable<Class<?>> block) {
        Class<?> superclass = clazz;
        if (skipCurrent) {
            superclass = superclass.getSuperclass();
        }
        if (superclass == null) {
            return;
        }
        do {
            if (superclass == null) continue;
            block.execute(superclass);
        } while ((superclass = superclass.getSuperclass()) != null);
    }

    public static String getPackageName(Class<?> clazz) {
        String fullName = clazz.getName();
        String packageName = "";
        int subpackageIdx = fullName.lastIndexOf(46);
        if (subpackageIdx >= 0) {
            packageName = fullName.substring(0, subpackageIdx);
        }
        return packageName;
    }

    public static boolean isNumeric(Class<?> type) {
        return Number.class.isAssignableFrom(type);
    }
}

