/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scaffold.entity;

import java.lang.reflect.Field;
import java.util.List;
import play.modules.scaffold.strategy.JpaViewScaffoldingStrategy;
import play.modules.scaffold.strategy.SienaViewScaffoldingStrategy;
import play.modules.scaffold.strategy.ViewScaffoldingStrategy;
import play.modules.scaffold.utils.Classes;
import play.modules.scaffold.utils.Fields;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PersistenceStrategy {
    PLAY_JPA,
    PURE_JPA,
    SIENA;


    public ViewScaffoldingStrategy getViewScaffoldingStrategy() {
        switch (this) {
            case PLAY_JPA: {
                return new JpaViewScaffoldingStrategy();
            }
            case PURE_JPA: {
                return new JpaViewScaffoldingStrategy();
            }
            case SIENA: {
                return new SienaViewScaffoldingStrategy();
            }
        }
        return null;
    }

    public boolean isId(Field field) {
        List<String> annotations = Fields.annotationNames(field);
        switch (this) {
            case PLAY_JPA: {
                return annotations.contains("javax.persistence.Id");
            }
            case PURE_JPA: {
                return annotations.contains("javax.persistence.Id");
            }
            case SIENA: {
                return annotations.contains("siena.Id");
            }
        }
        return false;
    }

    public static PersistenceStrategy forModel(Class<?> clazz) {
        List<String> superclasses = Classes.superclasses(clazz);
        List<String> annotations = Classes.annotations(clazz);
        if (superclasses.contains("play.db.jpa.Model")) {
            return PLAY_JPA;
        }
        if (annotations.contains("javax.persistence.Entity")) {
            return PURE_JPA;
        }
        if (superclasses.contains("siena.Model")) {
            return SIENA;
        }
        return null;
    }

    public static PersistenceStrategy forEmbeddable(Class<?> clazz) {
        List<String> annotations = Classes.annotations(clazz);
        if (annotations.contains("javax.persistence.Embeddable")) {
            return PURE_JPA;
        }
        return null;
    }

    public boolean getUsesPlayModelSupport() {
        return this != PURE_JPA;
    }
}

