/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scaffold.generator;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.Logger;
import play.Play;
import play.exceptions.UnexpectedException;
import play.libs.IO;
import play.modules.scaffold.entity.Entity;
import play.modules.scaffold.generator.TargetFileType;
import play.templates.Template;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaffoldingGenerator {
    private static final String FORM_HTML = "_form";
    private static final String CREATE_HTML = "create";
    private static final String SHOW_HTML = "show";
    private static final String EDIT_HTML = "edit";
    private static final String LIST_HTML = "index";
    private static final List<String> VIEW_HTMLS = Arrays.asList("_form", "create", "show", "edit", "index");
    private List<Entity> entities = new ArrayList<Entity>();
    private boolean forceOverwrite;
    private boolean includeLayout;
    private boolean includeLogin;
    private String applicationName = Play.configuration.getProperty("application.name", "Your New Application");

    public static void invokeTemplate(VirtualFile templateFile, File targetFile, Map<String, Object> args) {
        try {
            Class<?> templateCompilerClass;
            String version = Play.version;
            Class<?> templateCompiler = null;
            Method compile = null;
            if (version.startsWith("1.0")) {
                templateCompilerClass = Class.forName("play.templates.TemplateCompiler");
                if (templateCompilerClass != null) {
                    compile = templateCompilerClass.getMethod("compile", VirtualFile.class);
                }
                templateCompiler = templateCompilerClass;
            } else {
                templateCompilerClass = Class.forName("play.templates.GroovyTemplateCompiler");
                if (templateCompilerClass != null) {
                    compile = templateCompilerClass.getMethod("compile", VirtualFile.class);
                }
                templateCompiler = templateCompilerClass.newInstance();
            }
            if (templateCompiler == null || templateCompiler == null) {
                Logger.error((String)"Error looking up the template compiler method", (Object[])new Object[0]);
                System.exit(-1);
            }
            Template template = (Template)compile.invoke(templateCompiler, templateFile);
            String output = template.render(args);
            IO.writeContent((CharSequence)output, (File)targetFile);
        }
        catch (UnexpectedException e) {
            Logger.warn((Throwable)e, (String)("! Failed to generate output successfully: " + e.getMessage()), (Object[])new Object[0]);
        }
        catch (Throwable t) {
            Logger.fatal((Throwable)t, (String)("! Unexpected error processing template: " + templateFile.getName()), (Object[])new Object[]{args});
            System.out.println(templateFile.contentAsString());
            System.exit(-1);
        }
    }

    public void addEntity(Entity entity) {
        this.entities.add(entity);
    }

    public void generate() {
        if (this.isIncludeLayout()) {
            this.generateLayout();
            this.generateHome();
        }
        if (this.includeLogin) {
            this.generateLogin();
        }
        for (Entity entity : this.entities) {
            this.generate(entity);
        }
    }

    public void generate(Entity entity) {
        this.generateController(entity);
        this.generateViewsForEntity(entity);
    }

    private void generate(String templatePath, String targetPath) {
        this.generate(templatePath, targetPath, new HashMap<String, Object>());
    }

    private void generate(String templatePath, String targetPath, Map<String, Object> templateArgs) {
        templateArgs.put("applicationName", this.applicationName);
        templateArgs.put("includeLogin", this.includeLogin);
        templateArgs.put("entities", this.entities);
        templateArgs.put("tagOpen", "#{");
        templateArgs.put("exprOpen", "${");
        templateArgs.put("actionOpen", "@{");
        VirtualFile targetFile = Play.getVirtualFile((String)targetPath);
        VirtualFile templateFile = Play.getVirtualFile((String)templatePath);
        if (targetFile == null || !targetFile.exists() || this.forceOverwrite) {
            File fileToCreate = Play.getFile((String)targetPath);
            if (templateFile == null || !templateFile.exists()) {
                Logger.error((String)("!! ERROR: Can't find scaffold template -- " + templatePath), (Object[])new Object[0]);
            }
            ScaffoldingGenerator.invokeTemplate(templateFile, fileToCreate, templateArgs);
            Logger.info((String)("+ " + targetPath), (Object[])new Object[0]);
        } else {
            Logger.info((String)("! Skipping " + targetPath), (Object[])new Object[0]);
        }
    }

    private void copyFile(TargetFileType type, String fileName) {
        String[] paths = this.getPaths(type, fileName, fileName);
        this.copyFile(paths[0], paths[1]);
    }

    private void generate(TargetFileType type, String fileName) {
        String[] paths = this.getPaths(type, fileName, fileName);
        this.generate(paths[0], paths[1]);
    }

    private void generate(TargetFileType type, String sourceFileName, String targetName) {
        String[] paths = this.getPaths(type, null, sourceFileName, targetName);
        this.generate(paths[0], paths[1]);
    }

    private void generate(TargetFileType type, String sourceFolderName, String sourceFileName, String targetName) {
        String[] paths = this.getPaths(type, sourceFolderName, sourceFileName, targetName);
        this.generate(paths[0], paths[1]);
    }

    private void generateForEntity(Entity entity, TargetFileType type, String templateFolderPath, String templateFileName, String targetName) {
        String[] paths = this.getPaths(type, templateFolderPath, templateFileName, targetName);
        HashMap<String, Object> templateArgs = new HashMap<String, Object>();
        templateArgs.put("entity", entity);
        this.generate(paths[0], paths[1], templateArgs);
    }

    private String[] getPaths(TargetFileType type, String templateFileName, String targetFileName) {
        return this.getPaths(type, null, templateFileName, targetFileName);
    }

    private String[] getPaths(TargetFileType type, String templateFolderPath, String templateFileName, String targetFileName) {
        String[] fileSplit;
        String sourceFileName = templateFolderPath != null ? templateFolderPath + '/' + templateFileName.toLowerCase() : templateFileName.toLowerCase();
        StringBuilder baseTemplatePath = new StringBuilder("app/views/scaffold/");
        if (type != TargetFileType.LAYOUT) {
            baseTemplatePath.append(type.getPath() + '/');
        }
        String templateFile = baseTemplatePath.toString() + sourceFileName + type.getSourceSuffix();
        String targetPath = "app/";
        String additionalPath = type.getPath();
        if (additionalPath.length() > 0) {
            targetPath = targetPath + additionalPath + '/';
        }
        this.ensureDirectoryExists(targetPath);
        if (targetFileName.contains("/") && (fileSplit = targetFileName.split("/")).length >= 2) {
            this.ensureDirectoryExists(targetPath + '/' + fileSplit[0]);
        }
        String targetFile = targetPath + targetFileName + type.getTargetSuffix();
        return new String[]{templateFile, targetFile};
    }

    private void generateController(Entity entity) {
        Class controller = Play.classloader.getClassIgnoreCase(entity.getControllerName());
        if (controller != null) {
            Logger.info((String)("Skipping controller: " + entity.getControllerName()), (Object[])new Object[0]);
            return;
        }
        Logger.info((String)("Generating controller: " + entity.getControllerName()), (Object[])new Object[0]);
        this.generateForEntity(entity, TargetFileType.CONTROLLER, null, "controller", entity.getControllerName());
    }

    private void generateHome() {
        this.generate(TargetFileType.VIEW, "Application", LIST_HTML, "Application/index");
    }

    private void generateLayout() {
        Logger.info((String)"Generating layout: main.html", (Object[])new Object[0]);
        this.generate(TargetFileType.LAYOUT, "main", "views/main");
    }

    private void copyFile(String sourcePath, String targetPath) {
        VirtualFile templateFile = Play.getVirtualFile((String)sourcePath);
        VirtualFile targetFile = Play.getVirtualFile((String)targetPath);
        String templateLayout = templateFile.contentAsString();
        if (targetFile == null || !targetFile.exists() || this.forceOverwrite) {
            try {
                File fileToCreate = Play.getFile((String)targetPath);
                IO.writeContent((CharSequence)templateLayout, (File)fileToCreate);
            }
            catch (UnexpectedException e) {
                Logger.error((Throwable)e, (String)"IO Exception", (Object[])new Object[0]);
            }
            catch (Throwable t) {
                Logger.error((Throwable)t, (String)"Unhandled Exception", (Object[])new Object[0]);
            }
        } else {
            Logger.info((String)("! Skipping " + targetPath), (Object[])new Object[0]);
        }
    }

    private void generateLogin() {
        this.generate(TargetFileType.MODEL, "RoleType");
        this.copyFile(TargetFileType.MODEL, "User");
        this.copyFile(TargetFileType.CONTROLLER, "Security");
        try {
            Entity entity;
            Class clazz = Play.classloader.loadClass("models.User");
            if (clazz != null && !this.entities.contains(entity = new Entity(clazz))) {
                this.generateViewsForEntity(entity);
            }
        }
        catch (ClassNotFoundException e) {
            Logger.error((Throwable)e, (String)"Can't load User class", (Object[])new Object[0]);
        }
        String sourcePath = "app/views/scaffold/views/Secure/login.html";
        String securePath = "app/views/Secure";
        this.ensureDirectoryExists(securePath);
        String targetPath = securePath + '/' + "login.html";
        this.copyFile(sourcePath, targetPath);
    }

    private void generateViewsForEntity(Entity entity) {
        Logger.info((String)("Generating views for " + entity.getControllerName()), (Object[])new Object[0]);
        for (String view : VIEW_HTMLS) {
            this.generateForEntity(entity, TargetFileType.VIEW, "Entity", '/' + view, entity.getControllerName() + '/' + view);
        }
    }

    private void ensureDirectoryExists(String templatePath) {
        File viewPathDirectory = new File(templatePath);
        if (!viewPathDirectory.exists()) {
            viewPathDirectory.mkdir();
        }
    }

    public boolean isForceOverwrite() {
        return this.forceOverwrite;
    }

    public boolean isIncludeLayout() {
        return this.includeLayout;
    }

    public boolean isIncludeLogin() {
        return this.includeLogin;
    }

    public void setForceOverwrite(boolean forceOverwrite) {
        this.forceOverwrite = forceOverwrite;
    }

    public void setIncludeLayout(boolean includeLayout) {
        this.includeLayout = includeLayout;
    }

    public void setIncludeLogin(boolean includeLogin) {
        this.includeLogin = includeLogin;
    }
}

