/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import sbt.CommandSupport$;
import sbt.Help;
import sbt.Keys$;
import sbt.Logger;
import sbt.Path;
import sbt.Path$;
import sbt.State;
import sbt.State$;
import sbt.complete.HistoryCommands$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandSupport$
implements ScalaObject {
    public static final CommandSupport$ MODULE$;
    private final String ContinuousExecutePrefix;
    private final String HelpCommand;
    private final String ProjectCommand;
    private final String ProjectsCommand;
    private final String Exit;
    private final String Quit;
    private final String EvalCommand;
    private final Tuple2<String, String> evalBrief;
    private final String evalDetailed;
    private final String LastCommand;
    private final String LastGrepCommand;
    private final Tuple2<String, String> lastGrepBrief;
    private final String lastGrepDetailed;
    private final Tuple2<String, String> lastBrief;
    private final String lastDetailed;
    private final String InspectCommand;
    private final Tuple2<String, String> inspectBrief;
    private final String inspectDetailed;
    private final String SetCommand;
    private final Tuple2<String, String> setBrief;
    private final String setDetailed;
    private final String TerminateAction;
    private final String AliasCommand;
    private final String FailureWall;

    static {
        new CommandSupport$();
    }

    public Logger logger(State s) {
        return (Logger)State$.MODULE$.stateOps(s).get(Keys$.MODULE$.logged()).getOrElse((Function0)new anonfun.logger.1());
    }

    /*
     * WARNING - void declaration
     */
    public File bootDirectory(State state) {
        void var2_2;
        File exceptionResult1 = null;
        try {
            exceptionResult1 = state.configuration().provider().scalaProvider().launcher().bootDirectory();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            exceptionResult1 = new File(".").getAbsoluteFile();
        }
        return var2_2;
    }

    private Function1<File, Boolean> canRead() {
        return new anonfun.canRead.1();
    }

    public Seq<File> notReadable(Seq<File> files) {
        return (Seq)files.filterNot(this.canRead());
    }

    public Seq<File> readable(Seq<File> files) {
        return (Seq)files.filter(this.canRead());
    }

    public Seq<File> sbtRCs(State s) {
        Path path = Path$.MODULE$.userHome().$div(this.sbtrc());
        File file = Path$.MODULE$.fileToPath(State$.MODULE$.stateOps(s).baseDir()).$div(this.sbtrc()).asFile();
        return Nil$.MODULE$.$colon$colon((Object)file).$colon$colon((Object)Path$.MODULE$.pathToFile(path));
    }

    public Seq<String> readLines(Seq<File> files) {
        return (Seq)((TraversableLike)files.flatMap((Function1)new anonfun.readLines.1(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new anonfun.readLines.2(), Seq$.MODULE$.canBuildFrom());
    }

    public Option<String> processLine(String s) {
        String trimmed = s.trim();
        return this.ignoreLine(trimmed) ? None$.MODULE$ : new Some((Object)trimmed);
    }

    public boolean ignoreLine(String s) {
        return s.isEmpty() || s.startsWith("#");
    }

    public String ContinuousExecutePrefix() {
        return this.ContinuousExecutePrefix;
    }

    public String HelpCommand() {
        return this.HelpCommand;
    }

    public String ProjectCommand() {
        return this.ProjectCommand;
    }

    public String ProjectsCommand() {
        return this.ProjectsCommand;
    }

    public String Exit() {
        return this.Exit;
    }

    public String Quit() {
        return this.Quit;
    }

    public String EvalCommand() {
        return this.EvalCommand;
    }

    public Tuple2<String, String> evalBrief() {
        return this.evalBrief;
    }

    public String evalDetailed() {
        return this.evalDetailed;
    }

    public String LastCommand() {
        return this.LastCommand;
    }

    public String LastGrepCommand() {
        return this.LastGrepCommand;
    }

    public Tuple2<String, String> lastGrepBrief() {
        return this.lastGrepBrief;
    }

    public String lastGrepDetailed() {
        return this.lastGrepDetailed;
    }

    public Tuple2<String, String> lastBrief() {
        return this.lastBrief;
    }

    public String lastDetailed() {
        return this.lastDetailed;
    }

    public String InspectCommand() {
        return this.InspectCommand;
    }

    public Tuple2<String, String> inspectBrief() {
        return this.inspectBrief;
    }

    public String inspectDetailed() {
        return this.inspectDetailed;
    }

    public String SetCommand() {
        return this.SetCommand;
    }

    public Tuple2<String, String> setBrief() {
        return this.setBrief;
    }

    public String setDetailed() {
        return this.setDetailed;
    }

    public String SessionCommand() {
        return "session";
    }

    public Tuple2<String, String> sessionBrief() {
        return new Tuple2((Object)new StringBuilder().append((Object)this.SessionCommand()).append((Object)" ...").toString(), (Object)new StringBuilder().append((Object)"Manipulates session settings.  For details, run 'help ").append((Object)this.SessionCommand()).append((Object)"'..").toString());
    }

    public String TerminateAction() {
        return this.TerminateAction;
    }

    public Tuple2<String, String> continuousBriefHelp() {
        return new Tuple2((Object)new StringBuilder().append((Object)this.ContinuousExecutePrefix()).append((Object)" <action>").toString(), (Object)"Executes the specified command whenever source files change.");
    }

    public Tuple2<String, String> helpBrief() {
        return new Tuple2((Object)new StringBuilder().append((Object)this.HelpCommand()).append((Object)" command*").toString(), (Object)"Displays this help message or prints detailed help on requested commands.");
    }

    public String helpDetailed() {
        return "If an argument is provided, this prints detailed help for that command.\nOtherwise, this prints a help summary.";
    }

    public Tuple2<String, String> projectBrief() {
        return new Tuple2((Object)new StringBuilder().append((Object)this.ProjectCommand()).append((Object)" [project]").toString(), (Object)"Displays the current project or changes to the provided `project`.");
    }

    public String projectDetailed() {
        return new StringBuilder().append((Object)this.ProjectCommand()).append((Object)"\n\tDisplays the name of the current project.\n\n").append((Object)this.ProjectCommand()).append((Object)" name\n\tChanges to the project with the provided name.\n\tThis command fails if there is no project with the given name.\n").append((Object)this.ProjectCommand()).append((Object)" /\n\tChanges to the initial project.\n").append((Object)this.ProjectCommand()).append((Object)" ..\n\tChanges to the parent project of the current project.\n\tIf there is no parent project, the current project is unchanged.\n\n\tUse n+1 dots to change to the nth parent.\n\tFor example, 'project ....' is equivalent to three consecutive 'project ..' commands.\n").toString();
    }

    public String projectsBrief() {
        return this.projectsDetailed();
    }

    public String projectsDetailed() {
        return "Displays the names of available projects.";
    }

    public Seq<Help> historyHelp() {
        return (Seq)HistoryCommands$.MODULE$.descriptions().map((Function1)new anonfun.historyHelp.1(), Seq$.MODULE$.canBuildFrom());
    }

    public Tuple2<String, String> exitBrief() {
        return new Tuple2((Object)this.TerminateAction(), (Object)"Terminates the build.");
    }

    public String sbtrc() {
        return ".sbtrc";
    }

    public String ReadCommand() {
        return "<";
    }

    public String ReadFiles() {
        return " file1 file2 ...";
    }

    public Tuple2<String, String> ReadBrief() {
        return new Tuple2((Object)new StringBuilder().append((Object)this.ReadCommand()).append((Object)" file*").toString(), (Object)"Reads command lines from the provided files.");
    }

    public String ReadDetailed() {
        return new StringBuilder().append((Object)this.ReadCommand()).append((Object)this.ReadFiles()).append((Object)"\n\tReads the lines from the given files and inserts them as commands.\n\tAny lines that are empty or that start with # are ignored.\n\tIf a file does not exist or is not readable, this command fails.\n\n\tAll commands are read before any are executed.\n\tTherefore, if any file is not readable, no commands from any files will be\n\trun.\n\n\tYou probably need to escape this command if entering it at your shell.\n").toString();
    }

    public String DefaultsCommand() {
        return "add-default-commands";
    }

    public Tuple2<String, String> DefaultsBrief() {
        return new Tuple2((Object)this.DefaultsCommand(), (Object)this.DefaultsDetailed());
    }

    public String DefaultsDetailed() {
        return "Registers default built-in commands";
    }

    public String RebootCommand() {
        return "reboot";
    }

    public String RebootSummary() {
        return new StringBuilder().append((Object)this.RebootCommand()).append((Object)" [full]").toString();
    }

    public Tuple2<String, String> RebootBrief() {
        return new Tuple2((Object)this.RebootSummary(), (Object)"Reboots sbt and then executes the remaining commands.");
    }

    public String RebootDetailed() {
        return new StringBuilder().append((Object)this.RebootSummary()).append((Object)"\n\tThis command is equivalent to exiting sbt, restarting, and running the\n\t remaining commands with the exception that the jvm is not shut down.\n\tIf 'full' is specified, the `project/boot` directory is deleted before\n\t restarting.  This forces an update of sbt and Scala and is useful when\n\t working with development versions of sbt or Scala.\n").toString();
    }

    public String Multi() {
        return ";";
    }

    public Tuple2<String, String> MultiBrief() {
        return new Tuple2((Object)new StringBuilder().append((Object)"( ").append((Object)this.Multi()).append((Object)" command )+").toString(), (Object)"Runs the provided semicolon-separated commands.");
    }

    public String MultiDetailed() {
        return new StringBuilder().append((Object)this.Multi()).append((Object)" command1 ").append((Object)this.Multi()).append((Object)" command2 ...\n\tRuns the specified commands.\n").toString();
    }

    public String Append() {
        return "append";
    }

    public Tuple2<String, String> AppendLastBrief() {
        return new Tuple2((Object)new StringBuilder().append((Object)this.Append()).append((Object)" command").toString(), (Object)this.AppendLastDetailed());
    }

    public String AppendLastDetailed() {
        return "Appends `command` to list of commands to run.";
    }

    public String AliasCommand() {
        return this.AliasCommand;
    }

    public Tuple2<String, String> AliasBrief() {
        return new Tuple2((Object)this.AliasCommand(), (Object)"Adds, removes, or prints command aliases.");
    }

    public String AliasDetailed() {
        return new StringBuilder().append((Object)this.AliasCommand()).append((Object)"\n\tPrints a list of defined aliases.\n\n").append((Object)this.AliasCommand()).append((Object)" name\n\tPrints the alias defined for `name`.\n\n").append((Object)this.AliasCommand()).append((Object)" name=value\n\tSets the alias `name` to `value`, replacing any existing alias with that name.\n\tWhenever `name` is entered, value is run.\n\tIf any arguments are provided to `name`, those are appended to `value`.\n\n").append((Object)this.AliasCommand()).append((Object)" name=\n\tRemoves the alias for `name`.\n").toString();
    }

    public String Discover() {
        return "discover";
    }

    public Tuple2<String, String> DiscoverBrief() {
        return new Tuple2((Object)this.DiscoverSyntax(), (Object)"Finds annotated classes and subclasses.");
    }

    public String DiscoverSyntax() {
        return new StringBuilder().append((Object)this.Discover()).append((Object)" [-module true|false] [-sub <names>] [-annot <names>]").toString();
    }

    public String DiscoverDetailed() {
        return new StringBuilder().append((Object)this.DiscoverSyntax()).append((Object)"\n\n\tLooks for public, concrete classes that match the requested query using the current sbt.inc.Analysis instance.\n\t\n\t-module\n\t\tSpecifies whether modules (true) or classes (false) are found.\n\t\tThe default is classes/traits (false).\n\t\n\t-sub\n\t\tSpecifies comma-separated class names.\n\t\tClasses that have one or more of these classes as an ancestor are included in the resulting list.\n\t\n\t-annot\n\t\tSpecifies comma-separated annotation names.\n\t\tClasses with one or more of these annotations on the class or one of its non-private methods are included in the resulting list.\n").toString();
    }

    public String CompileName() {
        return "direct-compile";
    }

    public Tuple2<String, String> CompileBrief() {
        return new Tuple2((Object)this.CompileSyntax(), (Object)"Incrementally compiles the provided sources.");
    }

    public String CompileSyntax() {
        return new StringBuilder().append((Object)this.CompileName()).append((Object)" -src <paths> [-cp <paths>] [-d <path>]").toString();
    }

    public String CompileDetailed() {
        return new StringBuilder().append((Object)this.CompileSyntax()).append((Object)"\n\n\tIncrementally compiles Scala and Java sources.\n\t\n\t<paths> are explicit paths separated by the platform path separator.\n\t\n\tThe specified output path will contain the following directory structure:\n\t\n\t\tscala_<version>/\n\t\t\tclasses/\n\t\t\tcache/\n\n\tCompiled classes will be written to the 'classes' directory.\n\tCached information about the compilation will be written to 'cache'.\n").toString();
    }

    public String FailureWall() {
        return this.FailureWall;
    }

    public String Load() {
        return "load";
    }

    public String LoadLabel() {
        return "a project";
    }

    public String LoadCommand() {
        return "load-commands";
    }

    public String LoadCommandLabel() {
        return "commands";
    }

    public String LoadFailed() {
        return "load-failed";
    }

    public String LoadProjectImpl() {
        return "loadp";
    }

    public String LoadProject() {
        return "reload";
    }

    public Tuple2<String, String> LoadProjectBrief() {
        return new Tuple2((Object)this.LoadProject(), (Object)this.LoadProjectDetailed());
    }

    public String LoadProjectDetailed() {
        return "Loads the project in the current directory";
    }

    public String Shell() {
        return "shell";
    }

    public String ShellBrief() {
        return this.ShellDetailed();
    }

    public String ShellDetailed() {
        return "Provides an interactive prompt from which commands can be run.";
    }

    public String ClearOnFailure() {
        return "--";
    }

    public String OnFailure() {
        return "-";
    }

    public Tuple2<String, String> OnFailureBrief() {
        return new Tuple2((Object)new StringBuilder().append((Object)this.OnFailure()).append((Object)" command").toString(), (Object)"Registers 'command' to run if a command fails.");
    }

    public String OnFailureDetailed() {
        return new StringBuilder().append((Object)this.OnFailure()).append((Object)" command\n\tRegisters 'command' to run when a command fails to complete normally.\n\tOnly one failure command may be registered at a time, so this\n\t  command replaces the previous command if there is one.\n\tThe failure command is reset when it runs, so it must be added again\n\t  if desired.\n").toString();
    }

    public String IfLast() {
        return "iflast";
    }

    public Tuple2<String, String> IfLastBrief() {
        return new Tuple2((Object)new StringBuilder().append((Object)this.IfLast()).append((Object)" command").toString(), (Object)this.IfLastCommon());
    }

    public String IfLastCommon() {
        return "If there are no more commands after this one, 'command' is run.";
    }

    public String IfLastDetailed() {
        return new StringBuilder().append((Object)this.IfLast()).append((Object)" command\n\n\t").append((Object)this.IfLastCommon()).toString();
    }

    public String InitCommand() {
        return "initialize";
    }

    public Tuple2<String, String> InitBrief() {
        return new Tuple2((Object)this.InitCommand(), (Object)"Initializes command processing.");
    }

    public String InitDetailed() {
        return new StringBuilder().append((Object)this.InitCommand()).append((Object)"\n\tInitializes command processing.\n\nRuns the following commands.\n\ndefaults\n\tRegisters default commands.\n\nload-commands -base ~/.sbt/commands\n\tBuilds and loads command definitions from ~/.sbt/commands\n\n< ~/.sbtrc\n< .sbtrc\n\tRuns commands from ~/.sbtrc and ./.sbtrc if they exist\n").toString();
    }

    private CommandSupport$() {
        MODULE$ = this;
        this.ContinuousExecutePrefix = "~";
        this.HelpCommand = "help";
        this.ProjectCommand = "project";
        this.ProjectsCommand = "projects";
        this.Exit = "exit";
        this.Quit = "quit";
        this.EvalCommand = "eval";
        this.evalBrief = new Tuple2((Object)new StringBuilder().append((Object)this.EvalCommand()).append((Object)" <expression>").toString(), (Object)"Evaluates the given Scala expression and prints the result and type.");
        this.evalDetailed = new StringBuilder().append((Object)this.EvalCommand()).append((Object)" <expression>\n\tEvaluates the given Scala expression and prints the result and type.\n").toString();
        this.LastCommand = "last";
        this.LastGrepCommand = "last-grep";
        this.lastGrepBrief = new Tuple2((Object)new StringBuilder().append((Object)this.LastGrepCommand()).append((Object)" <pattern> <key>").toString(), (Object)"Shows lines from the last output for 'key' that match 'pattern'.");
        this.lastGrepDetailed = new StringBuilder().append((Object)this.LastGrepCommand()).append((Object)" <pattern> [key]\n\n\t<pattern> is a regular expression interpreted by java.util.Pattern.\n\tLines that match 'pattern' from the last streams output associated with the key are displayed.\n\tIf no key is specified, the global streams output is used.\n\tSee also ").append((Object)this.LastCommand()).append((Object)".").toString();
        this.lastBrief = new Tuple2((Object)new StringBuilder().append((Object)this.LastCommand()).append((Object)" <key>").toString(), (Object)"Prints the last output associated with 'key'.");
        this.lastDetailed = new StringBuilder().append((Object)this.LastCommand()).append((Object)" <key>\n\n\tRedisplays the last streams output associated with the key (typically a task key).\n\tIf no key is specified, the global streams output is displayed.\n\tSee also ").append((Object)this.LastGrepCommand()).append((Object)".").toString();
        this.InspectCommand = "inspect";
        this.inspectBrief = new Tuple2((Object)new StringBuilder().append((Object)this.InspectCommand()).append((Object)" <key>").toString(), (Object)"Prints the value for 'key', the defining scope, delegates, related definitions, and dependencies.");
        this.inspectDetailed = new StringBuilder().append((Object)this.InspectCommand()).append((Object)" <key>\n\n\tFor a plain setting, the value bound to the key argument is displayed using its toString method.\n\tOtherwise, the type of task (\"Task\" or \"Input task\") is displayed.\n\t\n\t\"Dependencies\" shows the settings that this setting depends on.\n\t\"Reverse dependencies\" shows the settings that depend on this setting.\n\n\tWhen a key is resolved to a value, it may not actually be defined in the requested scope.\n\tIn this case, there is a defined search sequence.\n\t\"Delegates\" shows the scopes that are searched for the key.\n\t\"Provided by\" shows the scope that contained the value returned for the key.\n\n\t\"Related\" shows all of the scopes in which the key is defined.\n").toString();
        this.SetCommand = "set";
        this.setBrief = new Tuple2((Object)new StringBuilder().append((Object)this.SetCommand()).append((Object)" <setting-expression>").toString(), (Object)"Evaluates the given Setting and applies to the current project.");
        this.setDetailed = new StringBuilder().append((Object)this.SetCommand()).append((Object)" <setting-expression>\n\n\tApplies the given setting to the current project:\n\t  1) Constructs the expression provided as an argument by compiling and loading it.\n\t  2) Appends the new setting to the current project's settings.\n\t  3) Re-evaluates the build's settings.\n\n\tThis command does not rebuild the build definitions, plugins, or configurations.\n\tIt does not automatically persist the setting.\n\tThis is done by running 'settings save' or 'settings save-all'.\n").toString();
        this.TerminateAction = this.Exit();
        this.AliasCommand = "alias";
        this.FailureWall = "---";
    }
}

