/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import sbt.BuildPaths$;
import sbt.BuiltinCommands$;
import sbt.Command$;
import sbt.CommandSupport$;
import sbt.Extracted;
import sbt.IO$;
import sbt.Init;
import sbt.Load;
import sbt.Project$;
import sbt.ProjectRef;
import sbt.ResolvedProject;
import sbt.SessionSettings;
import sbt.SessionSettings$;
import sbt.State;
import sbt.compiler.Eval;
import sbt.complete.DefaultParsers$;
import sbt.complete.Parser;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionSettings$
implements ScalaObject,
Serializable {
    public static final SessionSettings$ MODULE$;
    private Parser<ScalaObject> parser;
    private Parser<SessionSettings.Remove> remove;
    public volatile int bitmap$0;

    static {
        new SessionSettings$();
    }

    public State reapply(SessionSettings session, State s) {
        return BuiltinCommands$.MODULE$.reapply(session, Project$.MODULE$.structure(s), s);
    }

    public State clearSettings(State s$6) {
        return this.withSettings(s$6, (Function1<SessionSettings, State>)new anonfun.clearSettings.1(s$6));
    }

    public State clearAllSettings(State s$5) {
        return this.withSettings(s$5, (Function1<SessionSettings, State>)new anonfun.clearAllSettings.1(s$5));
    }

    public State withSettings(State s, Function1<SessionSettings, State> f) {
        State state;
        Extracted extracted = Project$.MODULE$.extract(s);
        if (extracted.session().prepend().isEmpty() && extracted.session().append().isEmpty()) {
            CommandSupport$.MODULE$.logger(s).info((Function0)new anonfun.withSettings.1());
            state = s;
        } else {
            state = (State)f.apply((Object)extracted.session());
        }
        return state;
    }

    public <T> Seq<T> removeRanges(Seq<T> in, Seq<Tuple2<Integer, Integer>> ranges) {
        Set set2 = Predef$.MODULE$.Set().empty();
        Set asSet$1 = (Set)ranges.$div$colon((Object)set2, (Function2)new anonfun.2());
        return (Seq)((TraversableLike)in.zipWithIndex(Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new anonfun.removeRanges.1(asSet$1), Seq$.MODULE$.canBuildFrom());
    }

    public State removeSettings(State s$7, Seq<Tuple2<Integer, Integer>> ranges$1) {
        return this.withSettings(s$7, (Function1<SessionSettings, State>)new anonfun.removeSettings.1(s$7, ranges$1));
    }

    public State saveAllSettings(State s) {
        return this.saveSomeSettings(s, (Function1<ProjectRef, Boolean>)new anonfun.saveAllSettings.1());
    }

    public State saveSettings(State s) {
        ProjectRef current$1 = Project$.MODULE$.session(s).current();
        return this.saveSomeSettings(s, (Function1<ProjectRef, Boolean>)new anonfun.saveSettings.1(current$1));
    }

    public State saveSomeSettings(State s$9, Function1<ProjectRef, Boolean> include$1) {
        return this.withSettings(s$9, (Function1<SessionSettings, State>)new anonfun.saveSomeSettings.1(s$9, include$1));
    }

    public void writeSettings(ProjectRef pref$1, Seq<Tuple2<Init.Setting<?>, String>> settings2, Load.BuildStructure structure) {
        Seq seq;
        ResolvedProject project$1 = (ResolvedProject)Project$.MODULE$.getProject(pref$1, structure).getOrElse((Function0)new anonfun.4(pref$1));
        File appendTo = (File)BuildPaths$.MODULE$.configurationSources(project$1.base()).headOption().getOrElse((Function0)new anonfun.5(project$1));
        Seq baseAppend = (Seq)this.settingStrings(settings2).flatMap((Function1)new anonfun.6(), Seq$.MODULE$.canBuildFrom());
        if (appendTo.isFile() && this.hasTrailingBlank((Seq<String>)IO$.MODULE$.readLines(appendTo, IO$.MODULE$.readLines$default$2()))) {
            seq = baseAppend;
        } else {
            String string = "";
            seq = (Seq)baseAppend.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        }
        Seq adjustedLines = seq;
        File x$61 = appendTo;
        Seq x$62 = adjustedLines;
        boolean x$63 = true;
        Charset x$64 = IO$.MODULE$.writeLines$default$3();
        IO$.MODULE$.writeLines(x$61, x$62, x$64, true);
    }

    public boolean hasTrailingBlank(Seq<String> lines) {
        return ((IterableLike)lines.takeRight(1)).exists((Function1)new anonfun.hasTrailingBlank.1());
    }

    public State printAllSettings(State s$3) {
        return this.withSettings(s$3, (Function1<SessionSettings, State>)new anonfun.printAllSettings.1(s$3));
    }

    public State printSettings(State s$4) {
        return this.withSettings(s$4, (Function1<SessionSettings, State>)new anonfun.printSettings.1(s$4));
    }

    public void printSettings(Seq<Tuple2<Init.Setting<?>, String>> settings2) {
        ((IterableLike)this.settingStrings(settings2).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new anonfun.printSettings.2());
    }

    public Seq<String> settingStrings(Seq<Tuple2<Init.Setting<?>, String>> s) {
        return (Seq)s.map((Function1)new anonfun.settingStrings.1(), Seq$.MODULE$.canBuildFrom());
    }

    public String Help() {
        return "session <command>\n\nManipulates session settings, which are temporary settings that do not persist past the current sbt execution (that is, the current session).\nValid commands are:\n\nclear, clear-all\n\tRemoves temporary settings added using 'set' and re-evaluates all settings.\n\tFor 'clear', only the settings defined for the current project are cleared.\n\tFor 'clear-all', all settings in all projects are cleared.\n\nlist, list-all\n\tPrints a numbered list of session settings defined.\n\tThe numbers may be used to remove individual settings or ranges of settings using 'remove'.\n\tFor 'list', only the settings for the current project are printed.\n\tFor 'list-all', all settings in all projets are printed.\n\nremove <range-spec>\n\t<range-spec> is a comma-separated list of individual numbers or ranges of numbers.\n\tFor example, 'remove 1,3,5-7'.\n\tThe temporary settings at the given indices for the current project are removed and all settings are re-evaluated.\n\tUse the 'list' command to see a numbered list of settings for the current project.\n\nsave, save-all\n\tMakes the session settings permanent by writing them to a '.sbt' configuration file.\n\tFor 'save', only the current project's settings are saved (the settings for other projects are left alone).\n\tFor 'save-all', the session settings are saved for all projects.\n\tThe session settings defined for a project are appended to the first '.sbt' configuration file in that project.\n\tIf no '.sbt' configuration file exists, the settings are written to 'build.sbt' in the project's base directory.";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parser<ScalaObject> parser() {
        if ((this.bitmap$0 & 1) != 0) return this.parser;
        SessionSettings$ sessionSettings$ = this;
        synchronized (sessionSettings$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.parser = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.Space())).$tilde$greater(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichParser("list-all").$up$up$up((Object)new SessionSettings.Print(true)))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichParser("list").$up$up$up((Object)new SessionSettings.Print(false))))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichParser("clear").$up$up$up((Object)new SessionSettings.Clear(false))))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichParser("save-all").$up$up$up((Object)new SessionSettings.Save(true))))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichParser("save").$up$up$up((Object)new SessionSettings.Save(false))))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichParser("clear-all").$up$up$up((Object)new SessionSettings.Clear(true))))).$bar(this.remove()));
                this.bitmap$0 |= 1;
            }
            return this.parser;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Parser<SessionSettings.Remove> remove() {
        if ((this.bitmap$0 & 4) != 0) return this.remove;
        SessionSettings$ sessionSettings$ = this;
        synchronized (sessionSettings$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.remove = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literal("remove"))).$tilde$greater(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.Space()))).$tilde$greater(DefaultParsers$.MODULE$.richParser(this.natSelect()).map((Function1)new anonfun.remove.1()));
                this.bitmap$0 |= 4;
            }
            return this.remove;
        }
    }

    public Parser<Seq<Tuple2<Integer, Integer>>> natSelect() {
        return DefaultParsers$.MODULE$.rep1sep(DefaultParsers$.MODULE$.token(this.range(), "<range>"), DefaultParsers$.MODULE$.literal(','));
    }

    public Parser<Tuple2<Integer, Integer>> range() {
        return DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.NatBasic()).$tilde(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.literalRichParser('-').$tilde$greater(DefaultParsers$.MODULE$.NatBasic())).$qmark())).map((Function1)new anonfun.range.1());
    }

    public Parser<Function0<State>> command(State s$2) {
        return Command$.MODULE$.applyEffect(this.parser(), new anonfun.command.1(s$2));
    }

    public /* synthetic */ Option unapply(SessionSettings x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)x$0.currentBuild(), x$0.currentProject(), x$0.original(), x$0.prepend(), x$0.append(), x$0.currentEval()));
    }

    public /* synthetic */ SessionSettings apply(URI currentBuild, Map currentProject, Seq original, Map prepend, Map append2, Function0 currentEval) {
        return new SessionSettings(currentBuild, (Map<URI, String>)currentProject, original, prepend, append2, (Function0<Eval>)currentEval);
    }

    public Object readResolve() {
        return MODULE$;
    }

    private SessionSettings$() {
        MODULE$ = this;
    }
}

