/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot;

import java.io.File;
import java.net.URL;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import xsbt.boot.AppConfiguration;
import xsbt.boot.BootException;
import xsbt.boot.Configuration$;
import xsbt.boot.Find$;
import xsbt.boot.Initialize$;
import xsbt.boot.Launch$;
import xsbt.boot.Launch$$anonfun$xsbt$boot$Launch$;
import xsbt.boot.LaunchConfiguration;
import xsbt.boot.Launcher$;
import xsbt.boot.Pre$;
import xsbt.boot.ResolveValues$;
import xsbt.boot.RunConfiguration;
import xsbti.AppMain;
import xsbti.AppProvider;
import xsbti.Exit;
import xsbti.FullReload;
import xsbti.Launcher;
import xsbti.MainResult;
import xsbti.Reboot;
import xsbti.ScalaProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Launch$
implements ScalaObject {
    public static final Launch$ MODULE$;

    static {
        new Launch$();
    }

    public void apply(List<String> arguments) {
        this.apply(new File("").getAbsoluteFile(), arguments);
    }

    public void apply(File currentDirectory, List<String> arguments) {
        Tuple2<URL, List<String>> tuple2 = Configuration$.MODULE$.find(arguments, currentDirectory);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        this.configured(currentDirectory, (URL)tuple2._1(), (List<String>)((List)tuple2._2()));
    }

    public void configured(File currentDirectory, URL configLocation, List<String> arguments) {
        LaunchConfiguration config = Configuration$.MODULE$.parse(configLocation, currentDirectory);
        Tuple2<LaunchConfiguration, File> tuple2 = Find$.MODULE$.apply(config, currentDirectory);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        this.parsed((File)tuple2._2(), (LaunchConfiguration)tuple2._1(), arguments);
    }

    public void parsed(File currentDirectory, LaunchConfiguration parsed, List<String> arguments) {
        File propertiesFile = parsed.boot().properties();
        if (Pre$.MODULE$.isNonEmpty(parsed.boot().promptCreate()) && !propertiesFile.exists()) {
            Initialize$.MODULE$.create(propertiesFile, parsed.boot().promptCreate(), parsed.boot().enableQuick(), parsed.appProperties());
        } else if (parsed.boot().promptFill()) {
            Initialize$.MODULE$.fill(propertiesFile, parsed.appProperties());
        }
        this.initialized(currentDirectory, parsed, arguments);
    }

    public void initialized(File currentDirectory, LaunchConfiguration parsed$1, List<String> arguments) {
        parsed$1.logging().debug((Function0<String>)new anonfun.initialized.1(parsed$1));
        LaunchConfiguration resolved$1 = ResolveValues$.MODULE$.apply(parsed$1);
        resolved$1.logging().debug((Function0<String>)new anonfun.initialized.2(resolved$1));
        this.explicit(currentDirectory, resolved$1, arguments);
    }

    public void explicit(File currentDirectory, LaunchConfiguration explicit2, List<String> arguments) {
        Launcher launcher = Launcher$.MODULE$.apply(explicit2);
        this.launch((Function1<RunConfiguration, MainResult>)new anonfun.explicit.1(launcher), new RunConfiguration(explicit2.getScalaVersion(), explicit2.app().toID(), currentDirectory, arguments));
    }

    public MainResult run(Launcher launcher, RunConfiguration config) {
        ScalaProvider scalaProvider = launcher.getScala(config.scalaVersion(), new StringBuilder().append((Object)"(for ").append((Object)config.app().name()).append((Object)")").toString());
        AppProvider appProvider = scalaProvider.app(config.app());
        AppConfiguration appConfig = new AppConfiguration((String[])Pre$.MODULE$.toArray(config.arguments(), ClassManifest$.MODULE$.classType(String.class)), config.workingDirectory(), appProvider);
        AppMain main = appProvider.newMain();
        MainResult exceptionResult1 = null;
        try {
            exceptionResult1 = main.run(appConfig);
            return exceptionResult1;
        }
        catch (FullReload fullReload) {
            if (fullReload.clean()) {
                this.xsbt$boot$Launch$$delete(launcher.bootDirectory());
            }
            throw fullReload;
        }
    }

    public final void xsbt$boot$Launch$$delete(File f) {
        File[] fs;
        if (f.isDirectory() && (fs = f.listFiles()) != null) {
            Predef$.MODULE$.refArrayOps((Object[])fs).foreach((Function1)new anonfun$xsbt$boot$Launch$$delete$1());
        }
        if (f.exists()) {
            f.delete();
        }
    }

    public final void launch(Function1<RunConfiguration, MainResult> run, RunConfiguration config) {
        MainResult mainResult;
        while (true) {
            Reboot reboot;
            if ((mainResult = (MainResult)run.apply((Object)config)) instanceof Exit) {
                System.exit(((Exit)mainResult).code());
                return;
            }
            if (!(mainResult instanceof Reboot)) break;
            Reboot r = reboot = (Reboot)mainResult;
            config = new RunConfiguration(r.scalaVersion(), r.app(), r.baseDirectory(), (List<String>)Predef$.MODULE$.refArrayOps((Object[])r.arguments()).toList());
        }
        MainResult x = mainResult;
        throw new BootException(new StringBuilder().append((Object)"Invalid main result: ").append((Object)x).append((Object)(x == null ? "" : new StringBuilder().append((Object)" (class: ").append(x.getClass()).append((Object)")").toString())).toString());
    }

    private Launch$() {
        MODULE$ = this;
    }
}

