/*
 * Decompiled with CFR 0.152.
 */
package sbt.classfile;

import java.io.File;
import java.lang.reflect.Method;
import sbt.FileFilter;
import sbt.GlobFilter$;
import sbt.Logger;
import sbt.Path;
import sbt.PathFinder;
import sbt.classfile.Analyze$;
import sbt.classfile.Analyze$$anonfun$sbt$classfile$Analyze$;
import sbt.classfile.ClassFile;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.runtime.BoxedUnit;
import xsbti.AnalysisCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Analyze$
implements ScalaObject {
    public static final Analyze$ MODULE$;
    private final String ClassExt;
    private Class<Object> unit;
    private List<Class<String[]>> strArray;
    private final int mainModifiers;
    private final int notMainModifiers;
    public volatile int bitmap$0;

    static {
        new Analyze$();
    }

    public <T> void apply(Path outputDirectory$1, Seq<File> sources, Logger log$1, AnalysisCallback analysis$1, ClassLoader loader$1, Function2<File, Seq<Class<?>>, Object> readAPI$1, Function0<Object> compile) {
        Map sourceMap$1 = sources.groupBy((Function1)new anonfun.1());
        PathFinder classesFinder$1 = outputDirectory$1.$times$times((FileFilter)GlobFilter$.MODULE$.apply("*.class"));
        Set existingClasses$1 = classesFinder$1.get();
        compile.apply$mcV$sp();
        this.analyze$1(outputDirectory$1, log$1, analysis$1, loader$1, readAPI$1, sourceMap$1, classesFinder$1, existingClasses$1);
    }

    public final void sbt$classfile$Analyze$$trapAndLog(Logger log, Function0 execute) {
        try {
            execute.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            log.trace((Function0)new anonfun$sbt$classfile$Analyze$$trapAndLog$1(throwable));
            log.error((Function0)new anonfun$sbt$classfile$Analyze$$trapAndLog$2(throwable));
        }
    }

    public final Some sbt$classfile$Analyze$$guessSourceName(String name) {
        return new Some((Object)this.takeToDollar(this.trimClassExt(name)));
    }

    private String takeToDollar(String name) {
        int dollar = name.indexOf(36);
        return dollar < 0 ? name : name.substring(0, dollar);
    }

    private final String ClassExt() {
        return ".class";
    }

    private String trimClassExt(String name) {
        return name.endsWith(".class") ? name.substring(0, name.length() - ".class".length()) : name;
    }

    public final File sbt$classfile$Analyze$$resolveClassFile(File file, String className) {
        File file2 = file;
        return (File)Predef$.MODULE$.refArrayOps((Object[])new StringBuilder().append((Object)className.replace('.', '/')).append((Object)".class").toString().split("/")).$div$colon((Object)file2, (Function2)new anonfun$sbt$classfile$Analyze$$resolveClassFile$1());
    }

    public final List sbt$classfile$Analyze$$guessSourcePath(Map sourceNameMap, ClassFile classFile$2, Logger log) {
        List<File> candidates$1;
        block3: {
            block4: {
                List<File> list;
                block2: {
                    String[] classNameParts = classFile$2.className().split("\\.");
                    String[] pkg = (String[])Predef$.MODULE$.refArrayOps((Object[])classNameParts).init();
                    String simpleClassName$1 = (String)Predef$.MODULE$.refArrayOps((Object[])classNameParts).last();
                    String sourceFileName = (String)classFile$2.sourceFile().getOrElse((Function0)new anonfun.3(simpleClassName$1));
                    list = candidates$1 = this.findSource((Map<String, Iterable<File>>)sourceNameMap, (List<String>)Predef$.MODULE$.refArrayOps((Object[])pkg).toList(), sourceFileName);
                    Nil$ nil$ = Nil$.MODULE$;
                    List<File> list2 = list;
                    if (nil$ != null ? !nil$.equals(list2) : list2 != null) break block2;
                    log.warn((Function0)new anonfun$sbt$classfile$Analyze$$guessSourcePath$1(classFile$2));
                    break block3;
                }
                if (!(list instanceof .colon.colon)) break block4;
                Nil$ nil$ = Nil$.MODULE$;
                List list3 = ((.colon.colon)list).tl$1();
                if (!(nil$ == null ? list3 != null : !nil$.equals(list3))) break block3;
            }
            log.warn((Function0)new anonfun$sbt$classfile$Analyze$$guessSourcePath$2(classFile$2, candidates$1));
        }
        return candidates$1;
    }

    private List<File> findSource(Map<String, Iterable<File>> sourceNameMap, List<String> pkg, String sourceFileName) {
        return this.refine((List<Tuple2<File, File>>)((List)sourceNameMap.get((Object)sourceFileName).toList().flatten((Function1)Predef$.MODULE$.conforms()).map((Function1)new anonfun.findSource.1(), List$.MODULE$.canBuildFrom())), (List<String>)pkg.reverse());
    }

    private List<File> refine(List<Tuple2<File, File>> sources$1, List<String> pkgRev) {
        List list;
        while (true) {
            String string;
            block5: {
                List<File> list2;
                block4: {
                    block3: {
                        if (!sources$1.isEmpty() && !((IterableLike)sources$1.tail()).isEmpty()) break block3;
                        list2 = this.make$1(sources$1);
                        break block4;
                    }
                    list = pkgRev;
                    Nil$ nil$ = Nil$.MODULE$;
                    List list3 = list;
                    if (nil$ != null ? !nil$.equals(list3) : list3 != null) break block5;
                    list2 = this.shortest((List<File>)this.make$1(sources$1));
                }
                return list2;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            String x$11 = string = (String)colon2.hd$1();
            List retain = (List)sources$1.flatMap((Function1)new anonfun.4(x$11), List$.MODULE$.canBuildFrom());
            pkgRev = colon2.tl$1();
            sources$1 = retain;
        }
        throw new MatchError(list);
    }

    private List<File> shortest(List<File> files) {
        List list;
        if (files.isEmpty()) {
            list = files;
        } else {
            Map fs = files.groupBy((Function1)new anonfun.5());
            list = (List)fs.apply(fs.keys().min((Ordering)Ordering$Int$.MODULE$));
        }
        return list;
    }

    public final int sbt$classfile$Analyze$$distanceToRoot(int acc, File file) {
        while (file != null) {
            file = file.getParentFile();
            ++acc;
        }
        return acc;
    }

    private boolean isTopLevel(ClassFile classFile) {
        return classFile.className().indexOf(36) < 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class<Object> unit() {
        if ((this.bitmap$0 & 1) != 0) return this.unit;
        Analyze$ analyze$ = this;
        synchronized (analyze$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.unit = BoxedUnit.TYPE;
                this.bitmap$0 |= 1;
            }
            return this.unit;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Class<String[]>> strArray() {
        if ((this.bitmap$0 & 4) != 0) return this.strArray;
        Analyze$ analyze$ = this;
        synchronized (analyze$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.strArray = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{String[].class}));
                this.bitmap$0 |= 4;
            }
            return this.strArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMain(Method method) {
        String string = method.getName();
        String string2 = "main";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!this.isMain(method.getModifiers())) return false;
        Class<?> clazz = method.getReturnType();
        Class<Object> clazz2 = this.unit();
        if (clazz == null) {
            if (clazz2 != null) {
                return false;
            }
        } else if (!clazz.equals(clazz2)) return false;
        List list = Predef$.MODULE$.refArrayOps((Object[])method.getParameterTypes()).toList();
        List<Class<String[]>> list2 = this.strArray();
        if (list == null) {
            if (list2 == null) return true;
            return false;
        } else {
            if (!list.equals(list2)) return false;
            return true;
        }
    }

    private boolean isMain(int modifiers) {
        return (modifiers & this.mainModifiers()) == this.mainModifiers() && (modifiers & this.notMainModifiers()) == 0;
    }

    private int mainModifiers() {
        return this.mainModifiers;
    }

    private int notMainModifiers() {
        return this.notMainModifiers;
    }

    public final Option load$1(String tpe, Function0 errMsg, Logger logger, ClassLoader classLoader) {
        Some exceptionResult1 = null;
        try {
            exceptionResult1 = new Some(Class.forName(tpe, false, classLoader));
        }
        catch (Throwable throwable) {
            ((Option)errMsg.apply()).foreach((Function1)new anonfun.load.1.1(logger, throwable));
            exceptionResult1 = None$.MODULE$;
        }
        return exceptionResult1;
    }

    private final void analyze$1(Path path, Logger logger, AnalysisCallback analysisCallback, ClassLoader classLoader, Function2 function2, Map map, PathFinder pathFinder, Set set) {
        Set allClasses = (Set)Predef$.MODULE$.Set().apply(pathFinder.get().toSeq());
        Set newClasses = (Set)allClasses.$minus$minus((TraversableOnce)set);
        HashMap productToSource$1 = new HashMap();
        HashMap sourceToClassFiles$1 = new HashMap();
        newClasses.foreach((Function1)new anonfun.analyze.1.1(path, logger, analysisCallback, map, productToSource$1, sourceToClassFiles$1));
        sourceToClassFiles$1.foreach((Function1)new anonfun.analyze.1.2(path, logger, analysisCallback, classLoader, function2, productToSource$1));
    }

    private final List make$1(List list) {
        return (List)list.map((Function1)new anonfun.make.1.1(), List$.MODULE$.canBuildFrom());
    }

    private Analyze$() {
        MODULE$ = this;
        this.mainModifiers = 9;
        this.notMainModifiers = 1024;
    }
}

