/*
 * Decompiled with CFR 0.152.
 */
package sbt.classpath;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import sbt.DirectoryFilter$;
import sbt.IO$;
import sbt.Path;
import sbt.Path$;
import sbt.PathFinder;
import sbt.ScalaInstance;
import sbt.SimpleFileFilter;
import sbt.classpath.ClasspathUtilities$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.OptManifest;
import scala.tools.nsc.GenericRunnerCommand;
import scala.tools.nsc.GenericRunnerSettings;
import scala.tools.nsc.settings.MutableSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClasspathUtilities$
implements ScalaObject {
    public static final ClasspathUtilities$ MODULE$;
    private ClassLoader rootLoader;
    private final String AppClassPath;
    private final String BootClassPath;
    private Tuple2<Set<File>, Set<File>> x$10;
    private Set<File> extraJars;
    private Set<File> extraDirs;
    public volatile int bitmap$0;

    static {
        new ClasspathUtilities$();
    }

    public ClassLoader toLoader(PathFinder finder) {
        return this.toLoader(finder, this.rootLoader());
    }

    public ClassLoader toLoader(PathFinder finder, ClassLoader parent) {
        return new URLClassLoader(finder.getURLs(), parent);
    }

    public ClassLoader toLoader(Seq<File> paths) {
        return this.toLoader(paths, this.rootLoader());
    }

    public ClassLoader toLoader(Seq<File> paths, ClassLoader parent) {
        return new URLClassLoader(Path$.MODULE$.toURLs(paths), parent);
    }

    public ClassLoader toLoader(Seq<File> paths$1, ClassLoader parent$2, Map<String, String> resourceMap$1) {
        return new anon.1(paths$1, parent$2, resourceMap$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClassLoader rootLoader() {
        if ((this.bitmap$0 & 1) != 0) return this.rootLoader;
        ClasspathUtilities$ classpathUtilities$ = this;
        synchronized (classpathUtilities$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.rootLoader = this.parent$1(this.getClass().getClassLoader());
                this.bitmap$0 |= 1;
            }
            return this.rootLoader;
        }
    }

    public final String AppClassPath() {
        return "app.class.path";
    }

    public final String BootClassPath() {
        return "boot.class.path";
    }

    public Map<String, String> createClasspathResources(Seq<File> classpath, ScalaInstance instance) {
        return this.createClasspathResources((Seq<File>)((Seq)classpath.$plus$plus(instance.jars(), Seq$.MODULE$.canBuildFrom())), (Seq<File>)instance.jars());
    }

    public Map<String, String> createClasspathResources(Seq<File> appPaths, Seq<File> bootPaths) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.make$1("app.class.path", appPaths), this.make$1("boot.class.path", bootPaths)}));
    }

    public <T> ClassLoader makeLoader(Seq<File> classpath, ScalaInstance instance) {
        return this.makeLoader(classpath, instance.loader(), instance);
    }

    public <T> ClassLoader makeLoader(Seq<File> classpath, ClassLoader parent, ScalaInstance instance) {
        return this.toLoader(classpath, parent, this.createClasspathResources(classpath, instance));
    }

    public void printSource(Class<?> c) {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)c.getName()).append((Object)" loader=").append((Object)c.getClassLoader()).append((Object)" location=").append((Object)IO$.MODULE$.classLocationFile(c)).toString());
    }

    public boolean isArchive(Path path) {
        return this.isArchive(path.asFile());
    }

    public boolean isArchive(File file) {
        return this.isArchiveName(file.getName());
    }

    public boolean isArchiveName(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".zip");
    }

    public Tuple2<Iterable<File>, Iterable<File>> separate(Iterable<File> paths) {
        return paths.partition((Function1)new anonfun.separate.1());
    }

    public Tuple2<Iterable<File>, Iterable<File>> separatePaths(Iterable<Path> paths) {
        return this.separate((Iterable<File>)((Iterable)paths.map((Function1)new anonfun.separatePaths.1(), Iterable$.MODULE$.canBuildFrom())));
    }

    public Tuple2<Set<File>, Set<File>> buildSearchPaths(Iterable<Path> classpath) {
        Tuple2<Iterable<File>, Iterable<File>> tuple2 = this.separatePaths(classpath);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        Iterable jars = (Iterable)tuple22._1();
        Iterable dirs = (Iterable)tuple22._2();
        return new Tuple2(this.linkedSet((Iterable)jars.$plus$plus((TraversableOnce)this.extraJars().toList(), Iterable$.MODULE$.canBuildFrom())), this.linkedSet((Iterable)dirs.$plus$plus((TraversableOnce)this.extraDirs().toList(), Iterable$.MODULE$.canBuildFrom())));
    }

    public boolean onClasspath(Set<File> classpathJars, Set<File> classpathDirectories, File file) {
        File f$1 = file.getCanonicalFile();
        return this.isArchive(f$1) ? classpathJars.apply((Object)f$1) : classpathDirectories.toList().find((Function1)new anonfun.onClasspath.1(f$1)).isDefined();
    }

    public Iterable<File> compilerPlugins(Iterable<Path> classpath) {
        URLClassLoader loader = new URLClassLoader(Path$.MODULE$.getURLs(classpath));
        return (Iterable)JavaConversions$.MODULE$.enumerationAsScalaIterator(loader.getResources("scalac-plugin.xml")).toList().flatMap((Function1)new anonfun.compilerPlugins.1(), List$.MODULE$.canBuildFrom());
    }

    public List<File> asFile(URL url) {
        return this.asFile(false, url);
    }

    /*
     * Unable to fully structure code
     */
    public List<File> asFile(boolean jarOnly$1, URL url) {
        exceptionResult1 = null;
        try {
            block5: {
                block4: {
                    v0 = var5_4 = url.getProtocol();
                    var6_5 = "file";
                    if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) break block4;
                    if (!this.gd1$1(jarOnly$1)) ** GOTO lbl-1000
                    var7_6 = IO$.MODULE$.toFile(url);
                    v1 = Nil$.MODULE$.$colon$colon((Object)var7_6);
                    break block5;
                }
                v2 = var5_4;
                var8_7 = "jar";
                if (!(v2 != null ? v2.equals(var8_7) == false : var8_7 != null)) {
                    path = url.getPath();
                    end = path.indexOf(33);
                    var11_10 = new File(new URI(end == -1 ? path : path.substring(0, end)));
                    v1 = Nil$.MODULE$.$colon$colon((Object)var11_10);
                } else lbl-1000:
                // 2 sources

                {
                    v1 = Nil$.MODULE$;
                }
            }
            exceptionResult1 = v1;
        }
        catch (Exception var4_11) {
            exceptionResult1 = Nil$.MODULE$;
        }
        return var3_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private /* synthetic */ Tuple2 x$10() {
        if ((this.bitmap$0 & 4) != 0) return this.x$10;
        ClasspathUtilities$ classpathUtilities$ = this;
        synchronized (classpathUtilities$) {
            if ((this.bitmap$0 & 4) == 0) {
                GenericRunnerSettings settings = new GenericRunnerCommand((List)Nil$.MODULE$, (Function1)new anonfun.1()).settings();
                List bootPaths = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])IO$.MODULE$.pathSplit(((MutableSettings.PathSetting)settings.bootclasspath()).value())).map((Function1)new anonfun.2(), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(File.class)))).toList();
                Tuple2<Iterable<File>, Iterable<File>> tuple2 = this.separate((Iterable<File>)bootPaths);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                Iterable bootJars = (Iterable)tuple22._1();
                Iterable bootDirs = (Iterable)tuple22._2();
                ListBuffer buffer$1 = new ListBuffer();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])IO$.MODULE$.pathSplit(((MutableSettings.PathSetting)settings.extdirs()).value())).map((Function1)new anonfun.3(), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(File.class)}))))).withFilter((Function1)new anonfun.4()).foreach((Function1)new anonfun.5(buffer$1));
                List extJars = (List)buffer$1.readOnly().map((Function1)new anonfun.6(), List$.MODULE$.canBuildFrom());
                Tuple2 tuple23 = new Tuple2(this.linkedSet((Iterable)extJars.$plus$plus((TraversableOnce)bootJars, List$.MODULE$.canBuildFrom())), this.linkedSet(bootDirs));
                if (tuple23 == null) {
                    throw new MatchError((Object)tuple23);
                }
                this.x$10 = new Tuple2(tuple23._1(), tuple23._2());
                this.bitmap$0 |= 4;
            }
            return this.x$10;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<File> extraJars() {
        if ((this.bitmap$0 & 0x10) != 0) return this.extraJars;
        ClasspathUtilities$ classpathUtilities$ = this;
        synchronized (classpathUtilities$) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.extraJars = (Set)this.x$10()._1();
                this.bitmap$0 |= 0x10;
            }
            return this.extraJars;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<File> extraDirs() {
        if ((this.bitmap$0 & 0x40) != 0) return this.extraDirs;
        ClasspathUtilities$ classpathUtilities$ = this;
        synchronized (classpathUtilities$) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.extraDirs = (Set)this.x$10()._2();
                this.bitmap$0 |= 0x40;
            }
            return this.extraDirs;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> Set<T> linkedSet(Iterable<T> s) {
        void var2_2;
        scala.collection.mutable.Set set = JavaConversions$.MODULE$.asScalaSet(new LinkedHashSet());
        set.$plus$plus$eq(s);
        return var2_2;
    }

    private final ClassLoader parent$1(ClassLoader loader) {
        ClassLoader p;
        while ((p = loader.getParent()) != null) {
            loader = p;
        }
        return loader;
    }

    private final Tuple2 make$1(String name, Seq paths) {
        return Predef$.MODULE$.any2ArrowAssoc((Object)name).$minus$greater((Object)Path$.MODULE$.makeString(paths));
    }

    private final /* synthetic */ boolean gd1$1(boolean bl) {
        return !bl;
    }

    public final void findJars$1(File dir, ListBuffer listBuffer) {
        listBuffer.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])dir.listFiles((FileFilter)new SimpleFileFilter((Function1)new anonfun.findJars.1.1()))));
        Predef$.MODULE$.refArrayOps((Object[])dir.listFiles((FileFilter)DirectoryFilter$.MODULE$)).foreach((Function1)new anonfun.findJars.1.2(listBuffer));
    }

    private ClasspathUtilities$() {
        MODULE$ = this;
    }
}

