/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.CodeSource;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sbt.AllPassFilter$;
import sbt.ErrorHandling$;
import sbt.GlobFilter$;
import sbt.IO$;
import sbt.IO$$anonfun$sbt$IO$;
import sbt.NameFilter;
import sbt.Path$;
import sbt.PathFinder;
import sbt.Using;
import sbt.Using$;
import scala.Array$;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.generic.Addable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$String$;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IO$
implements ScalaObject {
    public static final IO$ MODULE$;
    private final int MaximumTries;
    private Random random;
    private final File temporaryDirectory;
    private final int BufferSize;
    private final String Newline;
    private final Charset utf8;
    private final Pattern PathSeparatorPattern;
    public volatile int bitmap$0;

    static {
        new IO$();
    }

    public /* synthetic */ boolean writeLines$default$4() {
        return false;
    }

    public /* synthetic */ Charset writeLines$default$3() {
        return this.defaultCharset();
    }

    public /* synthetic */ Charset readLines$default$2() {
        return this.defaultCharset();
    }

    public /* synthetic */ Charset readLinesURL$default$2() {
        return this.defaultCharset();
    }

    public /* synthetic */ Charset append$default$3() {
        return this.defaultCharset();
    }

    public /* synthetic */ Charset readStream$default$2() {
        return this.defaultCharset();
    }

    public /* synthetic */ Charset read$default$2() {
        return this.defaultCharset();
    }

    public /* synthetic */ Charset reader$default$2() {
        return this.defaultCharset();
    }

    public /* synthetic */ boolean writer$default$4() {
        return false;
    }

    public /* synthetic */ boolean write$default$4() {
        return false;
    }

    public /* synthetic */ Charset write$default$3() {
        return this.defaultCharset();
    }

    public /* synthetic */ boolean copyDirectory$default$4() {
        return false;
    }

    public /* synthetic */ boolean copyDirectory$default$3() {
        return false;
    }

    public /* synthetic */ boolean copyFile$default$3() {
        return false;
    }

    public /* synthetic */ boolean copy$default$3() {
        return false;
    }

    public /* synthetic */ boolean copy$default$2() {
        return false;
    }

    public /* synthetic */ NameFilter unzipURL$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public /* synthetic */ NameFilter unzipStream$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public /* synthetic */ NameFilter unzip$default$3() {
        return AllPassFilter$.MODULE$;
    }

    private int MaximumTries() {
        return this.MaximumTries;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Random random() {
        if ((this.bitmap$0 & 1) != 0) return this.random;
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.random = new Random();
                this.bitmap$0 |= 1;
            }
            return this.random;
        }
    }

    public File temporaryDirectory() {
        return this.temporaryDirectory;
    }

    private int BufferSize() {
        return this.BufferSize;
    }

    public String Newline() {
        return this.Newline;
    }

    public Charset utf8() {
        return this.utf8;
    }

    public URL classLocation(Class<?> cl) {
        CodeSource codeSource = cl.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)"No class location for ").append(cl).toString());
        }
        return codeSource.getLocation();
    }

    public File classLocationFile(Class<?> cl) {
        return this.toFile(this.classLocation(cl));
    }

    public <T> URL classLocation(Manifest<T> mf) {
        return this.classLocation(mf.erasure());
    }

    public <T> File classLocationFile(Manifest<T> mf) {
        return this.classLocationFile(mf.erasure());
    }

    /*
     * WARNING - void declaration
     */
    public File toFile(URL url) {
        void var2_2;
        File exceptionResult1 = null;
        try {
            exceptionResult1 = new File(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            exceptionResult1 = new File(url.getPath());
        }
        return var2_2;
    }

    public File asFile(URL url) {
        block4: {
            File file;
            block3: {
                String string;
                block2: {
                    String string2 = string = url.getProtocol();
                    String string3 = "file";
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                    file = this.toFile(url);
                    break block3;
                }
                String string4 = string;
                String string5 = "jar";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                String path = url.getPath();
                int end = path.indexOf(33);
                file = new File(new URI(end == -1 ? path : path.substring(0, end)));
            }
            return file;
        }
        throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Invalid protocol ").append((Object)url.getProtocol()).toString());
    }

    public void assertDirectory(File file$1) {
        Predef$.MODULE$.assert(file$1.isDirectory(), (Function0)new anonfun.assertDirectory.1(file$1));
    }

    public void assertDirectories(Seq<File> file) {
        file.foreach((Function1)new anonfun.assertDirectories.1());
    }

    public Tuple2<String, String> split(String name) {
        int lastDot = name.lastIndexOf(46);
        return lastDot >= 0 ? new Tuple2((Object)name.substring(0, lastDot), (Object)name.substring(lastDot + 1)) : new Tuple2((Object)name, (Object)"");
    }

    public void touch(Traversable<File> files) {
        files.foreach((Function1)new anonfun.touch.1());
    }

    public void touch(File file$2) {
        this.createDirectory(file$2.getParentFile());
        boolean created = BoxesRunTime.unboxToBoolean((Object)ErrorHandling$.MODULE$.translate((Function0)new anonfun.2(file$2), (Function0)new anonfun.1(file$2)));
        if (created || file$2.isDirectory() || file$2.setLastModified(System.currentTimeMillis())) {
            return;
        }
        throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Could not update last modified time for file ").append((Object)file$2).toString());
    }

    public void createDirectories(Traversable<File> dirs) {
        dirs.foreach((Function1)new anonfun.createDirectories.1());
    }

    public void createDirectory(File dir$1) {
        if (dir$1.isDirectory() || dir$1.mkdirs()) {
            return;
        }
        if (dir$1.exists()) {
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)this.failBase$1(dir$1)).append((Object)": file exists and is not a directory.").toString());
        }
        throw Predef$.MODULE$.error(this.failBase$1(dir$1));
    }

    public void gzip(File in, File out$1) {
        File file = in;
        File file2 = out$1;
        Predef$.MODULE$.require(file != null ? !((Object)file).equals(file2) : file2 != null, (Function0)new anonfun.gzip.1());
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, new anonfun.gzip.2(out$1));
    }

    public void gzip(InputStream input$1, OutputStream output) {
        Using$.MODULE$.gzipOutputStream().apply(output, new anonfun.gzip.3(input$1));
    }

    public void gunzip(File in, File out$4) {
        File file = in;
        File file2 = out$4;
        Predef$.MODULE$.require(file != null ? !((Object)file).equals(file2) : file2 != null, (Function0)new anonfun.gunzip.1());
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, new anonfun.gunzip.2(out$4));
    }

    public void gunzip(InputStream input, OutputStream output$1) {
        Using$.MODULE$.gzipInputStream().apply(input, new anonfun.gunzip.3(output$1));
    }

    public scala.collection.immutable.Set<File> unzip(File from, File toDirectory$1, NameFilter filter$1) {
        return (scala.collection.immutable.Set)((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, new anonfun.unzip.1(toDirectory$1, filter$1));
    }

    public scala.collection.immutable.Set<File> unzipURL(URL from, File toDirectory$3, NameFilter filter$3) {
        return (scala.collection.immutable.Set)Using$.MODULE$.urlInputStream().apply(from, new anonfun.unzipURL.1(toDirectory$3, filter$3));
    }

    public scala.collection.immutable.Set<File> unzipStream(InputStream from, File toDirectory$2, NameFilter filter$2) {
        this.createDirectory(toDirectory$2);
        return (scala.collection.immutable.Set)Using$.MODULE$.zipInputStream().apply(from, new anonfun.unzipStream.1(toDirectory$2, filter$2));
    }

    public final scala.collection.immutable.Set sbt$IO$$extract(ZipInputStream from$1, File toDirectory$4, NameFilter filter$4) {
        HashSet set$1 = new HashSet();
        this.next$1(from$1, toDirectory$4, filter$4, set$1);
        return (scala.collection.immutable.Set)((Addable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[0]))).$plus$plus((TraversableOnce)set$1);
    }

    public void download(URL url, File to$1) {
        Using$.MODULE$.urlInputStream().apply(url, new anonfun.download.1(to$1));
    }

    public void transfer(File in, File out$3) {
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, new anonfun.transfer.1(out$3));
    }

    public void transfer(File in, OutputStream out$2) {
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, new anonfun.transfer.2(out$2));
    }

    public void transfer(InputStream in$1, File to) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(to, new anonfun.transfer.3(in$1));
    }

    public void transfer(InputStream in, OutputStream out) {
        this.transferImpl(in, out, false);
    }

    public void transferAndClose(InputStream in, OutputStream out) {
        this.transferImpl(in, out, true);
    }

    private void transferImpl(InputStream in$2, OutputStream out$5, boolean close) {
        try {
            byte[] buffer$1 = new byte[this.BufferSize()];
            this.read$1(in$2, out$5, buffer$1);
            return;
        }
        finally {
            if (close) {
                in$2.close();
            }
        }
    }

    public <T> T withTemporaryDirectory(Function1<File, T> action) {
        File dir = this.createTemporaryDirectory();
        Object exceptionResult2 = null;
        try {
            exceptionResult2 = action.apply((Object)dir);
            return (T)exceptionResult2;
        }
        finally {
            this.delete(dir);
        }
    }

    public File createTemporaryDirectory() {
        return this.create$1(0);
    }

    public <T> T withTemporaryFile(String prefix, String postfix, Function1<File, T> action) {
        File file = File.createTempFile(prefix, postfix);
        Object exceptionResult3 = null;
        try {
            exceptionResult3 = action.apply((Object)file);
            return (T)exceptionResult3;
        }
        finally {
            file.delete();
        }
    }

    public Iterable<File> jars(File dir) {
        return Predef$.MODULE$.wrapRefArray((Object[])this.listFiles(dir, GlobFilter$.MODULE$.apply("*.jar")));
    }

    public void deleteIfEmpty(Set<File> dirs$1) {
        HashMap isEmpty$1 = new HashMap();
        dirs$1.foreach((Function1)new anonfun.deleteIfEmpty.1(dirs$1, isEmpty$1));
        ((HashMap)isEmpty$1.filter((Function1)new anonfun.deleteIfEmpty.2())).foreach((Function1)new anonfun.deleteIfEmpty.3());
    }

    public void delete(Iterable<File> files) {
        files.foreach((Function1)new anonfun.delete.1());
    }

    public void delete(File file$3) {
        ErrorHandling$.MODULE$.translate((Function0)new anonfun.delete.2(file$3), (Function0)new anonfun.delete.3(file$3));
    }

    public File[] listFiles(FileFilter filter2, File dir) {
        return this.wrapNull(dir.listFiles(filter2));
    }

    public File[] listFiles(File dir, FileFilter filter2) {
        return this.wrapNull(dir.listFiles(filter2));
    }

    public File[] listFiles(File dir) {
        return this.wrapNull(dir.listFiles());
    }

    public File[] wrapNull(File[] a) {
        return a == null ? new File[]{} : a;
    }

    public void jar(Traversable<Tuple2<File, String>> sources, File outputJar, java.util.jar.Manifest manifest) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputJar, (Option<java.util.jar.Manifest>)new Some((Object)manifest));
    }

    public void zip(Traversable<Tuple2<File, String>> sources, File outputZip) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputZip, (Option<java.util.jar.Manifest>)None$.MODULE$);
    }

    private void archive(Seq<Tuple2<File, String>> sources$1, File outputFile, Option<java.util.jar.Manifest> manifest$1) {
        if (outputFile.isDirectory()) {
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Specified output file ").append((Object)outputFile).append((Object)" is a directory.").toString());
        }
        File outputDir = outputFile.getParentFile();
        this.createDirectory(outputDir);
        this.withZipOutput(outputFile, manifest$1, (Function1<ZipOutputStream, Object>)new anonfun.archive.1(sources$1, manifest$1));
    }

    public final void sbt$IO$$writeZip(Seq sources, ZipOutputStream output$2, Function1 createEntry$1) {
        Seq files = (Seq)sources.flatMap((Function1)new anonfun.5(), Seq$.MODULE$.canBuildFrom());
        long now$1 = System.currentTimeMillis();
        long emptyCRC$1 = new CRC32().getValue();
        this.allDirectoryPaths((Iterable<Tuple2<File, String>>)files).foreach((Function1)new anonfun$sbt$IO$$writeZip$1(output$2, createEntry$1, now$1, emptyCRC$1));
        files.foreach((Function1)new anonfun$sbt$IO$$writeZip$2(output$2, createEntry$1));
    }

    private List<String> relativeComponents(String path) {
        return (List)Predef$.MODULE$.refArrayOps((Object[])path.split("/")).toList().dropRight(1);
    }

    private List<String> directories(List<String> path) {
        return (List)path.foldLeft((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""})), (Function2)new anonfun.directories.1());
    }

    public final List sbt$IO$$directoryPaths(String path) {
        return (List)this.directories(this.relativeComponents(path)).filter((Function1)new anonfun$sbt$IO$$directoryPaths$1());
    }

    private TreeSet<String> allDirectoryPaths(Iterable<Tuple2<File, String>> files) {
        return (TreeSet)TreeSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]), (Ordering)Ordering$String$.MODULE$).$plus$plus((TraversableOnce)files.flatMap((Function1)new anonfun.allDirectoryPaths.1(), Iterable$.MODULE$.canBuildFrom()));
    }

    private String normalizeDirName(String name) {
        String norm1 = this.sbt$IO$$normalizeName(name);
        return norm1.endsWith("/") ? norm1 : new StringBuilder().append((Object)norm1).append((Object)"/").toString();
    }

    public final String sbt$IO$$normalizeName(String name) {
        char sep = File.separatorChar;
        return sep == '/' ? name : name.replace(sep, '/');
    }

    private void withZipOutput(File file, Option<java.util.jar.Manifest> manifest$2, Function1<ZipOutputStream, Object> f$2) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(false))).apply(file, new anonfun.withZipOutput.1(manifest$2, f$2));
    }

    public Option<String> relativize(File base, File file) {
        String pathString$1 = file.getAbsolutePath();
        return this.baseFileString(base).flatMap((Function1)new anonfun.relativize.1(pathString$1));
    }

    private Option<String> baseFileString(File baseFile) {
        None$ none$;
        if (baseFile.isDirectory()) {
            String cp = baseFile.getAbsolutePath();
            Predef$.MODULE$.assert(cp.length() > 0);
            String normalized = cp.charAt(cp.length() - 1) == File.separatorChar ? cp : new StringBuilder().append((Object)cp).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).toString();
            none$ = new Some((Object)normalized);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public scala.collection.immutable.Set<File> copy(Traversable<Tuple2<File, File>> sources, boolean overwrite$1, boolean preserveLastModified$1) {
        return ((TraversableOnce)sources.map(Function$.MODULE$.tupled((Function2)new anonfun.copy.1(overwrite$1, preserveLastModified$1)), Traversable$.MODULE$.canBuildFrom())).toSet();
    }

    public final File sbt$IO$$copyImpl(boolean overwrite, boolean preserveLastModified, File from, File to) {
        if (overwrite || !to.exists() || from.lastModified() > to.lastModified()) {
            if (from.isDirectory()) {
                this.createDirectory(to);
            } else {
                this.createDirectory(to.getParentFile());
                this.copyFile(from, to, preserveLastModified);
            }
        }
        return to;
    }

    public void copyDirectory(File source, File target, boolean overwrite, boolean preserveLastModified) {
        PathFinder qual$1 = Path$.MODULE$.fromFile(source).$times$times$times();
        Function1<File, Option<File>> x$14 = Path$.MODULE$.rebase(source, target);
        boolean x$15 = qual$1.x$default$2();
        this.copy((Traversable<Tuple2<File, File>>)qual$1.x(x$14, x$15), overwrite, preserveLastModified);
    }

    public void copyFile(File sourceFile$1, File targetFile$1, boolean preserveLastModified) {
        Predef$.MODULE$.require(sourceFile$1.exists(), (Function0)new anonfun.copyFile.1(sourceFile$1));
        Predef$.MODULE$.require(!sourceFile$1.isDirectory(), (Function0)new anonfun.copyFile.2(sourceFile$1));
        ((Using)((Object)Using$.MODULE$.fileInputChannel())).apply(sourceFile$1, new anonfun.copyFile.3(sourceFile$1, targetFile$1));
        if (preserveLastModified) {
            this.copyLastModified(sourceFile$1, targetFile$1);
        }
    }

    public boolean copyLastModified(File sourceFile, File targetFile) {
        return targetFile.setLastModified(sourceFile.lastModified());
    }

    public Charset defaultCharset() {
        return this.utf8();
    }

    public void write(File file, String content$1, Charset charset, boolean append) {
        this.writer(file, content$1, charset, append, (Function1)new anonfun.write.1(content$1));
    }

    public <T> T writer(File file, String content, Charset charset, boolean append, Function1<BufferedWriter, T> f) {
        if (charset.newEncoder().canEncode(content)) {
            return ((Using)((Object)Using$.MODULE$.fileWriter(charset, append))).apply(file, f);
        }
        throw Predef$.MODULE$.error(new StringBuilder().append((Object)"String cannot be encoded by charset ").append((Object)charset.name()).toString());
    }

    public <T> T reader(File file, Charset charset, Function1<BufferedReader, T> f) {
        return ((Using)((Object)Using$.MODULE$.fileReader(charset))).apply(file, f);
    }

    public String read(File file, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)file.length());
        this.transfer(file, (OutputStream)out);
        return out.toString(charset.name());
    }

    public String readStream(InputStream in, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transfer(in, (OutputStream)out);
        return out.toString(charset.name());
    }

    public byte[] readBytes(File file) {
        return (byte[])((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, new anonfun.readBytes.1());
    }

    public byte[] readBytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transfer(in, (OutputStream)out);
        return out.toByteArray();
    }

    public void append(File file, String content, Charset charset) {
        this.write(file, content, charset, true);
    }

    public void append(File file, byte[] bytes) {
        this.writeBytes(file, bytes, true);
    }

    public void write(File file, byte[] bytes) {
        this.writeBytes(file, bytes, false);
    }

    private void writeBytes(File file, byte[] bytes$1, boolean append) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(append))).apply(file, new anonfun.writeBytes.1(bytes$1));
    }

    public List<String> readLinesURL(URL url, Charset charset) {
        return (List)Using$.MODULE$.urlReader(charset).apply(url, new anonfun.readLinesURL.1());
    }

    public List<String> readLines(File file, Charset charset) {
        return (List)((Using)((Object)Using$.MODULE$.fileReader(charset))).apply(file, new anonfun.readLines.1());
    }

    public List<String> readLines(BufferedReader in) {
        return ((List)this.foldLines(in, (Object)Nil$.MODULE$, (Function2)new anonfun.readLines.2())).reverse();
    }

    public void foreachLine(BufferedReader in, Function1<String, Object> f$4) {
        this.foldLines(in, (Object)BoxedUnit.UNIT, (Function2)new anonfun.foreachLine.1(f$4));
    }

    public <T> T foldLines(BufferedReader in$4, T init, Function2<T, String, T> f$3) {
        return (T)this.readLine$1(init, in$4, f$3);
    }

    public void writeLines(File file, Seq<String> lines$1, Charset charset, boolean append) {
        this.writer(file, (String)lines$1.headOption().getOrElse((Function0)new anonfun.writeLines.1()), charset, append, (Function1)new anonfun.writeLines.2(lines$1));
    }

    public void writeLines(PrintWriter writer$1, Seq<String> lines) {
        lines.foreach((Function1)new anonfun.writeLines.3(writer$1));
    }

    public void write(Properties properties$1, String label$1, File to) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(to, new anonfun.write.2(properties$1, label$1));
    }

    public void load(Properties properties$2, File from) {
        if (from.exists()) {
            ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, new anonfun.load.1(properties$2));
        }
    }

    private Pattern PathSeparatorPattern() {
        return this.PathSeparatorPattern;
    }

    public String[] pathSplit(String s) {
        return this.PathSeparatorPattern().split(s);
    }

    public <T> T stash(scala.collection.immutable.Set<File> files$1, Function0<T> f$5) {
        return this.withTemporaryDirectory((Function1<File, T>)new anonfun.stash.1(files$1, f$5));
    }

    public final Tuple2[] sbt$IO$$stashLocations(File dir$2, File[] files) {
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])files).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(File.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{Manifest$.MODULE$.Int()}))))).filter((Function1)new anonfun$sbt$IO$$stashLocations$1())).map((Function1)new anonfun$sbt$IO$$stashLocations$2(dir$2), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(File.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(File.class)}))));
    }

    public void move(Traversable<Tuple2<File, File>> files) {
        files.foreach(Function$.MODULE$.tupled((Function2)new anonfun.move.1()));
    }

    public void move(File a, File b) {
        if (b.exists()) {
            this.delete(b);
        }
        this.createDirectory(b.getParentFile());
        if (!a.renameTo(b)) {
            this.copyFile(a, b, true);
            this.delete(a);
        }
    }

    public <T> T gzipFileOut(File file, Function1<OutputStream, T> f$6) {
        return (T)((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(file, new anonfun.gzipFileOut.1(f$6));
    }

    public <T> T gzipFileIn(File file, Function1<InputStream, T> f$7) {
        return (T)((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, new anonfun.gzipFileIn.1(f$7));
    }

    public URI directoryURI(File dir) {
        this.assertAbsolute(dir);
        return this.directoryURI(dir.toURI().normalize());
    }

    /*
     * Unable to fully structure code
     */
    public URI directoryURI(URI uri) {
        this.assertAbsolute(uri);
        str = uri.toASCIIString();
        if (str.endsWith("/")) ** GOTO lbl-1000
        v0 = uri.getScheme();
        var4_3 = "file";
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
            v1 = new StringBuilder().append((Object)str).append((Object)"/").toString();
        } else lbl-1000:
        // 2 sources

        {
            v1 = str;
        }
        dirStr = v1;
        return new URI(dirStr).normalize();
    }

    public URI toURI(File f) {
        return f.isAbsolute() ? f.toURI() : new URI(f.getPath());
    }

    /*
     * WARNING - void declaration
     */
    public File resolve(File base, File f) {
        void var3_3;
        this.assertAbsolute(base);
        File fabs = f.isAbsolute() ? f : new File(this.directoryURI(new File(base, f.getPath())));
        this.assertAbsolute(fabs);
        return var3_3;
    }

    public void assertAbsolute(File f$8) {
        Predef$.MODULE$.assert(f$8.isAbsolute(), (Function0)new anonfun.assertAbsolute.1(f$8));
    }

    public void assertAbsolute(URI uri$1) {
        Predef$.MODULE$.assert(uri$1.isAbsolute(), (Function0)new anonfun.assertAbsolute.2(uri$1));
    }

    private final String failBase$1(File file) {
        return new StringBuilder().append((Object)"Could not create directory ").append((Object)file).toString();
    }

    private final void next$1(ZipInputStream zipInputStream2, File file, NameFilter nameFilter, HashSet hashSet) {
        ZipEntry entry;
        while ((entry = zipInputStream2.getNextEntry()) != null) {
            Object object;
            String name$1 = entry.getName();
            if (nameFilter.accept(name$1)) {
                File target$1 = new File(file, name$1);
                if (entry.isDirectory()) {
                    this.createDirectory(target$1);
                    object = BoxedUnit.UNIT;
                } else {
                    hashSet.$plus$eq((Object)target$1);
                    object = ErrorHandling$.MODULE$.translate((Function0)new anonfun.next.1.2(name$1, target$1), (Function0)new anonfun.next.1.1(zipInputStream2, target$1));
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            zipInputStream2.closeEntry();
        }
        return;
    }

    private final void read$1(InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        int byteCount;
        while ((byteCount = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, byteCount);
        }
    }

    private final File create$1(int tries) {
        if (tries > this.MaximumTries()) {
            throw Predef$.MODULE$.error("Could not create temporary directory.");
        }
        String randomName = new StringBuilder().append((Object)"sbt_").append((Object)Integer.toHexString(this.random().nextInt())).toString();
        File f = new File(this.temporaryDirectory(), randomName);
        File exceptionResult4 = null;
        try {
            this.createDirectory(f);
            exceptionResult4 = f;
        }
        catch (Exception exception) {
            exceptionResult4 = this.create$1(tries + 1);
        }
        return exceptionResult4;
    }

    public final boolean visit$1(File f$1, Set set, HashMap hashMap) {
        return BoxesRunTime.unboxToBoolean((Object)hashMap.getOrElseUpdate((Object)f$1, (Function0)new anonfun.visit.1.1(set, hashMap, f$1)));
    }

    public final void addDirectoryEntry$1(String name, ZipOutputStream zipOutputStream2, Function1 function1, long l, long l2) {
        zipOutputStream2.putNextEntry(this.makeDirectoryEntry$1(name, function1, l, l2));
        zipOutputStream2.closeEntry();
    }

    private final ZipEntry makeDirectoryEntry$1(String name, Function1 function1, long l, long l2) {
        ZipEntry e = (ZipEntry)function1.apply((Object)name);
        e.setTime(l);
        e.setSize(0L);
        e.setMethod(0);
        e.setCrc(l2);
        return e;
    }

    private final ZipEntry makeFileEntry$1(File file, String name, Function1 function1) {
        ZipEntry e = (ZipEntry)function1.apply((Object)name);
        e.setTime(file.lastModified());
        return e;
    }

    public final void addFileEntry$1(File file, String name, ZipOutputStream zipOutputStream2, Function1 function1) {
        zipOutputStream2.putNextEntry(this.makeFileEntry$1(file, name, function1));
        this.transfer(file, (OutputStream)zipOutputStream2);
        zipOutputStream2.closeEntry();
    }

    private final Object readLine$1(Object accum, BufferedReader bufferedReader, Function2 function2) {
        String line;
        while ((line = bufferedReader.readLine()) != null) {
            accum = function2.apply(accum, (Object)line);
        }
        return accum;
    }

    private IO$() {
        MODULE$ = this;
        this.MaximumTries = 10;
        this.temporaryDirectory = new File(System.getProperty("java.io.tmpdir"));
        this.BufferSize = 8192;
        this.Newline = System.getProperty("line.separator");
        this.utf8 = Charset.forName("UTF-8");
        this.PathSeparatorPattern = Pattern.compile(File.pathSeparator);
    }
}

