/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.net.URL;
import sbt.Alternative;
import sbt.Alternatives$class;
import sbt.BaseDirectory;
import sbt.FilePath;
import sbt.IO$;
import sbt.Mapper;
import sbt.Mapper$class;
import sbt.Path;
import sbt.Path$;
import sbt.PathExtra;
import sbt.PathExtra$class;
import sbt.PathFinder;
import sbt.ProjectDirectory;
import sbt.RelativePath;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$DummyImplicit$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Path$
implements PathExtra,
ScalaObject {
    public static final Path$ MODULE$;
    private final char sep;
    private final Function1 basic;
    private final Function1 flat;

    static {
        new Path$();
    }

    @Override
    public Path fileToPath(File file) {
        return PathExtra$class.fileToPath(this, file);
    }

    @Override
    public File pathToFile(Path path) {
        return PathExtra$class.pathToFile(this, path);
    }

    @Override
    public <CC extends TraversableLike<Object, CC>> CC pathsToFiles(CC cc, CanBuildFrom<CC, File, CC> cb) {
        return (CC)PathExtra$class.pathsToFiles(this, cc, cb);
    }

    @Override
    public <CC extends TraversableLike<Object, CC>> CC filesToPaths(CC cc, CanBuildFrom<CC, Path, CC> cb) {
        return (CC)PathExtra$class.filesToPaths(this, cc, cb);
    }

    @Override
    public PathFinder filesToFinder(Traversable<File> cc) {
        return PathExtra$class.filesToFinder(this, cc);
    }

    @Override
    public PathFinder pathsToFinder(Traversable<Path> cc) {
        return PathExtra$class.pathsToFinder(this, cc);
    }

    public Function1 basic() {
        return this.basic;
    }

    public Function1 flat() {
        return this.flat;
    }

    @Override
    public void sbt$Mapper$_setter_$basic_$eq(Function1 function1) {
        this.basic = function1;
    }

    @Override
    public void sbt$Mapper$_setter_$flat_$eq(Function1 function1) {
        this.flat = function1;
    }

    @Override
    public Function1<File, Option<String>> relativeTo(File base) {
        return Mapper$class.relativeTo(this, base);
    }

    @Override
    public Function1<File, Option<String>> relativeTo(Iterable<File> bases, Function1<File, Option<String>> zero) {
        return Mapper$class.relativeTo(this, bases, zero);
    }

    @Override
    public Function1<File, Option<String>> rebase(File oldBase, String newBase0) {
        return Mapper$class.rebase((Mapper)this, oldBase, newBase0);
    }

    @Override
    public Function1<Object, Nothing$> fail() {
        return Mapper$class.fail(this);
    }

    @Override
    public Function1<File, Option<String>> flatRebase(String newBase0) {
        return Mapper$class.flatRebase(this, newBase0);
    }

    @Override
    public <A, B> Function1<A, Some<B>> total(Function1<A, B> f) {
        return Mapper$class.total(this, f);
    }

    @Override
    public Function1<Object, Option<Nothing$>> transparent() {
        return Mapper$class.transparent(this);
    }

    @Override
    public String normalizeBase(String base) {
        return Mapper$class.normalizeBase(this, base);
    }

    @Override
    public Function1<File, Option<File>> abs() {
        return Mapper$class.abs(this);
    }

    @Override
    public Function1<File, Option<File>> resolve(File newDirectory) {
        return Mapper$class.resolve(this, newDirectory);
    }

    @Override
    public Function1<File, Option<File>> rebase(Iterable<File> oldBases, File newBase, Function1<File, Option<File>> zero) {
        return Mapper$class.rebase(this, oldBases, newBase, zero);
    }

    @Override
    public Function1<File, Option<File>> rebase(File oldBase, File newBase) {
        return Mapper$class.rebase((Mapper)this, oldBase, newBase);
    }

    @Override
    public Function1<File, Option<File>> flat(File newDirectory) {
        return Mapper$class.flat(this, newDirectory);
    }

    @Override
    public /* synthetic */ Function1 rebase$default$3() {
        return Mapper$class.rebase$default$3(this);
    }

    @Override
    public /* synthetic */ Function1 relativeTo$default$2() {
        return Mapper$class.relativeTo$default$2(this);
    }

    @Override
    public <A, B> Alternative<A, B> alternative(Function1<A, Option<B>> f) {
        return Alternatives$class.alternative(this, f);
    }

    @Override
    public final <A, B> Function1<A, Option<B>> alternatives(Seq<Function1<A, Option<B>>> alts) {
        return Alternatives$class.alternatives(this, alts);
    }

    public Path fileProperty(String name) {
        return this.fromFile(System.getProperty(name));
    }

    public Path userHome() {
        return this.fileProperty("user.home");
    }

    public File absolute(File file) {
        return new File(file.toURI().normalize()).getAbsoluteFile();
    }

    public String makeString(Iterable<Path> paths) {
        return this.makeString(paths, File.pathSeparator);
    }

    public String makeString(Iterable<Path> paths, String sep) {
        return ((TraversableOnce)paths.map((Function1)new anonfun.makeString.1(), Iterable$.MODULE$.canBuildFrom())).mkString(sep);
    }

    public String makeString(Seq<File> paths) {
        return this.makeString(paths, File.pathSeparator);
    }

    public String makeString(Seq<File> paths, String sep) {
        return ((TraversableOnce)paths.map((Function1)new anonfun.makeString.2(), Seq$.MODULE$.canBuildFrom())).mkString(sep);
    }

    public String makeRelativeString(Iterable<Path> paths) {
        return ((TraversableOnce)paths.map((Function1)new anonfun.makeRelativeString.1(), Iterable$.MODULE$.canBuildFrom())).mkString(File.pathSeparator);
    }

    public Iterable<Path> splitString(Path projectPath$1, String value) {
        return (Iterable)Predef$.MODULE$.refArrayOps((Object[])IO$.MODULE$.pathSplit(value)).withFilter((Function1)new anonfun.splitString.1()).map((Function1)new anonfun.splitString.2(projectPath$1), Array$.MODULE$.fallbackCanBuildFrom(Predef$DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public PathFinder emptyPathFinder() {
        return new anon.1();
    }

    public PathFinder lazyPathFinder(Function0<Traversable<Path>> paths$1) {
        return new anon.2(paths$1);
    }

    public PathFinder finder(Function0<Traversable<File>> files$1) {
        return this.lazyPathFinder((Function0<Traversable<Path>>)new anonfun.finder.1(files$1));
    }

    public char sep() {
        return this.sep;
    }

    public String checkComponent(String c$1) {
        Predef$.MODULE$.require(c$1.length() > 0, (Function0)new anonfun.checkComponent.1());
        Predef$.MODULE$.require(c$1.indexOf(47) == -1, (Function0)new anonfun.checkComponent.2(c$1));
        Predef$.MODULE$.require(c$1.indexOf(92) == -1, (Function0)new anonfun.checkComponent.3(c$1));
        String string = c$1;
        String string2 = "..";
        Predef$.MODULE$.require(string != null ? !string.equals(string2) : string2 != null, (Function0)new anonfun.checkComponent.4());
        String string3 = c$1;
        String string4 = ".";
        Predef$.MODULE$.require(string3 != null ? !string3.equals(string4) : string4 != null, (Function0)new anonfun.checkComponent.5());
        return c$1;
    }

    public Path fromString(Path basePath, String value) {
        Path path;
        if (value.isEmpty()) {
            path = basePath;
        } else {
            File f = new File(value);
            if (f.isAbsolute()) {
                path = this.fromFile(f);
            } else {
                String[] components = value.split("[/\\\\]");
                Path path2 = basePath;
                path = (Path)Predef$.MODULE$.refArrayOps((Object[])components).$div$colon((Object)path2, (Function2)new anonfun.fromString.1());
            }
        }
        return path;
    }

    public Option<Path> baseAncestor(Path path) {
        Path path2;
        block7: {
            None$ none$;
            block6: {
                while (true) {
                    if ((path2 = path) instanceof ProjectDirectory) {
                        none$ = None$.MODULE$;
                        break block6;
                    }
                    if (path2 instanceof FilePath) {
                        none$ = None$.MODULE$;
                        break block6;
                    }
                    if (!(path2 instanceof RelativePath)) break;
                    path = ((RelativePath)path2).parentPath();
                }
                if (!(path2 instanceof BaseDirectory)) break block7;
                none$ = new Some((Object)((BaseDirectory)path2).path());
            }
            return none$;
        }
        throw new MatchError((Object)path2);
    }

    public Option<Path> relativize(Path basePath, Path path) {
        return this.relativize(basePath, path.asFile());
    }

    public Option<Path> relativize(Path basePath$1, File file$1) {
        return this.basePathString(basePath$1).flatMap((Function1)new anonfun.relativize.1(basePath$1, file$1));
    }

    public Option<Path> relativize(Path basePath, String basePathString, File file) {
        String pathString = file.getAbsolutePath();
        return pathString.startsWith(basePathString) ? new Some((Object)this.fromString(basePath, pathString.substring(basePathString.length()))) : None$.MODULE$;
    }

    public Option<File> relativizeFile(File baseFile, File file) {
        return this.relativize(baseFile, file).map((Function1)new anonfun.relativizeFile.1());
    }

    public Option<String> relativize(File baseFile, File file) {
        String pathString$1 = file.getAbsolutePath();
        return this.baseFileString(baseFile).flatMap((Function1)new anonfun.relativize.2(pathString$1));
    }

    public Option<String> basePathString(Path basePath) {
        return this.baseFileString(basePath.asFile());
    }

    private Option<String> baseFileString(File baseFile) {
        None$ none$;
        if (baseFile.isDirectory()) {
            String cp = baseFile.getAbsolutePath();
            Predef$.MODULE$.assert(cp.length() > 0);
            none$ = cp.charAt(cp.length() - 1) == File.separatorChar ? new Some((Object)cp) : new Some((Object)new StringBuilder().append((Object)cp).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).toString());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Path fromFile(String file) {
        return this.fromFile(new File(file));
    }

    public Path fromFile(File file) {
        return new FilePath(file);
    }

    public <Repr, That> That fromFiles(FilterMonadic<File, Repr> files, CanBuildFrom<Repr, Path, That> bf) {
        return (That)files.map((Function1)new anonfun.fromFiles.1(), bf);
    }

    public Set<File> getFiles(Traversable<Path> files) {
        return ((TraversableOnce)files.map((Function1)new anonfun.getFiles.1(), Traversable$.MODULE$.canBuildFrom())).toSet();
    }

    public URL[] getURLs(Traversable<Path> files) {
        return (URL[])((TraversableOnce)files.map((Function1)new anonfun.getURLs.1(), Traversable$.MODULE$.canBuildFrom())).toArray(ClassManifest$.MODULE$.classType(URL.class));
    }

    public URL[] toURLs(Seq<File> files) {
        return (URL[])((TraversableOnce)files.map((Function1)new anonfun.toURLs.1(), Seq$.MODULE$.canBuildFrom())).toArray(ClassManifest$.MODULE$.classType(URL.class));
    }

    private Path$() {
        MODULE$ = this;
        Alternatives$class.$init$(this);
        Mapper$class.$init$(this);
        PathExtra$class.$init$(this);
        this.sep = File.separatorChar;
    }
}

