/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.ActorRef;
import akka.actor.Scheduler;
import akka.actor.Scheduler$;
import akka.actor.SchedulerThreadFactory$;
import akka.util.Logger;
import akka.util.Logging;
import akka.util.Logging$class;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Scheduler$
implements Logging,
ScalaObject {
    public static final Scheduler$ MODULE$;
    private volatile ScheduledExecutorService service;
    private final transient Logger log;

    static {
        new Scheduler$();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void akka$util$Logging$_setter_$log_$eq(Logger logger) {
        this.log = logger;
    }

    private ScheduledExecutorService service() {
        return this.service;
    }

    private void service_$eq(ScheduledExecutorService scheduledExecutorService) {
        this.service = scheduledExecutorService;
    }

    public ScheduledFuture<Object> schedule(ActorRef receiver$2, Object message$2, long initialDelay, long delay, TimeUnit timeUnit) {
        this.log().slf4j().trace("Schedule scheduled event\n\tevent = [{}]\n\treceiver = [{}]\n\tinitialDelay = [{}]\n\tdelay = [{}]\n\ttimeUnit = [{}]", (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{message$2, receiver$2, BoxesRunTime.boxToLong((long)initialDelay), BoxesRunTime.boxToLong((long)delay), timeUnit}), (ClassManifest)Manifest$.MODULE$.Object()));
        ScheduledFuture<Object> exceptionResult1 = null;
        try {
            exceptionResult1 = this.service().scheduleAtFixedRate(new anon.1(receiver$2, message$2), initialDelay, delay, timeUnit);
            return exceptionResult1;
        }
        catch (Exception exception) {
            throw new Scheduler.SchedulerException(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(message$2).$plus(" could not be scheduled on ")).append((Object)receiver$2).toString(), exception);
        }
    }

    public ScheduledFuture<Object> schedule(Function0<Object> f$2, long initialDelay, long delay, TimeUnit timeUnit) {
        return this.schedule(new anon.2(f$2), initialDelay, delay, timeUnit);
    }

    public ScheduledFuture<Object> schedule(Runnable runnable, long initialDelay, long delay, TimeUnit timeUnit) {
        this.log().slf4j().trace("Schedule scheduled event\n\trunnable = [{}]\n\tinitialDelay = [{}]\n\tdelay = [{}]\n\ttimeUnit = [{}]", (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{runnable, BoxesRunTime.boxToLong((long)initialDelay), BoxesRunTime.boxToLong((long)delay), timeUnit}), (ClassManifest)Manifest$.MODULE$.Object()));
        ScheduledFuture<Object> exceptionResult2 = null;
        try {
            exceptionResult2 = this.service().scheduleAtFixedRate(runnable, initialDelay, delay, timeUnit);
            return exceptionResult2;
        }
        catch (Exception exception) {
            throw new Scheduler.SchedulerException("Failed to schedule a Runnable", exception);
        }
    }

    public ScheduledFuture<Object> scheduleOnce(ActorRef receiver$1, Object message$1, long delay, TimeUnit timeUnit) {
        this.log().slf4j().trace("Schedule one-time event\n\tevent = [{}]\n\treceiver = [{}]\n\tdelay = [{}]\n\ttimeUnit = [{}]", (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{message$1, receiver$1, BoxesRunTime.boxToLong((long)delay), timeUnit}), (ClassManifest)Manifest$.MODULE$.Object()));
        ScheduledFuture<Object> exceptionResult3 = null;
        try {
            exceptionResult3 = this.service().schedule(new anon.3(receiver$1, message$1), delay, timeUnit);
            return exceptionResult3;
        }
        catch (Exception exception) {
            throw new Scheduler.SchedulerException(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(message$1).$plus(" could not be scheduleOnce'd on ")).append((Object)receiver$1).toString(), exception);
        }
    }

    public ScheduledFuture<Object> scheduleOnce(Function0<Object> f$1, long delay, TimeUnit timeUnit) {
        return this.scheduleOnce(new anon.4(f$1), delay, timeUnit);
    }

    public ScheduledFuture<Object> scheduleOnce(Runnable runnable, long delay, TimeUnit timeUnit) {
        this.log().slf4j().trace("Schedule one-time event\n\trunnable = [{}]\n\tdelay = [{}]\n\ttimeUnit = [{}]", (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{runnable, BoxesRunTime.boxToLong((long)delay), timeUnit}), (ClassManifest)Manifest$.MODULE$.Object()));
        ScheduledFuture<Object> exceptionResult4 = null;
        try {
            exceptionResult4 = this.service().schedule(runnable, delay, timeUnit);
            return exceptionResult4;
        }
        catch (Exception exception) {
            throw new Scheduler.SchedulerException("Failed to scheduleOnce a Runnable", exception);
        }
    }

    public void shutdown() {
        Scheduler$ scheduler$ = this;
        synchronized (scheduler$) {
            this.log().slf4j().info("Shutting down Scheduler");
            this.service().shutdown();
            return;
        }
    }

    public void restart() {
        Scheduler$ scheduler$ = this;
        synchronized (scheduler$) {
            this.log().slf4j().info("Restarting Scheduler");
            this.shutdown();
            this.service_$eq(Executors.newSingleThreadScheduledExecutor(SchedulerThreadFactory$.MODULE$));
            return;
        }
    }

    private Scheduler$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.service = Executors.newSingleThreadScheduledExecutor(SchedulerThreadFactory$.MODULE$);
        this.log().slf4j().info("Starting up Scheduler");
    }
}

