/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scalagen;

import java.io.File;
import java.util.HashMap;
import play.Play;
import play.modules.scalagen.TypeRegistry;
import play.modules.scalagen.jpa.ControllerGenerator;
import play.modules.scalagen.jpa.ModelGenerator;
import play.modules.scalagen.jpa.SeleniumTestGenerator;
import play.modules.scalagen.jpa.UtilsGenerator;
import play.modules.scalagen.jpa.ViewGenerator;

public class Generator {
    public static void main(String[] args) {
        File root = new File(System.getProperty("application.path"));
        Play.init((File)root, (String)System.getProperty("play.id", ""));
        if (args.length == 0) {
            Generator.printHelp();
            return;
        }
        String command = args[0];
        String entityName = args[1];
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (String arg : args) {
            if (arg.indexOf(":") == -1) continue;
            String[] entry = arg.split(":");
            String name = entry[0].trim();
            String type = entry[1].trim();
            if (TypeRegistry.isInternalDataType(type) && !TypeRegistry.isRegistered(type.toLowerCase())) {
                TypeRegistry.register(type, "null", "null");
            }
            attributes.put(name, type);
        }
        if (command.equals("--model") || command.equals("--model-jpa") || command.equals("--m")) {
            UtilsGenerator.generate();
            ModelGenerator.generate(entityName, attributes, "jpa");
        }
        if (command.equals("--scaffold") || command.equals("--scaffold-jpa") || command.equals("--s")) {
            UtilsGenerator.generate();
            ModelGenerator.generate(entityName, attributes, "jpa");
            ViewGenerator.generate(entityName, attributes);
            SeleniumTestGenerator.generate(entityName, attributes);
            ControllerGenerator.generate(entityName, attributes, "jpa");
        }
        if (command.equals("--scaffold-siena") || command.equals("--ss")) {
            UtilsGenerator.generate();
            ModelGenerator.generate(entityName, attributes, "siena");
            ViewGenerator.generate(entityName, attributes);
            SeleniumTestGenerator.generate(entityName, attributes);
            ControllerGenerator.generate(entityName, attributes, "siena");
        }
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("Help:");
        System.out.println();
        System.out.println("This module can be used to generate Scala code. It can generate JPA based models, CRUD and associated test cases.");
        System.out.println();
        System.out.println("Options:");
        System.out.println("--------");
        System.out.println("--scaffold-jpa [entity name] [attribute1:type1]*     Generates the JPA based model and associated CRUD code.");
        System.out.println("--model-jpa [entity name] [attribute1:type1]*         Generates the JPA based model. ");
        System.out.println();
        System.out.println("Note: --scaffold and --model are shortcuts to generate JPA");
        System.out.println("Example: play scalagen:generate --scaffold User name:String login:String role:Role");
        System.out.println("For the lazy, the following does the same: play scalagen:g --s User name:String login:String role:Role");
    }
}

