/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scalagen.jpa;

import java.util.Map;
import play.modules.scalagen.TypeRegistry;
import play.modules.scalagen.util.TemplatesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerGenerator {
    private static final String PARAM_TEMPLATE = "params.get(\"${attributeName}\")";
    private static final String ATTRIBUTE_TEMPLATE = "${EntityNameVar}.${attributeName} = if (!isEmptyString(${param})) ${param}.to${varTypeName} else ${defaultValue}";
    private static final String ATTRIBUTE_RELATIONSHIP_TEMPLATE = "${EntityNameVar}.${attributeName} = if (!isEmptyString(${param})) ${modelName}.findById(${param}.toLong).getOrElse(null) else null";

    public static void generate(String entityName, Map<String, String> attributes, String scheme) {
        String template = TemplatesHelper.getTemplate(scheme + "/controller");
        String entityVarName = Character.toLowerCase(entityName.charAt(0)) + entityName.substring(1);
        template = template.replace("${EntityName}", entityName);
        template = template.replace("${EntityNameVar}", entityVarName);
        template = ControllerGenerator.buildAttributes(template, entityVarName, attributes);
        TemplatesHelper.flush("app", "controllers", entityName + "sController.scala", template);
        ControllerGenerator.buildRoutes(entityName, entityVarName);
    }

    private static void buildRoutes(String entityName, String entityVarName) {
        String template = TemplatesHelper.getTemplate("jpa/routes");
        template = template.replace("${EntityName}", entityName);
        template = template.replace("${EntityNameVar}", entityVarName);
        System.out.println();
        System.out.println("Please add the following entries to the routes file");
        System.out.println(template);
        System.out.println();
    }

    private static String buildAttributes(String template, String entityVarName, Map<String, String> attributes) {
        StringBuilder varDefinitions = new StringBuilder();
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            String varName = attribute.getKey();
            String varType = attribute.getValue();
            if (varName.toLowerCase().equals("id")) continue;
            varType = TypeRegistry.getTypeName(varType);
            String defaultValue = TypeRegistry.getDefaultValue(varType);
            String var = null;
            String param = PARAM_TEMPLATE.replace("${attributeName}", varName);
            if (!TypeRegistry.isRegistered(varType)) {
                var = ATTRIBUTE_RELATIONSHIP_TEMPLATE.replace("${EntityNameVar}", entityVarName);
                var = var.replace("${modelName}", varType);
            } else if (TypeRegistry.isInternalDataType(varType)) {
                var = ATTRIBUTE_TEMPLATE;
                var = var.replace("${EntityNameVar}", entityVarName);
                var = var.replace("${varTypeName}", varType);
            }
            if (null == var) continue;
            var = var.replace("${attributeName}", varName);
            var = var.replace("${param}", param);
            var = var.replace("${defaultValue}", defaultValue);
            varDefinitions.append(var).append("\n        ");
        }
        template = template.replace("${formData}", varDefinitions.toString());
        return template;
    }
}

