/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scalagen.jpa;

import java.util.Map;
import org.jvnet.inflector.Noun;
import play.modules.scalagen.TypeRegistry;
import play.modules.scalagen.util.TemplatesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelGenerator {
    private static final String ATTRIBUTE_TEMPLATE = "var ${attributeName}: ${attributeType} = ${attributeDefaultValue}";
    private static final String DEPENDENCY_TEMPLATE = "var ${attributeName} = null";

    public static void generate(String entityName, Map<String, String> attributes, String scheme) {
        String template = TemplatesHelper.getTemplate(scheme + "/model");
        String entityVarName = Character.toLowerCase(entityName.charAt(0)) + entityName.substring(1);
        template = template.replace("${EntityName}", entityName);
        template = template.replace("${EntityNameVar}", entityVarName);
        template = template.replace("${TableName}", ModelGenerator.getTableName(entityVarName));
        template = ModelGenerator.buildAttributes(template, entityVarName, attributes, scheme);
        TemplatesHelper.flush("app", "models", entityName + ".scala", template);
        ModelGenerator.generateTests(entityName, entityVarName, attributes, scheme);
        ModelGenerator.generateYML(entityName, entityVarName, attributes);
        if ("siena".equals(scheme)) {
            ModelGenerator.generateQueryTrait();
        }
    }

    private static void generateQueryTrait() {
        if (!TemplatesHelper.exists("app", "siena", "QueryOn.scala")) {
            String template = TemplatesHelper.getTemplate("siena/QueryOn");
            TemplatesHelper.flush("app", "siena", "QueryOn.scala", template);
        } else {
            System.out.println("* app/siena/QueryOn.scala already exists. Skipping.");
        }
    }

    private static String getTableName(String entityVarName) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < entityVarName.length(); ++i) {
            char c = entityVarName.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append("_").append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        String name = sb.toString();
        String[] parts = name.split("_");
        String last = parts[parts.length - 1];
        if (!last.endsWith("s")) {
            parts[parts.length - 1] = Noun.pluralOf((String)last);
        }
        name = "";
        for (int i = 0; i < parts.length; ++i) {
            if (!name.trim().equals("")) {
                name = name + "_";
            }
            name = name + parts[i];
        }
        return name;
    }

    private static void generateTests(String entityName, String entityVarName, Map<String, String> attributes, String scheme) {
        String template = TemplatesHelper.getTemplate(scheme + "/modelTest");
        template = template.replace("${EntityName}", entityName);
        template = template.replace("${EntityNameVar}", entityVarName);
        template = ModelGenerator.buildTestAttributes(template, entityName, attributes, scheme);
        TemplatesHelper.flush("test", "tests", entityName + ".scala", template);
    }

    private static String buildAttributes(String template, String entityVarName, Map<String, String> attributes, String scheme) {
        StringBuilder varDefinitions = new StringBuilder();
        StringBuilder constructorParams = new StringBuilder();
        StringBuilder entityAttributesAssignment = new StringBuilder();
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            String varName = attribute.getKey();
            String varType = attribute.getValue();
            if (varName.toLowerCase().equals("id")) continue;
            String defaultVal = TypeRegistry.getDefaultValue(varType);
            varType = TypeRegistry.getTypeName(varType);
            String var = ATTRIBUTE_TEMPLATE.replace("${attributeName}", varName);
            var = var.replace("${attributeType}", varType);
            var = var.replace("${attributeDefaultValue}", defaultVal);
            if (!TypeRegistry.isRegistered(varType) && "jpa".equals(scheme)) {
                var = "@ManyToOne\n  " + var;
            }
            varDefinitions.append(var).append("\n  ");
            if (constructorParams.length() != 0) {
                constructorParams.append(", ");
            }
            constructorParams.append(varName + ": " + varType);
            entityAttributesAssignment.append(entityVarName).append(".").append(varName).append(" = ").append(varName).append("\n    ");
        }
        template = template.replace("${EntityAttributes}", varDefinitions.toString());
        template = template.replace("${ConstructorParams}", constructorParams.toString());
        template = template.replace("${EntityAttributesAssignment}", entityAttributesAssignment.toString());
        return template;
    }

    private static String buildTestAttributes(String template, String entityName, Map<String, String> attributes, String scheme) {
        StringBuilder DependentObjects = new StringBuilder();
        StringBuilder assertions = new StringBuilder();
        StringBuilder TestDataValues = new StringBuilder();
        boolean pending = true;
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            String varName = attribute.getKey();
            String varType = attribute.getValue();
            if (varName.toLowerCase().equals("id")) continue;
            String testDataVal = TypeRegistry.getTestDataValue(varType);
            varType = TypeRegistry.getTypeName(varType);
            String var = "";
            boolean dependency = false;
            if (!TypeRegistry.isRegistered(varType)) {
                dependency = true;
                var = DEPENDENCY_TEMPLATE.replace("${attributeName}", varName);
                var = var.replace("${attributeType}", varType);
                DependentObjects.append(var).append("\n  ");
                testDataVal = varName;
            }
            if (TestDataValues.length() != 0) {
                TestDataValues.append(", ");
            }
            TestDataValues.append(testDataVal);
            if (dependency) continue;
            if ("Date".equals(varType)) {
                assertions.append("(first").append(entityName).append(".").append(varName).append(") should not be (null)\n    ");
            } else {
                assertions.append("(first").append(entityName).append(".").append(varName).append(") should be (").append(testDataVal).append(")\n    ");
            }
            if (!pending || testDataVal.startsWith("new ")) continue;
            String query = "jpa".equals(scheme) ? Character.toUpperCase(varName.charAt(0)) + varName.substring(1) : varName;
            template = template.replace("${attributeName}", query);
            template = template.replace("${attributeValue}", testDataVal);
            pending = false;
        }
        template = template.replace("${DependentObjects}", DependentObjects.toString());
        template = template.replace("${TestDataValues}", TestDataValues.toString());
        template = template.replace("${assertions}", assertions.toString());
        return template;
    }

    private static void generateYML(String entityName, String entityVarName, Map<String, String> attributes) {
        StringBuilder yml = new StringBuilder();
        yml.append("# This is test data for models.").append(entityName).append("\n\n\n");
        yml.append("# ").append(entityName).append("(").append(entityVarName).append("1):\n");
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            String varName = attribute.getKey();
            String varType = attribute.getValue();
            yml.append("#     ").append(varName).append(": ");
            if (TypeRegistry.isRegistered(varType)) {
                yml.append(TypeRegistry.getTestDataValue(varType).replace("\"", "")).append("\n");
                continue;
            }
            yml.append(varName).append("1\n");
        }
        TemplatesHelper.flush("", "test", entityVarName + ".yml", yml.toString());
    }
}

