/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scalagen.jpa;

import java.util.Calendar;
import java.util.Map;
import play.modules.scalagen.TypeRegistry;
import play.modules.scalagen.util.TemplatesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewGenerator {
    public static void generate(String entityName, Map<String, String> attributes) {
        String entityVarName = Character.toLowerCase(entityName.charAt(0)) + entityName.substring(1);
        ViewGenerator.generateDateInput();
        ViewGenerator.generateIndex(entityName, entityVarName, attributes);
        ViewGenerator.generateShow(entityName, entityVarName, attributes);
        ViewGenerator.generateNew(entityName, entityVarName, attributes);
        ViewGenerator.generateEdit(entityName, entityVarName, attributes);
        ViewGenerator.generateForm(entityName, entityVarName, attributes);
        ViewGenerator.generateJQueryJS(entityName, entityVarName, attributes);
    }

    private static void generateIndex(String entityName, String entityVarName, Map<String, String> attributes) {
        String indexTemplate = TemplatesHelper.getTemplate("jpa/view_index");
        StringBuilder tableHeaders = new StringBuilder();
        StringBuilder rowValues = new StringBuilder();
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            String varName = attribute.getKey();
            if (varName.toLowerCase().equals("id")) continue;
            tableHeaders.append("    <th>").append(ViewGenerator.capitalize(varName)).append("</th>\n");
            rowValues.append("    <td>@").append(entityVarName).append(".").append(varName).append("</td>\n");
        }
        indexTemplate = indexTemplate.replace("${TableHeaders}", tableHeaders.toString());
        indexTemplate = indexTemplate.replace("${RowValues}", rowValues.toString());
        indexTemplate = indexTemplate.replace("${EntityName}", entityName);
        indexTemplate = indexTemplate.replace("${EntityNameVar}", entityVarName);
        TemplatesHelper.flush("app", "views" + System.getProperty("file.separator") + entityVarName + "s", "index.scala.html", indexTemplate);
    }

    private static void generateShow(String entityName, String entityVarName, Map<String, String> attributes) {
        String indexTemplate = TemplatesHelper.getTemplate("jpa/view_show");
        StringBuilder tableHeaders = new StringBuilder();
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            String varName = attribute.getKey();
            if (varName.toLowerCase().equals("id")) continue;
            tableHeaders.append("<br/>    ").append(ViewGenerator.capitalize(varName)).append(":");
            tableHeaders.append(" @").append(entityVarName).append(".").append(varName).append("\n");
        }
        indexTemplate = indexTemplate.replace("${ShowDetails}", tableHeaders.toString());
        indexTemplate = indexTemplate.replace("${EntityName}", entityName);
        indexTemplate = indexTemplate.replace("${EntityNameVar}", entityVarName);
        TemplatesHelper.flush("app", "views" + System.getProperty("file.separator") + entityVarName + "s", "show.scala.html", indexTemplate);
    }

    private static void generateNew(String entityName, String entityVarName, Map<String, String> attributes) {
        String indexTemplate = TemplatesHelper.getTemplate("jpa/view_new");
        indexTemplate = indexTemplate.replace("${EntityName}", entityName);
        indexTemplate = indexTemplate.replace("${EntityNameVar}", entityVarName);
        TemplatesHelper.flush("app", "views" + System.getProperty("file.separator") + entityVarName + "s", "newValue.scala.html", indexTemplate);
    }

    private static void generateEdit(String entityName, String entityVarName, Map<String, String> attributes) {
        String indexTemplate = TemplatesHelper.getTemplate("jpa/view_edit");
        indexTemplate = indexTemplate.replace("${EntityName}", entityName);
        indexTemplate = indexTemplate.replace("${EntityNameVar}", entityVarName);
        TemplatesHelper.flush("app", "views" + System.getProperty("file.separator") + entityVarName + "s", "edit.scala.html", indexTemplate);
    }

    private static void generateForm(String entityName, String entityVarName, Map<String, String> attributes) {
        String formTemplate = TemplatesHelper.getTemplate("jpa/view_form");
        StringBuilder formData = new StringBuilder();
        formData.append("<input type=\"hidden\" id=\"id\" name=\"id\" value=\"@_").append(entityVarName).append(".id\" />\n");
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            String varName = attribute.getKey();
            String varType = attribute.getValue();
            varType = TypeRegistry.getTypeName(varType);
            formData.append("<div class=\"field_row\"><label for=\"").append(varName).append("\">").append(ViewGenerator.capitalize(varName)).append(":</label><div class=\"field_holder\">");
            if (!varType.equals("Date") && !varType.equals(Calendar.class.getName())) {
                formData.append("<input type=\"text\" id=\"").append(varName).append("\" name=\"").append(varName).append("\" value=\"@_").append(entityVarName).append(".").append(varName).append("\" /></div></div>\n");
                continue;
            }
            formData.append(ViewGenerator.getDateElement(varName));
        }
        formTemplate = formTemplate.replace("${FormInputs}", formData.toString());
        formTemplate = formTemplate.replace("${EntityName}", entityName);
        formTemplate = formTemplate.replace("${EntityNameVar}", entityVarName);
        TemplatesHelper.flush("app", "views" + System.getProperty("file.separator") + entityVarName + "s", "form.scala.html", formTemplate);
    }

    private static void generateDateInput() {
        if (!TemplatesHelper.exists("app", "views", "dateInput.scala.html")) {
            String indexTemplate = TemplatesHelper.getTemplate("jpa/view_dateInput");
            TemplatesHelper.flush("app", "views", "dateInput.scala.html", indexTemplate);
        }
    }

    private static String getDateElement(String varName) {
        StringBuilder formData = new StringBuilder();
        formData.append("@dateInput(_monthElement=\"").append(varName).append("_month\", _dayElement=\"").append(varName).append("_day\", _yearElement=\"").append(varName).append("_year\")\n");
        return formData.toString();
    }

    private static void generateJQueryJS(String entityName, String entityVarName, Map<String, String> attributes) {
        String jsTemplate = TemplatesHelper.getTemplate("jpa/grid_js");
        StringBuilder colModel = new StringBuilder();
        String COL_MODEL_FORMAT = "{ name: '${header}', index: '${attribute}', hidden: false, sortable: true ${formatOptions} }";
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            String varName = attribute.getKey();
            String varType = attribute.getValue();
            varType = TypeRegistry.getTypeName(varType);
            String model = "{ name: '${header}', index: '${attribute}', hidden: false, sortable: true ${formatOptions} }".replace("${attribute}", varName);
            model = model.replace("${header}", ViewGenerator.capitalize(varName));
            if (varType.equals("Date") || varType.equals(Calendar.class.getName())) {
                String formatoptions = ", formatter:'date', formatoptions: { srcformat: 'Y-m-d H:i:sO', newformat: 'F dS Y' }";
                model = model.replace("${formatOptions}", formatoptions);
            } else {
                model = model.replace("${formatOptions}", "");
            }
            if (colModel.length() != 0) {
                colModel.append(", \n");
            }
            colModel.append(model);
        }
        jsTemplate = jsTemplate.replace("${EntityName}", entityName);
        jsTemplate = jsTemplate.replace("${EntityNameVar}", entityVarName);
        jsTemplate = jsTemplate.replace("${ColumnModel}", colModel);
        TemplatesHelper.flush("public", "javascripts", entityVarName + "s.js", jsTemplate);
    }

    private static String capitalize(String value) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (i == 0) {
                c = Character.toUpperCase(c);
            } else if (Character.isUpperCase(c)) {
                sb.append(" ");
            }
            sb.append(c);
        }
        return sb.toString().trim();
    }
}

