/*
 * Decompiled with CFR 0.152.
 */
package play.modules.scalagen.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class TemplatesHelper {
    private static final String BASE_DIR = System.getProperty("application.path");
    private static final String SLASH = System.getProperty("file.separator");

    public static String getTemplate(String name) {
        InputStream in = TemplatesHelper.class.getClassLoader().getResourceAsStream("templates/" + name);
        String template = TemplatesHelper.read(in).trim();
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush(String parentDirectory, String directory, String filename, String content) {
        try {
            String dirName = BASE_DIR + SLASH + parentDirectory + SLASH + directory;
            File dir = new File(dirName);
            if (!dir.exists()) {
                dir.mkdir();
            }
            String outputFile = dirName + SLASH + filename;
            outputFile = outputFile.replace(SLASH + SLASH, SLASH);
            OutputStreamWriter fstream = new OutputStreamWriter(new FileOutputStream(outputFile));
            BufferedWriter out = new BufferedWriter(fstream);
            try {
                out.write(content);
                System.out.println("* Created " + outputFile);
            }
            finally {
                out.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean exists(String parentDirectory, String directory, String filename) {
        String fileName = BASE_DIR + SLASH + parentDirectory + SLASH + directory + SLASH + filename;
        return new File(fileName).exists();
    }

    public static boolean canOverwrite(String parentDirectory, String directory, String filename) {
        boolean canOverwrite = false;
        if (TemplatesHelper.exists(parentDirectory, directory, filename)) {
            System.out.print(filename + " already exists. Overwrite (Y/N) ? : ");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String overwrite = null;
            try {
                overwrite = br.readLine();
                if (overwrite != null && overwrite.toUpperCase().equals("Y")) {
                    canOverwrite = true;
                } else {
                    System.out.println("Skipping generation of " + filename);
                }
            }
            catch (IOException e) {
                System.out.println("Error reading the response!");
                System.exit(1);
            }
        }
        return canOverwrite;
    }

    private static String read(InputStream in) {
        StringBuilder sb = new StringBuilder();
        try {
            String strLine;
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                sb.append("\n").append(strLine);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return sb.toString();
    }
}

