/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import org.fusesource.scalate.Binding;
import org.fusesource.scalate.CodeGenerator;
import org.fusesource.scalate.DefaultRenderContext;
import org.fusesource.scalate.FileResourceLoader;
import org.fusesource.scalate.FileResourceLoader$;
import org.fusesource.scalate.Filter;
import org.fusesource.scalate.RenderContext;
import org.fusesource.scalate.ResourceLoader;
import org.fusesource.scalate.Template;
import org.fusesource.scalate.TemplateEngine$;
import org.fusesource.scalate.TemplateEngine$CacheEntry$;
import org.fusesource.scalate.TemplateException;
import org.fusesource.scalate.layout.DefaultLayoutStrategy;
import org.fusesource.scalate.scaml.ScamlCodeGenerator;
import org.fusesource.scalate.ssp.ScalaCompiler;
import org.fusesource.scalate.ssp.SspCodeGenerator;
import org.fusesource.scalate.util.IOUtil$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.compat.Platform$;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.Exception;
import scala.util.control.Exception$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateEngine
implements ScalaObject {
    public volatile int bitmap$0;
    private /* synthetic */ TemplateEngine$CacheEntry$ CacheEntry$module;
    private final HashMap<String, CacheEntry> templateCache;
    private List<Binding> bindings;
    private ClassLoader classLoader;
    private File _workingDirectory;
    private boolean combinedClassPath;
    private String classpath;
    private ScalaCompiler compiler;
    private DefaultLayoutStrategy layoutStrategy;
    private final Exception.Catch<Object> attempt;
    private Map<String, Filter> filters;
    private Map<String, CodeGenerator> codeGenerators;
    private ResourceLoader resourceLoader = new FileResourceLoader((Option<File>)FileResourceLoader$.MODULE$.init$default$1());
    private boolean allowReload = true;
    private boolean allowCaching = true;

    public TemplateEngine() {
        this.codeGenerators = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"ssp").$minus$greater((Object)new SspCodeGenerator()), Predef$.MODULE$.any2ArrowAssoc((Object)"scaml").$minus$greater((Object)new ScamlCodeGenerator())}));
        this.filters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.attempt = Exception$.MODULE$.ignoring((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Throwable.class}));
        this.attempt().apply((Function0)new $anonfun$1(this));
        this.attempt().apply((Function0)new $anonfun$2(this));
        this.attempt().apply((Function0)new $anonfun$3(this));
        this.attempt().apply((Function0)new $anonfun$4(this));
        this.layoutStrategy = new DefaultLayoutStrategy(this);
        this.classpath = null;
        this.combinedClassPath = false;
        this._workingDirectory = null;
        this.classLoader = this.getClass().getClassLoader();
        this.bindings = Nil$.MODULE$;
        this.templateCache = new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    private final Template liftedTree1$1(String string, List list) {
        void var3_3;
        Template exceptionResult2 = null;
        try {
            exceptionResult2 = this.cache(string, this.loadPrecompiledEntry(string, (List<Binding>)list));
        }
        catch (Throwable throwable) {
            exceptionResult2 = this.cache(string, this.compileAndLoadEntry(string, (List<Binding>)list));
        }
        return var3_3;
    }

    private final /* synthetic */ TemplateEngine$CacheEntry$ CacheEntry() {
        if (this.CacheEntry$module == null) {
            this.CacheEntry$module = new TemplateEngine$CacheEntry$(this);
        }
        return this.CacheEntry$module;
    }

    private long lastModified(Class<?> clazz) {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        CodeSource codeSource2 = codeSource;
        if (codeSource2 != null && !((Object)codeSource2).equals(null)) {
            String string = codeSource.getLocation().getProtocol();
            String string2 = "file";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                File location = new File(codeSource.getLocation().getPath());
                if (location.isDirectory()) {
                    File classFile = new File(location, new StringBuilder().append((Object)clazz.getName().replace('.', '/')).append((Object)".class").toString());
                    if (classFile.exists()) {
                        return classFile.lastModified();
                    }
                } else {
                    return location.lastModified();
                }
            }
        }
        return 0L;
    }

    private Template loadCompiledTemplate(String className) {
        URLClassLoader cl = new URLClassLoader((URL[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new URL[]{this.bytecodeDirectory().toURI().toURL()}), ClassManifest$.MODULE$.classType(URL.class)), this.classLoader());
        Class<?> clazz = cl.loadClass(className);
        return (Template)clazz.newInstance();
    }

    private CodeGenerator generatorForExtension(String extension) {
        Option temp17 = this.codeGenerators().get((Object)extension);
        None$ none$ = None$.MODULE$;
        Option option = temp17;
        if (!(none$ != null ? !none$.equals(option) : option != null)) {
            throw new TemplateException(new StringBuilder().append((Object)"Not a template file extension (").append((Object)this.codeGenerators().keysIterator().mkString("|")).append((Object)"), you requested: ").append((Object)extension).toString());
        }
        if (temp17 instanceof Some) {
            Some temp19 = (Some)temp17;
            CodeGenerator temp20 = (CodeGenerator)temp19.x();
            return temp20;
        }
        throw new MatchError(temp17.toString());
    }

    private CodeGenerator generator(String uri) {
        String[] t = uri.split("\\.");
        if (t.length < 2) {
            throw new TemplateException("Template file extension missing. Cannot determine which template processor to use.");
        }
        return this.generatorForExtension((String)Predef$.MODULE$.refArrayOps((Object[])t).last());
    }

    private Tuple2<Template, Set<String>> compileAndLoad(String uri, List<Binding> extraBindings, int attempt) {
        InstantiationException instantiationException2;
        block4: {
            Tuple2 exceptionResult1 = null;
            try {
                CodeGenerator.Code code = this.generateScala(uri, extraBindings);
                File sourceFile = new File(this.sourceDirectory(), new StringBuilder().append((Object)uri.replace(':', '_')).append((Object)".scala").toString());
                sourceFile.getParentFile().mkdirs();
                IOUtil$.MODULE$.writeBinaryFile(sourceFile, code.source().getBytes("UTF-8"));
                this.compiler().compile(sourceFile);
                Template template = this.loadCompiledTemplate(code.className());
                exceptionResult1 = new Tuple2((Object)template, code.dependencies());
            }
            catch (Throwable throwable) {
                throw new TemplateException(throwable.getMessage(), throwable);
            }
            catch (TemplateException templateException) {
                throw templateException;
            }
            catch (InstantiationException instantiationException2) {
                if (attempt != 0) break block4;
                exceptionResult1 = this.compileAndLoad(uri, extraBindings, 1);
            }
            return exceptionResult1;
        }
        throw new TemplateException(instantiationException2.getMessage(), instantiationException2);
    }

    private Template cache(String uri, CacheEntry ce) {
        Object object = this.allowCaching() ? this.templateCache().$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)uri).$minus$greater((Object)ce)) : BoxedUnit.UNIT;
        return ce.template();
    }

    private CacheEntry compileAndLoadEntry(String uri, List<Binding> extraBindings) {
        Tuple2<Template, Set<String>> temp14 = this.compileAndLoad(uri, extraBindings, 0);
        if (temp14 != null) {
            Template temp15 = (Template)temp14._1();
            Set temp16 = (Set)temp14._2();
            Template template = temp15;
            Tuple2 tuple2 = new Tuple2((Object)template, (Object)temp16);
            Template template2 = (Template)tuple2._1();
            Set dependencies = (Set)tuple2._2();
            return new CacheEntry(this, template2, (Set<String>)dependencies, Platform$.MODULE$.currentTime());
        }
        throw new MatchError(temp14.toString());
    }

    private CacheEntry loadPrecompiledEntry(String uri, List<Binding> extraBindings) {
        CacheEntry cacheEntry;
        String className = this.generator(uri).className(uri);
        Template template = this.loadCompiledTemplate(className);
        if (this.allowCaching() && this.allowReload()) {
            CodeGenerator.Code code = this.generateScala(uri, extraBindings);
            CacheEntry entry = new CacheEntry(this, template, code.dependencies(), this.lastModified(template.getClass()));
            if (entry.isStale()) {
                throw new Exception("Template is stale.");
            }
            cacheEntry = entry;
        } else {
            cacheEntry = new CacheEntry(this, template, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))), 0L);
        }
        return cacheEntry;
    }

    public String layout(Template template) {
        return this.layout(template, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))));
    }

    public void layout(String uri, RenderContext context) {
        this.layout(uri, context, (List<Binding>)Nil$.MODULE$);
    }

    public String layout(Template template, Map<String, Object> attributes2) {
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        DefaultRenderContext context$1 = new DefaultRenderContext(this, out);
        attributes2.foreach((Function1)new $anonfun$layout$1(this, context$1));
        this.layout(template, (RenderContext)context$1);
        return buffer.toString();
    }

    public String layout(String uri, Map<String, Object> attributes2, List<Binding> extraBindings) {
        Template template = this.load(uri, extraBindings);
        return this.layout(template, attributes2);
    }

    public void layout(Template template, RenderContext context) {
        this.layoutStrategy().layout(template, context);
    }

    public void layout(String uri, RenderContext context, List<Binding> extraBindings) {
        Template template = this.load(uri, extraBindings);
        this.layout(template, context);
    }

    public Template load(String uri$1, List<Binding> extraBindings$1) {
        HashMap<String, CacheEntry> hashMap = this.templateCache();
        synchronized (hashMap) {
            Option temp7;
            block6: {
                Template template;
                temp7 = this.templateCache().get((Object)uri$1);
                None$ none$ = None$.MODULE$;
                Option option = temp7;
                if (!(none$ != null ? !none$.equals(option) : option != null)) {
                    template = this.liftedTree1$1(uri$1, extraBindings$1);
                } else {
                    CacheEntry temp10;
                    if (!(temp7 instanceof Some)) break block6;
                    Some temp9 = (Some)temp7;
                    CacheEntry entry = temp10 = (CacheEntry)temp9.x();
                    template = this.allowReload() && entry.isStale() ? this.cache(uri$1, this.compileAndLoadEntry(uri$1, extraBindings$1)) : entry.template();
                }
                return template;
            }
            throw new MatchError(temp7.toString());
        }
    }

    public CodeGenerator.Code generateScala(String uri, List<Binding> extraBindings) {
        List<Binding> list = this.bindings();
        return this.generator(uri).generate(this, uri, (List<Binding>)extraBindings.$colon$colon$colon(list));
    }

    public Template compile(String uri, List<Binding> extraBindings) {
        return (Template)this.compileAndLoad(uri, extraBindings, 0)._1();
    }

    public Template compileText(String extension, String text, List<Binding> extraBindings) {
        File file = File.createTempFile("scalate", new StringBuilder().append((Object)".").append((Object)extension).toString());
        FileWriter writer = new FileWriter(file);
        writer.write(text);
        writer.close();
        return this.compile(file.getAbsolutePath(), extraBindings);
    }

    public Template compileScaml(String text, List<Binding> extraBindings) {
        return this.compileText("scaml", text, extraBindings);
    }

    public Template compileSsp(String text, List<Binding> extraBindings) {
        return this.compileText("ssp", text, extraBindings);
    }

    private HashMap<String, CacheEntry> templateCache() {
        return this.templateCache;
    }

    public void bindings_$eq(List<Binding> list) {
        this.bindings = list;
    }

    public List<Binding> bindings() {
        return this.bindings;
    }

    public void classLoader_$eq(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public void workingDirectory_$eq(File value2) {
        this._workingDirectory_$eq(value2);
    }

    public File workingDirectory() {
        File file = this._workingDirectory();
        if (file == null || ((Object)file).equals(null)) {
            this._workingDirectory_$eq(new File(new File(System.getProperty("java.io.tmpdir")), "_scalate"));
        }
        return this._workingDirectory();
    }

    private void _workingDirectory_$eq(File file) {
        this._workingDirectory = file;
    }

    private File _workingDirectory() {
        return this._workingDirectory;
    }

    public void combinedClassPath_$eq(boolean bl) {
        this.combinedClassPath = bl;
    }

    public boolean combinedClassPath() {
        return this.combinedClassPath;
    }

    public void classpath_$eq(String string) {
        this.classpath = string;
    }

    public String classpath() {
        return this.classpath;
    }

    public File bytecodeDirectory() {
        return new File(this.workingDirectory(), "classes");
    }

    public File sourceDirectory() {
        return new File(this.workingDirectory(), "src");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScalaCompiler compiler() {
        if ((this.bitmap$0 & 1) != 0) return this.compiler;
        TemplateEngine templateEngine = this;
        synchronized (templateEngine) {
            if ((this.bitmap$0 & 1) == 0) {
                this.compiler = new ScalaCompiler(this.bytecodeDirectory(), this.classpath(), this.combinedClassPath());
                this.bitmap$0 |= 1;
            }
            return this.compiler;
        }
    }

    public void layoutStrategy_$eq(DefaultLayoutStrategy defaultLayoutStrategy) {
        this.layoutStrategy = defaultLayoutStrategy;
    }

    public DefaultLayoutStrategy layoutStrategy() {
        return this.layoutStrategy;
    }

    private Exception.Catch<Object> attempt() {
        return this.attempt;
    }

    public void filters_$eq(Map<String, Filter> map) {
        this.filters = map;
    }

    public Map<String, Filter> filters() {
        return this.filters;
    }

    public void codeGenerators_$eq(Map<String, CodeGenerator> map) {
        this.codeGenerators = map;
    }

    public Map<String, CodeGenerator> codeGenerators() {
        return this.codeGenerators;
    }

    public void resourceLoader_$eq(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader resourceLoader() {
        return this.resourceLoader;
    }

    public void allowReload_$eq(boolean bl) {
        this.allowReload = bl;
    }

    public boolean allowReload() {
        return this.allowReload;
    }

    public void allowCaching_$eq(boolean bl) {
        this.allowCaching = bl;
    }

    public boolean allowCaching() {
        return this.allowCaching;
    }

    public /* synthetic */ List load$default$2() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ Map layout$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public /* synthetic */ List layout$default$3() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ List compileSsp$default$2() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ List compileText$default$3() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ List compileScaml$default$2() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ List compile$default$2() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ List generateScala$default$2() {
        return Nil$.MODULE$;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CacheEntry
    implements ScalaObject,
    Product,
    Serializable {
        public final /* synthetic */ TemplateEngine $outer;
        private final long timestamp;
        private final Set<String> dependencies;
        private final Template template;

        public CacheEntry(TemplateEngine $outer, Template template, Set<String> dependencies, long timestamp) {
            this.template = template;
            this.dependencies = dependencies;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final /* synthetic */ boolean gd1$1(Template template, Set set, long l) {
            Template template2 = template;
            Template template3 = this.template();
            if (template2 == null) {
                if (template3 != null) {
                    return false;
                }
            } else if (!template2.equals(template3)) return false;
            Set set2 = set;
            Set<String> set3 = this.dependencies();
            if (set2 == null) {
                if (set3 != null) {
                    return false;
                }
            } else if (!set2.equals(set3)) return false;
            if (l != this.timestamp()) return false;
            return true;
        }

        public /* synthetic */ TemplateEngine org$fusesource$scalate$TemplateEngine$CacheEntry$$$outer() {
            return this.$outer;
        }

        public boolean canEqual(Object object) {
            return object instanceof CacheEntry;
        }

        public Object productElement(int n) {
            Object object;
            int temp6 = n;
            switch (temp6) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                case 1: {
                    object = this.dependencies();
                    break;
                }
                case 0: {
                    object = this.template();
                }
            }
            return object;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "CacheEntry";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            long temp5;
            long timestamp$1;
            Set<String> temp4;
            Set<String> dependencies$1;
            if (this == object) return true;
            Object temp1 = object;
            if (!(temp1 instanceof CacheEntry)) return false;
            if (((CacheEntry)temp1).org$fusesource$scalate$TemplateEngine$CacheEntry$$$outer() != this.org$fusesource$scalate$TemplateEngine$CacheEntry$$$outer()) return false;
            CacheEntry temp2 = (CacheEntry)temp1;
            Template temp3 = temp2.template();
            Template template$1 = temp3;
            if (!this.gd1$1(template$1, dependencies$1 = (temp4 = temp2.dependencies()), timestamp$1 = (temp5 = temp2.timestamp()))) return false;
            template$1 = temp3;
            dependencies$1 = temp4;
            boolean bl = ((CacheEntry)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public /* synthetic */ CacheEntry copy(Template template, Set dependencies, long timestamp) {
            return new CacheEntry(this.org$fusesource$scalate$TemplateEngine$CacheEntry$$$outer(), template, (Set<String>)dependencies, timestamp);
        }

        public boolean isStale() {
            return this.dependencies().exists((Function1)new CacheEntry$$anonfun$isStale$1(this));
        }

        public long timestamp() {
            return this.timestamp;
        }

        public Set<String> dependencies() {
            return this.dependencies;
        }

        public Template template() {
            return this.template;
        }

        public /* synthetic */ Template copy$default$1() {
            return this.template();
        }

        public /* synthetic */ Set copy$default$2() {
            return this.dependencies();
        }

        public /* synthetic */ long copy$default$3() {
            return this.timestamp();
        }

        public Iterator productElements() {
            return Product.class.productElements((Product)this);
        }

        public Iterator productIterator() {
            return Product.class.productIterator((Product)this);
        }
    }
}

