/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.ssp;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fusesource.scalate.TemplateException;
import org.fusesource.scalate.ssp.ScalaCompiler$;
import org.fusesource.scalate.util.ClassPathBuilder;
import org.fusesource.scalate.util.Logging;
import org.fusesource.scalate.util.Logging$class;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.tools.nsc.Global;
import scala.tools.nsc.Settings;
import scala.tools.nsc.reporters.ConsoleReporter;
import scala.tools.nsc.reporters.Reporter;

public class ScalaCompiler
implements Logging,
ScalaObject {
    private final Logger log;
    private final Global compiler;
    private final Settings settings;

    public static final boolean init$default$3() {
        return ScalaCompiler$.MODULE$.init$default$3();
    }

    public ScalaCompiler(File bytecodeDirectory, String classpath, boolean combineClasspath) {
        Logging$class.$init$(this);
        this.settings = this.generateSettings(bytecodeDirectory, classpath, combineClasspath);
        this.compiler = new Global(this.settings(), null);
    }

    private Settings generateSettings(File bytecodeDirectory, String classpath, boolean combined) {
        bytecodeDirectory.mkdirs();
        String pathSeparator = File.pathSeparator;
        String string = classpath;
        ObjectRef useCP$1 = new ObjectRef((Object)(string == null || string.equals(null) || combined ? new ClassPathBuilder().addPathFromContextClassLoader().addPathFrom(Product.class).addPathFrom(Global.class).addPathFrom(this.getClass()).addPathFromSystemClassLoader().addJavaPath().addEntry(classpath).classPath() : classpath));
        this.fine((Function0<String>)new $anonfun$generateSettings$1(this, useCP$1));
        Settings settings = new Settings((Function1)new $anonfun$1(this));
        settings.classpath().value_$eq((Object)((String)useCP$1.elem));
        settings.outdir().value_$eq(bytecodeDirectory.toString());
        settings.deprecation().value_$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        settings.unchecked().value_$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        return settings;
    }

    public final void org$fusesource$scalate$ssp$ScalaCompiler$$error(String message) {
        throw new TemplateException(new StringBuilder().append((Object)"Compilation failed:\n").append((Object)message).toString());
    }

    public void compile(File file) {
        ScalaCompiler scalaCompiler = this;
        synchronized (scalaCompiler) {
            StringWriter messageCollector = new StringWriter();
            PrintWriter messageCollectorWrapper = new PrintWriter(messageCollector);
            ConsoleReporter reporter = new ConsoleReporter(this.settings(), Console$.MODULE$.in(), messageCollectorWrapper);
            this.compiler().reporter_$eq((Reporter)reporter);
            new Global.Run(this.compiler()).compile(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file.getCanonicalPath()})));
            if (reporter.hasErrors()) {
                reporter.printSummary();
                messageCollectorWrapper.close();
                throw new TemplateException(new StringBuilder().append((Object)"Compilation failed:\n").append((Object)messageCollector).toString());
            }
            return;
        }
    }

    public Global compiler() {
        return this.compiler;
    }

    public Settings settings() {
        return this.settings;
    }

    public void log(Level level, Function0 fn) {
        Logging$class.log(this, level, fn);
    }

    public void finest(Function0 fn) {
        Logging$class.finest(this, fn);
    }

    public void finer(Function0 fn) {
        Logging$class.finer(this, fn);
    }

    public void fine(Function0 fn) {
        Logging$class.fine(this, fn);
    }

    public void info(Function0 fn) {
        Logging$class.info(this, fn);
    }

    public void warning(Function0 fn) {
        Logging$class.warning(this, fn);
    }

    public void severe(Function0 fn) {
        Logging$class.severe(this, fn);
    }

    public void org$fusesource$scalate$util$Logging$_setter_$log_$eq(Logger logger) {
        this.log = logger;
    }

    public Logger log() {
        return this.log;
    }
}

