/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import org.fusesource.scalate.Binding;
import org.fusesource.scalate.CompilerException;
import org.fusesource.scalate.DefaultRenderContext;
import org.fusesource.scalate.InvalidSyntaxException;
import org.fusesource.scalate.RenderContext;
import org.fusesource.scalate.RenderContext$;
import org.fusesource.scalate.ResourceNotFoundException;
import org.fusesource.scalate.StaleCacheEntryException;
import org.fusesource.scalate.Template;
import org.fusesource.scalate.TemplateEngine$;
import org.fusesource.scalate.TemplateEngine$CacheEntry$;
import org.fusesource.scalate.TemplateException;
import org.fusesource.scalate.filter.Filter;
import org.fusesource.scalate.layout.LayoutStrategy;
import org.fusesource.scalate.layout.NullLayoutStrategy$;
import org.fusesource.scalate.scaml.ScamlCodeGenerator;
import org.fusesource.scalate.ssp.SspCodeGenerator;
import org.fusesource.scalate.support.Code;
import org.fusesource.scalate.support.CodeGenerator;
import org.fusesource.scalate.support.CompilerError;
import org.fusesource.scalate.support.FileResourceLoader;
import org.fusesource.scalate.support.FileResourceLoader$;
import org.fusesource.scalate.support.ResourceLoader;
import org.fusesource.scalate.support.ScalaCompiler;
import org.fusesource.scalate.util.IOUtil$;
import org.fusesource.scalate.util.Log;
import org.fusesource.scalate.util.Logging;
import org.fusesource.scalate.util.Logging$;
import org.fusesource.scalate.util.Logging$class;
import org.fusesource.scalate.util.SourceMap;
import org.fusesource.scalate.util.SourceMapInstaller$;
import org.fusesource.scalate.util.SourceMapStratum;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.DefaultMap;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.compat.Platform$;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.Exception;
import scala.util.control.Exception$;
import scala.util.parsing.input.OffsetPosition;
import scala.util.parsing.input.Position;
import scala.xml.NodeSeq;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateEngine
implements Logging,
ScalaObject {
    public volatile int bitmap$0;
    private /* synthetic */ TemplateEngine$CacheEntry$ CacheEntry$module;
    private final Log sourceMapLog;
    private final HashMap<String, CacheEntry> templateCache;
    private List<Binding> bindings;
    private ClassLoader classLoader;
    private File _workingDirectory;
    private String classpath;
    private ScalaCompiler compiler;
    private LayoutStrategy layoutStrategy;
    private final Exception.Catch<Object> attempt;
    private Map<String, Filter> filters;
    private Map<String, CodeGenerator> codeGenerators;
    private ResourceLoader resourceLoader;
    private List<String> importStatements;
    private boolean combinedClassPath;
    private boolean allowReload;
    private boolean allowCaching;

    public TemplateEngine() {
        Logging$class.$init$(this);
        this.allowCaching = true;
        this.allowReload = true;
        this.combinedClassPath = false;
        this.importStatements = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"import _root_.scala.collection.JavaConversions._"}));
        this.resourceLoader = new FileResourceLoader((Option<File>)FileResourceLoader$.MODULE$.init$default$1());
        this.codeGenerators = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"ssp").$minus$greater((Object)new SspCodeGenerator()), Predef$.MODULE$.any2ArrowAssoc((Object)"scaml").$minus$greater((Object)new ScamlCodeGenerator())}));
        this.filters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.attempt = Exception$.MODULE$.ignoring((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Throwable.class}));
        this.attempt().apply((Function0)new $anonfun$1(this));
        this.attempt().apply((Function0)new $anonfun$2(this));
        this.attempt().apply((Function0)new $anonfun$3(this));
        this.attempt().apply((Function0)new $anonfun$4(this));
        this.layoutStrategy = NullLayoutStrategy$.MODULE$;
        this.classpath = null;
        this._workingDirectory = null;
        this.classLoader = this.getClass().getClassLoader();
        Binding binding = new Binding("context", RenderContext.class.getName(), true, (Option<String>)None$.MODULE$, "val", false);
        this.bindings = Nil$.MODULE$.$colon$colon((Object)binding);
        this.templateCache = new HashMap();
        this.sourceMapLog = Logging$.MODULE$.apply(this.getClass(), "SourceMap");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final OffsetPosition template_pos$1(Position pos, ObjectRef objectRef) {
        OffsetPosition temp24;
        Position temp23 = pos;
        if (!(temp23 instanceof OffsetPosition)) return null;
        OffsetPosition p$1 = temp24 = (OffsetPosition)temp23;
        DefaultMap filtered = ((Code)objectRef.elem).positions().filterKeys((Function1)new $anonfun$5(this, objectRef, p$1));
        if (filtered.isEmpty()) {
            return null;
        }
        Tuple2 temp20 = (Tuple2)filtered.last();
        if (temp20 == null) throw new MatchError(temp20.toString());
        OffsetPosition temp21 = (OffsetPosition)temp20._1();
        OffsetPosition temp22 = (OffsetPosition)temp20._2();
        OffsetPosition key = temp21;
        Tuple2 tuple2 = new Tuple2((Object)key, (Object)temp22);
        OffsetPosition key2 = (OffsetPosition)tuple2._1();
        OffsetPosition value2 = (OffsetPosition)tuple2._2();
        int colChange = pos.column() - key2.column();
        OffsetPosition offsetPosition = new OffsetPosition(value2.source(), value2.offset() + colChange);
        return offsetPosition;
    }

    /*
     * WARNING - void declaration
     */
    private final Template liftedTree1$1(String string, List list) {
        void var3_3;
        Template exceptionResult3 = null;
        try {
            exceptionResult3 = this.cache(string, this.loadPrecompiledEntry(string, (List<Binding>)list));
        }
        catch (Throwable throwable) {
            exceptionResult3 = this.cache(string, this.compileAndLoadEntry(string, (List<Binding>)list));
        }
        return var3_3;
    }

    private final /* synthetic */ TemplateEngine$CacheEntry$ CacheEntry() {
        if (this.CacheEntry$module == null) {
            this.CacheEntry$module = new TemplateEngine$CacheEntry$(this);
        }
        return this.CacheEntry$module;
    }

    public void storeSourceMap(File classFile, String sourceMap) {
        SourceMapInstaller$.MODULE$.store(classFile, sourceMap);
    }

    public String buildSourceMap(String stratumName, String uri, File scalaFile, TreeMap<OffsetPosition, OffsetPosition> positions2) {
        String shortName = (String)Predef$.MODULE$.refArrayOps((Object[])uri.split("/")).last();
        String longName = Predef$.MODULE$.augmentString(uri).stripPrefix("/");
        SourceMapStratum stratum$1 = new SourceMapStratum(stratumName);
        int fileId$1 = stratum$1.addFile(shortName, longName);
        ObjectRef smap$1 = new ObjectRef((Object)new TreeMap((Ordering)Ordering$Int$.MODULE$));
        positions2.foreach((Function1)new $anonfun$buildSourceMap$1(this, smap$1));
        smap$1.elem = (TreeMap)((TreeMap)smap$1.elem).transform((Function2)new $anonfun$buildSourceMap$2(this), TreeMap$.MODULE$.canBuildFrom((Ordering)Ordering$Int$.MODULE$));
        ((TreeMap)smap$1.elem).foreach((Function1)new $anonfun$buildSourceMap$3(this, stratum$1, fileId$1));
        stratum$1.optimize();
        SourceMap sourceMap = new SourceMap();
        sourceMap.setOutputFileName(scalaFile.getName());
        sourceMap.addStratum(stratum$1, true);
        return sourceMap.toString();
    }

    private long lastModified(Class<?> clazz) {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        CodeSource codeSource2 = codeSource;
        if (codeSource2 != null && !((Object)codeSource2).equals(null)) {
            String string = codeSource.getLocation().getProtocol();
            String string2 = "file";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                File location = new File(codeSource.getLocation().getPath());
                if (location.isDirectory()) {
                    File classFile = new File(location, new StringBuilder().append((Object)clazz.getName().replace('.', '/')).append((Object)".class").toString());
                    if (classFile.exists()) {
                        return classFile.lastModified();
                    }
                } else {
                    return location.lastModified();
                }
            }
        }
        return 0L;
    }

    private Template loadCompiledTemplate(String className) {
        URLClassLoader cl = new URLClassLoader((URL[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new URL[]{this.bytecodeDirectory().toURI().toURL()}), ClassManifest$.MODULE$.classType(URL.class)), this.classLoader());
        Class<?> clazz = cl.loadClass(className);
        return (Template)clazz.newInstance();
    }

    private CodeGenerator generatorForExtension(String extension) {
        Option temp31 = this.codeGenerators().get((Object)extension);
        None$ none$ = None$.MODULE$;
        Option option = temp31;
        if (!(none$ != null ? !none$.equals(option) : option != null)) {
            throw new TemplateException(new StringBuilder().append((Object)"Not a template file extension (").append((Object)this.codeGenerators().keysIterator().mkString("|")).append((Object)"), you requested: ").append((Object)extension).toString());
        }
        if (temp31 instanceof Some) {
            Some temp33 = (Some)temp31;
            CodeGenerator temp34 = (CodeGenerator)temp33.x();
            return temp34;
        }
        throw new MatchError(temp31.toString());
    }

    private Option<String> extension(String uri) {
        String[] t = uri.split("\\.");
        return t.length < 2 ? None$.MODULE$ : new Some(Predef$.MODULE$.refArrayOps((Object[])t).last());
    }

    private CodeGenerator generator(String uri) {
        Option<String> temp27 = this.extension(uri);
        if (temp27 instanceof Some) {
            Some temp28 = (Some)temp27;
            String temp29 = (String)temp28.x();
            return this.generatorForExtension(temp29);
        }
        None$ none$ = None$.MODULE$;
        Option<String> option = temp27;
        if (!(none$ != null ? !none$.equals(option) : option != null)) {
            throw new TemplateException("Template file extension missing. Cannot determine which template processor to use.");
        }
        throw new MatchError(temp27.toString());
    }

    private Tuple2<Template, Set<String>> compileAndLoad(String uri$2, List<Binding> extraBindings, int attempt) {
        InstantiationException instantiationException2;
        block6: {
            ObjectRef code$1 = new ObjectRef(null);
            Tuple2 exceptionResult2 = null;
            try {
                CodeGenerator g = this.generator(uri$2);
                List<Binding> list = this.bindings();
                code$1.elem = g.generate(this, uri$2, (List<Binding>)extraBindings.$colon$colon$colon(list));
                File sourceFile = this.sourceFileName(uri$2);
                sourceFile.getParentFile().mkdirs();
                IOUtil$.MODULE$.writeBinaryFile(sourceFile, ((Code)code$1.elem).source().getBytes("UTF-8"));
                this.compiler().compile(sourceFile);
                String sourceMap$1 = this.buildSourceMap(g.stratumName(), uri$2, sourceFile, ((Code)code$1.elem).positions());
                this.sourceMapLog().debug((Function0<String>)new $anonfun$compileAndLoad$1(this, sourceMap$1));
                this.storeSourceMap(new File(this.bytecodeDirectory(), new StringBuilder().append((Object)((Code)code$1.elem).className().replace('.', '/')).append((Object)".class").toString()), sourceMap$1);
                this.storeSourceMap(new File(this.bytecodeDirectory(), new StringBuilder().append((Object)((Code)code$1.elem).className().replace('.', '/')).append((Object)"$.class").toString()), sourceMap$1);
                Template template = this.loadCompiledTemplate(((Code)code$1.elem).className());
                exceptionResult2 = new Tuple2((Object)template, ((Code)code$1.elem).dependencies());
            }
            catch (Throwable throwable) {
                throw new TemplateException(throwable.getMessage(), throwable);
            }
            catch (TemplateException templateException) {
                throw templateException;
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                invalidSyntaxException.template_$eq(uri$2);
                throw invalidSyntaxException;
            }
            catch (CompilerException compilerException) {
                ObjectRef newmessage$1 = new ObjectRef((Object)"Compilation failed:\n");
                List errors = (List)compilerException.errors().map((Function1)new $anonfun$6(this, uri$2, code$1, newmessage$1), List$.MODULE$.canBuildFrom());
                this.error(compilerException);
                throw new CompilerException((String)newmessage$1.elem, (List<CompilerError>)errors);
            }
            catch (InstantiationException instantiationException2) {
                if (attempt != 0) break block6;
                exceptionResult2 = this.compileAndLoad(uri$2, extraBindings, 1);
            }
            return exceptionResult2;
        }
        throw new TemplateException(instantiationException2.getMessage(), instantiationException2);
    }

    public Log sourceMapLog() {
        return this.sourceMapLog;
    }

    public File classFileName(String uri) {
        return new File(this.sourceDirectory(), new StringBuilder().append((Object)uri.replace(':', '_')).append((Object)".scala").toString());
    }

    public File sourceFileName(String uri) {
        return new File(this.sourceDirectory(), new StringBuilder().append((Object)uri.replace(':', '_')).append((Object)".scala").toString());
    }

    private Template cache(String uri, CacheEntry ce) {
        Object object = this.allowCaching() ? this.templateCache().$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)uri).$minus$greater((Object)ce)) : BoxedUnit.UNIT;
        return ce.template();
    }

    private CacheEntry compileAndLoadEntry(String uri, List<Binding> extraBindings) {
        Tuple2<Template, Set<String>> temp17 = this.compileAndLoad(uri, extraBindings, 0);
        if (temp17 != null) {
            Template temp18 = (Template)temp17._1();
            Set temp19 = (Set)temp17._2();
            Template template = temp18;
            Tuple2 tuple2 = new Tuple2((Object)template, (Object)temp19);
            Template template2 = (Template)tuple2._1();
            Set dependencies = (Set)tuple2._2();
            return new CacheEntry(this, template2, (Set<String>)dependencies, Platform$.MODULE$.currentTime());
        }
        throw new MatchError(temp17.toString());
    }

    private CacheEntry loadPrecompiledEntry(String uri, List<Binding> extraBindings) {
        CacheEntry cacheEntry;
        String className = this.generator(uri).className(uri);
        Template template = this.loadCompiledTemplate(className);
        if (this.allowCaching() && this.allowReload()) {
            Code code = this.generateScala(uri, extraBindings);
            CacheEntry entry = new CacheEntry(this, template, code.dependencies(), this.lastModified(template.getClass()));
            if (entry.isStale()) {
                throw new StaleCacheEntryException(uri);
            }
            cacheEntry = entry;
        } else {
            cacheEntry = new CacheEntry(this, template, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))), 0L);
        }
        return cacheEntry;
    }

    public NodeSeq layoutAsNodes(Template template) {
        return this.layoutAsNodes(template, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))));
    }

    public NodeSeq layoutAsNodes(Template template, Map<String, Object> attributes2) {
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        DefaultRenderContext context$2 = new DefaultRenderContext(this, out);
        attributes2.foreach((Function1)new $anonfun$layoutAsNodes$1(this, context$2));
        return context$2.captureNodeSeq(template);
    }

    public NodeSeq layoutAsNodes(String uri, Map<String, Object> attributes2, List<Binding> extraBindings) {
        Template template = this.load(uri, extraBindings);
        return this.layoutAsNodes(template, attributes2);
    }

    public String layout(Template template) {
        return this.layout(template, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))));
    }

    public void layout(String uri, RenderContext context) {
        this.layout(uri, context, (List<Binding>)Nil$.MODULE$);
    }

    public String layout(Template template, Map<String, Object> attributes2) {
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        DefaultRenderContext context$1 = new DefaultRenderContext(this, out);
        attributes2.foreach((Function1)new $anonfun$layout$1(this, context$1));
        this.layout(template, (RenderContext)context$1);
        return buffer.toString();
    }

    public String layout(String uri, Map<String, Object> attributes2, List<Binding> extraBindings) {
        Template template = this.load(uri, extraBindings);
        return this.layout(template, attributes2);
    }

    public void layout(Template template, RenderContext context) {
        RenderContext$.MODULE$.update(context);
        this.layoutStrategy().layout(template, context);
    }

    public void layout(String uri, RenderContext context, List<Binding> extraBindings) {
        Template template = this.load(uri, extraBindings);
        this.layout(template, context);
    }

    public void invalidateCachedTemplates() {
        HashMap<String, CacheEntry> hashMap = this.templateCache();
        synchronized (hashMap) {
            this.templateCache().clear();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean canLoad(String uri, List<Binding> extraBindings) {
        void var3_3;
        boolean exceptionResult1 = false;
        try {
            Template template = this.load(uri, extraBindings);
            exceptionResult1 = template != null && !template.equals(null);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            exceptionResult1 = false;
        }
        return (boolean)var3_3;
    }

    public Template load(File file) {
        return this.load(file.getPath(), (List<Binding>)Nil$.MODULE$);
    }

    public Template load(File file, List<Binding> extraBindings) {
        return this.load(file.getPath(), extraBindings);
    }

    public Template load(String uri$1, List<Binding> extraBindings$1) {
        HashMap<String, CacheEntry> hashMap = this.templateCache();
        synchronized (hashMap) {
            Option temp7;
            block6: {
                Template template;
                temp7 = this.templateCache().get((Object)uri$1);
                None$ none$ = None$.MODULE$;
                Option option = temp7;
                if (!(none$ != null ? !none$.equals(option) : option != null)) {
                    template = this.liftedTree1$1(uri$1, extraBindings$1);
                } else {
                    CacheEntry temp10;
                    if (!(temp7 instanceof Some)) break block6;
                    Some temp9 = (Some)temp7;
                    CacheEntry entry = temp10 = (CacheEntry)temp9.x();
                    template = this.allowReload() && entry.isStale() ? this.cache(uri$1, this.compileAndLoadEntry(uri$1, extraBindings$1)) : entry.template();
                }
                return template;
            }
            throw new MatchError(temp7.toString());
        }
    }

    public Code generateScala(String uri, List<Binding> extraBindings) {
        List<Binding> list = this.bindings();
        return this.generator(uri).generate(this, uri, (List<Binding>)extraBindings.$colon$colon$colon(list));
    }

    public Template compile(String uri, List<Binding> extraBindings) {
        return (Template)this.compileAndLoad(uri, extraBindings, 0)._1();
    }

    public Template compileText(String extension, String text2, List<Binding> extraBindings) {
        File file = File.createTempFile("scalate", new StringBuilder().append((Object)".").append((Object)extension).toString());
        FileWriter writer = new FileWriter(file);
        writer.write(text2);
        writer.close();
        return this.compile(file.getAbsolutePath(), extraBindings);
    }

    public Template compileScaml(String text2, List<Binding> extraBindings) {
        return this.compileText("scaml", text2, extraBindings);
    }

    public Template compileSsp(String text2, List<Binding> extraBindings) {
        return this.compileText("ssp", text2, extraBindings);
    }

    private HashMap<String, CacheEntry> templateCache() {
        return this.templateCache;
    }

    public void bindings_$eq(List<Binding> list) {
        this.bindings = list;
    }

    public List<Binding> bindings() {
        return this.bindings;
    }

    public void classLoader_$eq(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public void workingDirectory_$eq(File value2) {
        this._workingDirectory_$eq(value2);
    }

    public File workingDirectory() {
        Object object;
        File file = this._workingDirectory();
        if (file == null || ((Object)file).equals(null)) {
            String value2 = System.getProperty("scalate.workdir", "");
            String string = value2;
            if (string != null && !string.equals(null) && value2.length() > 0) {
                this._workingDirectory_$eq(new File(value2));
                object = BoxesRunTime.boxToBoolean((boolean)this._workingDirectory().mkdirs());
            } else {
                this._workingDirectory_$eq(new File(new File(System.getProperty("java.io.tmpdir")), "_scalate"));
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return this._workingDirectory();
    }

    private void _workingDirectory_$eq(File file) {
        this._workingDirectory = file;
    }

    private File _workingDirectory() {
        return this._workingDirectory;
    }

    public void classpath_$eq(String string) {
        this.classpath = string;
    }

    public String classpath() {
        return this.classpath;
    }

    public File bytecodeDirectory() {
        return new File(this.workingDirectory(), "classes");
    }

    public File sourceDirectory() {
        return new File(this.workingDirectory(), "src");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScalaCompiler compiler() {
        if ((this.bitmap$0 & 1) != 0) return this.compiler;
        TemplateEngine templateEngine = this;
        synchronized (templateEngine) {
            if ((this.bitmap$0 & 1) == 0) {
                this.compiler = new ScalaCompiler(this.bytecodeDirectory(), this.classpath(), this.combinedClassPath());
                this.bitmap$0 |= 1;
            }
            return this.compiler;
        }
    }

    public void layoutStrategy_$eq(LayoutStrategy layoutStrategy) {
        this.layoutStrategy = layoutStrategy;
    }

    public LayoutStrategy layoutStrategy() {
        return this.layoutStrategy;
    }

    private Exception.Catch<Object> attempt() {
        return this.attempt;
    }

    public void filters_$eq(Map<String, Filter> map) {
        this.filters = map;
    }

    public Map<String, Filter> filters() {
        return this.filters;
    }

    public void codeGenerators_$eq(Map<String, CodeGenerator> map) {
        this.codeGenerators = map;
    }

    public Map<String, CodeGenerator> codeGenerators() {
        return this.codeGenerators;
    }

    public void resourceLoader_$eq(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader resourceLoader() {
        return this.resourceLoader;
    }

    public void importStatements_$eq(List<String> list) {
        this.importStatements = list;
    }

    public List<String> importStatements() {
        return this.importStatements;
    }

    public void combinedClassPath_$eq(boolean bl) {
        this.combinedClassPath = bl;
    }

    public boolean combinedClassPath() {
        return this.combinedClassPath;
    }

    public void allowReload_$eq(boolean bl) {
        this.allowReload = bl;
    }

    public boolean allowReload() {
        return this.allowReload;
    }

    public void allowCaching_$eq(boolean bl) {
        this.allowCaching = bl;
    }

    public boolean allowCaching() {
        return this.allowCaching;
    }

    public /* synthetic */ List load$default$2() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ Map layout$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public /* synthetic */ List layout$default$3() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ List compileSsp$default$2() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ List compileText$default$3() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ List compileScaml$default$2() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ List compile$default$2() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ List generateScala$default$2() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ List canLoad$default$2() {
        return Nil$.MODULE$;
    }

    public /* synthetic */ Map layoutAsNodes$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public /* synthetic */ List layoutAsNodes$default$3() {
        return Nil$.MODULE$;
    }

    public void trace(Function0 fn, Throwable e) {
        Logging$class.trace(this, fn, e);
    }

    public void trace(Function0 fn) {
        Logging$class.trace(this, fn);
    }

    public void debug(Function0 fn, Throwable e) {
        Logging$class.debug(this, fn, e);
    }

    public void debug(Function0 fn) {
        Logging$class.debug(this, fn);
    }

    public void info(Function0 fn, Throwable e) {
        Logging$class.info(this, fn, e);
    }

    public void info(Function0 fn) {
        Logging$class.info(this, fn);
    }

    public void warn(Function0 fn, Throwable e) {
        Logging$class.warn(this, fn, e);
    }

    public void warn(Function0 fn) {
        Logging$class.warn(this, fn);
    }

    public void error(Function0 message, Throwable e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void error(Throwable e) {
        Logging$class.error((Logging)this, e);
    }

    public void error(Function0 fn) {
        Logging$class.error((Logging)this, fn);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CacheEntry
    implements ScalaObject,
    Product,
    Serializable {
        public final /* synthetic */ TemplateEngine $outer;
        private final long timestamp;
        private final Set<String> dependencies;
        private final Template template;

        public CacheEntry(TemplateEngine $outer, Template template, Set<String> dependencies, long timestamp) {
            this.template = template;
            this.dependencies = dependencies;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final /* synthetic */ boolean gd1$1(Template template, Set set, long l) {
            Template template2 = template;
            Template template3 = this.template();
            if (template2 == null) {
                if (template3 != null) {
                    return false;
                }
            } else if (!template2.equals(template3)) return false;
            Set set2 = set;
            Set<String> set3 = this.dependencies();
            if (set2 == null) {
                if (set3 != null) {
                    return false;
                }
            } else if (!set2.equals(set3)) return false;
            if (l != this.timestamp()) return false;
            return true;
        }

        public /* synthetic */ TemplateEngine org$fusesource$scalate$TemplateEngine$CacheEntry$$$outer() {
            return this.$outer;
        }

        public boolean canEqual(Object object) {
            return object instanceof CacheEntry;
        }

        public Object productElement(int n) {
            Object object;
            int temp6 = n;
            switch (temp6) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                case 1: {
                    object = this.dependencies();
                    break;
                }
                case 0: {
                    object = this.template();
                }
            }
            return object;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "CacheEntry";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            long temp5;
            long timestamp$1;
            Set<String> temp4;
            Set<String> dependencies$1;
            if (this == object) return true;
            Object temp1 = object;
            if (!(temp1 instanceof CacheEntry)) return false;
            if (((CacheEntry)temp1).org$fusesource$scalate$TemplateEngine$CacheEntry$$$outer() != this.org$fusesource$scalate$TemplateEngine$CacheEntry$$$outer()) return false;
            CacheEntry temp2 = (CacheEntry)temp1;
            Template temp3 = temp2.template();
            Template template$1 = temp3;
            if (!this.gd1$1(template$1, dependencies$1 = (temp4 = temp2.dependencies()), timestamp$1 = (temp5 = temp2.timestamp()))) return false;
            template$1 = temp3;
            dependencies$1 = temp4;
            boolean bl = ((CacheEntry)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public /* synthetic */ CacheEntry copy(Template template, Set dependencies, long timestamp) {
            return new CacheEntry(this.org$fusesource$scalate$TemplateEngine$CacheEntry$$$outer(), template, (Set<String>)dependencies, timestamp);
        }

        public boolean isStale() {
            return this.dependencies().exists((Function1)new CacheEntry$$anonfun$isStale$1(this));
        }

        public long timestamp() {
            return this.timestamp;
        }

        public Set<String> dependencies() {
            return this.dependencies;
        }

        public Template template() {
            return this.template;
        }

        public /* synthetic */ Template copy$default$1() {
            return this.template();
        }

        public /* synthetic */ Set copy$default$2() {
            return this.dependencies();
        }

        public /* synthetic */ long copy$default$3() {
            return this.timestamp();
        }

        public Iterator productElements() {
            return Product.class.productElements((Product)this);
        }

        public Iterator productIterator() {
            return Product.class.productIterator((Product)this);
        }
    }
}

