/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.layout;

import org.fusesource.scalate.Binding;
import org.fusesource.scalate.RenderContext;
import org.fusesource.scalate.ResourceNotFoundException;
import org.fusesource.scalate.Template;
import org.fusesource.scalate.TemplateEngine;
import org.fusesource.scalate.layout.DefaultLayoutStrategy$;
import org.fusesource.scalate.layout.DefaultLayoutStrategy$$anonfun$org$fusesource$scalate$layout$DefaultLayoutStrategy$;
import org.fusesource.scalate.layout.LayoutStrategy;
import org.fusesource.scalate.util.Logging;
import org.fusesource.scalate.util.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLayoutStrategy
implements LayoutStrategy,
Logging,
ScalaObject {
    private final Seq<String> defaultLayouts;
    private final TemplateEngine engine;

    public DefaultLayoutStrategy(TemplateEngine engine, Seq<String> defaultLayouts) {
        this.engine = engine;
        this.defaultLayouts = defaultLayouts;
        Logging$class.$init$(this);
    }

    private final boolean isLayoutDisabled$1(String layout2) {
        return layout2.trim().isEmpty();
    }

    private None$ noLayout(String body, RenderContext context) {
        context.$less$less(body);
        return None$.MODULE$;
    }

    public final boolean org$fusesource$scalate$layout$DefaultLayoutStrategy$$tryLayout(String layoutTemplate, String body, RenderContext context) {
        boolean exceptionResult1 = false;
        try {
            this.renderLayout(layoutTemplate, body, context);
            exceptionResult1 = true;
        }
        catch (Exception exception) {
            this.error((Function0<String>)new $anonfun$org$fusesource$scalate$layout$DefaultLayoutStrategy$$tryLayout$2(this, exception), (Throwable)exception);
            throw exception;
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            this.debug((Function0<String>)new $anonfun$org$fusesource$scalate$layout$DefaultLayoutStrategy$$tryLayout$1(this, resourceNotFoundException), (Throwable)resourceNotFoundException);
            exceptionResult1 = false;
        }
        return exceptionResult1;
    }

    private void renderLayout(String layoutTemplate$1, String body, RenderContext context) {
        this.debug((Function0<String>)new $anonfun$renderLayout$1(this, layoutTemplate$1));
        context.attributes().update("body", body);
        String string = layoutTemplate$1;
        context.attributes().update("scalateLayouts", ((List)context.attributeOrElse("scalateLayouts", Nil$.MODULE$)).$colon$colon((Object)string));
        this.engine().load(layoutTemplate$1, (List<Binding>)this.engine().load$default$2()).render(context);
        this.debug((Function0<String>)new $anonfun$renderLayout$2(this, layoutTemplate$1));
    }

    @Override
    public void layout(Template template, RenderContext context$1) {
        Some temp2;
        Object temp3;
        String body$1 = context$1.capture(template);
        Option<Object> temp1 = context$1.attributes().get("layout");
        if (temp1 instanceof Some && (temp3 = (temp2 = (Some)temp1).x()) instanceof String) {
            String temp4 = (String)temp3;
            String layout2 = temp4;
            if (this.isLayoutDisabled$1(layout2)) {
                this.noLayout(body$1, context$1);
            } else {
                this.renderLayout(layout2, body$1, context$1);
            }
        } else {
            Option layoutName = this.defaultLayouts().find((Function1)new $anonfun$1(this, context$1, body$1));
            if (layoutName.isEmpty()) {
                this.noLayout(body$1, context$1);
            }
        }
    }

    public Seq<String> defaultLayouts() {
        return this.defaultLayouts;
    }

    public TemplateEngine engine() {
        return this.engine;
    }

    public void trace(Function0 fn, Throwable e) {
        Logging$class.trace(this, fn, e);
    }

    public void trace(Function0 fn) {
        Logging$class.trace(this, fn);
    }

    public void debug(Function0 fn, Throwable e) {
        Logging$class.debug(this, fn, e);
    }

    public void debug(Function0 fn) {
        Logging$class.debug(this, fn);
    }

    public void info(Function0 fn, Throwable e) {
        Logging$class.info(this, fn, e);
    }

    public void info(Function0 fn) {
        Logging$class.info(this, fn);
    }

    public void warn(Function0 fn, Throwable e) {
        Logging$class.warn(this, fn, e);
    }

    public void warn(Function0 fn) {
        Logging$class.warn(this, fn);
    }

    public void error(Function0 message, Throwable e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void error(Throwable e) {
        Logging$class.error((Logging)this, e);
    }

    public void error(Function0 fn) {
        Logging$class.error((Logging)this, fn);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }
}

