/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.support;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.fusesource.scalate.CompilerException;
import org.fusesource.scalate.TemplateException;
import org.fusesource.scalate.support.CompilerError;
import org.fusesource.scalate.support.ScalaCompiler$;
import org.fusesource.scalate.util.ClassPathBuilder;
import org.fusesource.scalate.util.Logging;
import org.fusesource.scalate.util.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.tools.nsc.Global;
import scala.tools.nsc.Settings;
import scala.tools.nsc.reporters.Reporter;

public class ScalaCompiler
implements Logging,
ScalaObject {
    private final Global compiler;
    private final Settings settings;

    public static final boolean init$default$3() {
        return ScalaCompiler$.MODULE$.init$default$3();
    }

    public ScalaCompiler(File bytecodeDirectory, String classpath, boolean combineClasspath) {
        Logging$class.$init$(this);
        this.settings = this.generateSettings(bytecodeDirectory, classpath, combineClasspath);
        this.compiler = new Global(this.settings(), null);
    }

    private Settings generateSettings(File bytecodeDirectory, String classpath, boolean combineClasspath) {
        bytecodeDirectory.mkdirs();
        String pathSeparator = File.pathSeparator;
        String string = classpath;
        ObjectRef useCP$1 = new ObjectRef((Object)(string == null || string.equals(null) || combineClasspath ? new ClassPathBuilder().addPathFromContextClassLoader().addPathFrom(Product.class).addPathFrom(Global.class).addPathFrom(this.getClass()).addPathFromSystemClassLoader().addEntry(classpath).addJavaPath().classPath() : classpath));
        this.debug((Function0<String>)new $anonfun$generateSettings$1(this, useCP$1));
        Settings settings = new Settings((Function1)new $anonfun$1(this));
        settings.classpath().value_$eq((Object)((String)useCP$1.elem));
        settings.outdir().value_$eq(bytecodeDirectory.toString());
        settings.deprecation().value_$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        settings.unchecked().value_$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        return settings;
    }

    public final void org$fusesource$scalate$support$ScalaCompiler$$errorHandler(String message) {
        throw new TemplateException(new StringBuilder().append((Object)"Compilation failed:\n").append((Object)message).toString());
    }

    public void compile(File file) {
        ScalaCompiler scalaCompiler = this;
        synchronized (scalaCompiler) {
            StringWriter messageCollector = new StringWriter();
            PrintWriter messageCollectorWrapper$1 = new PrintWriter(messageCollector);
            ObjectRef messages$1 = new ObjectRef((Object)Nil$.MODULE$);
            $anon$1 reporter = new $anon$1(this, messageCollectorWrapper$1, messages$1);
            this.compiler().reporter_$eq((Reporter)reporter);
            new Global.Run(this.compiler()).compile(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file.getCanonicalPath()})));
            if (reporter.hasErrors()) {
                reporter.printSummary();
                messageCollectorWrapper$1.close();
                throw new CompilerException(new StringBuilder().append((Object)"Compilation failed:\n").append((Object)messageCollector).toString(), (List<CompilerError>)((List)messages$1.elem));
            }
            return;
        }
    }

    public Global compiler() {
        return this.compiler;
    }

    public Settings settings() {
        return this.settings;
    }

    public void trace(Function0 fn, Throwable e) {
        Logging$class.trace(this, fn, e);
    }

    public void trace(Function0 fn) {
        Logging$class.trace(this, fn);
    }

    public void debug(Function0 fn, Throwable e) {
        Logging$class.debug(this, fn, e);
    }

    public void debug(Function0 fn) {
        Logging$class.debug(this, fn);
    }

    public void info(Function0 fn, Throwable e) {
        Logging$class.info(this, fn, e);
    }

    public void info(Function0 fn) {
        Logging$class.info(this, fn);
    }

    public void warn(Function0 fn, Throwable e) {
        Logging$class.warn(this, fn, e);
    }

    public void warn(Function0 fn) {
        Logging$class.warn(this, fn);
    }

    public void error(Function0 message, Throwable e) {
        Logging$class.error(this, message, e);
    }

    public void error(Throwable e) {
        Logging$class.error((Logging)this, e);
    }

    public void error(Function0 fn) {
        Logging$class.error((Logging)this, fn);
    }

    public Logger log() {
        return Logging$class.log(this);
    }
}

